#if !defined (TDESKTOP)                   // To prevent multiple declarations
#define TDESKTOP

// ---- Header Files --------------------------------------------------------

#include "screen.hpp"
#include "tstatusline.hpp"
#include "tmenubar.hpp"


// ---- Class Declarations --------------------------------------------------

class tdesktop
{
   int              deskbackcolor ;               // Desktop background color
   int              deskforecolor ;               // Desktop foreground color
   char             desktexture ;             // ASCII code to create desktop
   char        huge *desktitle ;                             // Desktop title
   int              desktitlebackcolor ;            // Title background color
   int              desktitleforecolor ;            // Title foreground color
   int              desktextmode ;        // Text mode to use to open desktop
   text_info        deskti ;                     // To save screen attributes
   cur_info         deskci ;                     // To save cursor attributes
   char        huge *desksavedscr ;                 // To save screen content
   tstatusline huge *deskslptr ;                     // Ptr to the statusline
   tmenubar    huge *deskmbptr ;                        // Ptr to the menubar
   int              deskstatus ;                            // 0:close 1:open

   int              screenheight ;                          // Current height
   int              screenwidth ;                            // Current width

   public:

        far tdesktop () ;                                      // Constructor
        far ~tdesktop () ;                                      // Destructor

   void far settextmode                                       // Set textmode
      ( int mode ) ;                                  // Textmode code number
   void far setdeskcolors                               // Set desktop colors
      ( int back,                              // Background color of desktop
        int fore ) ;                           // Foreground color of desktop
   void far settexture                                 // Set desktop texture
      ( char asciicode ) ;           // ASCII code of char to use for texture
   void far settitle                                  // Set title of desktop
      ( char huge *text,                                        // Title text
        int back=-1,                             // Background color of title
        int fore=-1 ) ;                          // Foreground color of title
   void far open () ;                            // Setup and display desktop
   void far close () ;                    // Close desktop and restore screen
   void far insert                               // Set ptr to the statusline
      ( tstatusline huge *slptr ) ;                  // Ptr to the statusline
   void far insert                                  // Set ptr to the menubar
      ( tmenubar huge *mbptr ) ;                        // Ptr to the menubar
   void far refresh () ;              // Redraw desktop, statline and menubar

   private:

   void far display () ;                                      // Draw desktop
} ;


// ---- End Header File -----------------------------------------------------

#endif
