#if !defined (TWINDOW)                    // To prevent multiple declarations
#define TWINDOW

// ---- Library Header Files ------------------------------------------------

#include <conio.h>
#include <stdio.h>


// ---- Local Macros --------------------------------------------------------

#define WSAME -1


// ---- Header Files Of Other References ------------------------------------

#include "tstatusline.hpp"


// ---- Type Definitions ----------------------------------------------------

struct ttext                                     // Definition of static text
{
   int        row ;                                  // Row of text in window
   int        col ;                                  // Col of text in window
   char  huge *text ;                                          // Ptr to text
   int        format ;                            // Format specifier of text
   int        fore ;                              // Foreground color of text
   int        back ;                              // Background color of text
   ttext huge *textnext ;                         // Next static text in link
} ;


struct tbutton                                      // Definition of a button
{
   char    huge *buttonname ;                               // Name of button
   int          buttonkey ;              // Key code that 'pushes' the button
   int          buttonrow ;                           // Button row in window
   int          buttoncol ;                           // Button col in window
   int          buttonavail ;         // 1: Button is available  0: Not avail
   char    huge *buttonsltext ;            // Statusline text for this button
   tbutton huge *buttonnext ;                   // Ptr to next button in link
   tbutton huge *buttonprevious ;           // Ptr to previous button in link
} ;


struct tfield                                 // Definition of an input field
{
   int          fieldnumber ;                    // ID # of input field [1..[
   char   huge  *fieldanswer ;                    // Ptr to buffer for answer
   int          fieldanswerlength ;                   // Max length of answer
   int          fieldlength ;                        // Length of input field
   int          fieldrow ;                          // Row of field in window
   int          fieldcol ;                          // Col of field in window
   int          fieldbackcolor ;              // Input field background color
   int          fieldforecoloron ;     // Input field active foreground color
   int          fieldforecoloroff ;  // Input field inactive foreground color
   int          fieldftr ;                     // Filter used for input (0-4)
   char   huge  *fieldxtraftr ;              // Extra chars to use for filter
   int          fieldcapsflag ;                // If '1', switch to uppercase
   int          fieldrestoreflag ;              // If '1', screen is restored
   int          fieldnullflag ;            // If '1', can enter a null string
   char   huge  *fieldsltext ;              // Statusline text for this field
   tfield huge  *fieldnext ;                     // Ptr to next field in link
   tfield huge  *fieldprevious ;             // Ptr to previous field in link
} ;


// ---- Class Declarations --------------------------------------------------

class twindow
{
   char    huge *winunder ;      // Ptr to buffer to save screen under window
   char    huge *winrshadow ;        // Ptr to buffer to save right of window
   char    huge *winrshadowd ;             // Ptr to buffer with right shadow
   char    huge *winbshadow ;       // Ptr to buffer to save bottom of window
   char    huge *winbshadowd ;            // Ptr to buffer with bottom shadow
   char    huge *winfront ;         // Ptr to save window content when hidden
   char    huge *wintitle ;                            // Ptr to window title
   char    huge *winhelp ;          // Pointer to context sensitive help text
   ttext   huge *wintextfirst ;                   // Ptr to first static text
   ttext   huge *wintextlast ;                     // Ptr to last static text
   twindow huge *winnext ;                             // Next window in link
   twindow huge *winprevious ;                     // Previous window in link
   tstatusline huge *winslptr ;          // Ptr to an instantiated statusline
   int          winrow ;                  // Window position (topleft corner)
   int          wincol ;                  // Window position (topleft corner)
   int          winheight ;                          // Window height in rows
   int          winwidth ;                         // Window width in columns
   int          winbackcolor ;                     // Window background color
   int          winforecolor ;                     // Window foreground color
   int          wincurrow ;                      // Cursor position in window
   int          winstatus ;                       // 0:closed 1:open 2:hidden

   int          dfieldanswerlength ;      // Default maximum length of answer
   int          dfieldlength ;                  // Default input field length
   int          dfieldbackcolor ;           // Default field background color
   int          dfieldforecoloron ;         // Default field foreground color
   int          dfieldforecoloroff ;
   int          dfieldftr ;            // Default filter used for input (0-4)
   char    huge *dfieldxtraftr ;    // Default extra chars for current filter
   int          dfieldcapsflag ;              // Default switch for uppercase
   int          dfieldrestoreflag ;            // Default restore after input
   int          dfieldnullflag ;                  // Default null string flag
   int          fieldcount ;                // Number of input fields created
   tfield  huge *fieldfirst ;                          // First field in link
   tfield  huge *fieldlast ;                            // Last field in link

   int          buttonbackcolor ;      // Background color of all the buttons
   int          buttonforecoloron ;      // Foreground color of active button
   int          buttonforecoloroff ;  // Foreground color of inactive buttons
   int          buttonhighcolor ;       // Highlight color of all the buttons
   tbutton huge *buttonfirst ;                        // First button in link
   tbutton huge *buttonlast ;                          // Last button in link

   int          screenheight ;                        // Current screenheight
   int          screenwidth ;                          // Current screenwidth

   public:

        far twindow () ;                                       // Constructor
        far ~twindow () ;                                       // Destructor

   int  far wingetscreenheight () ;                   // Return screen height
   int  far wingetscreenwidth () ;                     // Return screen width
   void far winsetpos                           // Set window screen position
      ( int row,                                       // Top left corner row
        int col ) ;                                    // Top left corner col
   int  far wingetrow () ;                           // Return window row pos
   int  far wingetcol () ;                           // Return window col pos
   void far winsetsize                                     // Set window size
      ( int height,                  // Height of window including the frames
        int width ) ;                 // Width of window including the frames
   int  far wingetheight () ;                         // Return window height
   int  far wingetwidth () ;                           // Return window width
   void far winsetcolors                                 // Set window colors
      ( int back=LIGHTGRAY,                     // Background color of window
        int fore=WHITE ) ;                      // Foreground color of window
   void far winsettitle                                   // Set window title
      ( char huge *title ) ;                           // Ptr to window title
   void far winsethelp                                    // Set help pointer
      ( char huge *ptrtohelp ) ;             // Ptr to context sensitive help
   void far winsetslptr                   // Match window with the statusline
      ( tstatusline huge *slptr ) ;                  // Ptr to the statusline
   void far winopen () ;                 // Open window with current settings
   void far winclose () ;                     // Close window (Perform reset)
   void far winclear                               // Clear an area in window
      ( int left=1,                                        // Top left corner
        int top=1,
        int right=999,                                 // Bottom right corner
        int bottom=999 ) ;
   void far winwrite                        // Writes volatile text to window
      ( char huge *text,                                // Text to be written
        int  row=-1,                               // Window postion for text
        int  col=1,
        int  format=0,                    // 0:none 1:left 2:centered 3:right
        int  fore=-1,                                        // Color of text
        int  back=-1 ) ;
   void far winswrite                         // Writes static text to window
      ( char huge *text,                                // Text to be written
        int  row=-1,                               // Window postion for text
        int  col=1,
        int  format=0,                    // 0:none 1:left 2:centered 3:right
        int  fore=-1,                                        // Color of text
        int  back=-1 ) ;
   void far wintext                             // Display big text in window
      ( char huge *textptr,                    // Ptr to text to be displayed
        int  fore=-1,                      // Normal foreground color of text
        int  high=YELLOW,                          // Highlight color of text
        int  helpflag=1 ) ;         // 0: Don't use 'getkey'  1: Use 'getkey'
   void far wintextfile                             // Disp. a disk text file
      ( char huge *path,                              // Path to file to view
        int  fore=-1,                              // Foreground color to use
        int  high=YELLOW ) ;                        // Highlight color to use
   void far winmove                           // Moves window to new position
      ( int row,                            // New position of topleft corner
        int col ) ;
   void far winscroll                            // Moves window 1 space only
      ( char direction ) ;               // U: up  D: down  L: left  R: right
   int  far wininput () ;         // Get input from window fields and buttons

   void far fieldsetlengths              // Set max lengths of field & answer
      ( int answer,                  // Default max length of answer in chars
        int field ) ;                 // Default max lenght of field in chars
   void far fieldsetcolors                                // Set field colors
      ( int back=-1,                        // Default background field color
        int foreon=WHITE,                   // Default foreground field color
        int foreoff=DARKGRAY ) ;
   void far fieldsetftr                          // Set filter used for input
      ( int ftrtype,                                         // Filter number
        char huge *extra="" ) ;              // Added chars to current filter
   void far fieldsetattrib                            // Set other attributes
      ( int caps=0,                                           // Caplock flag
        int restore=0,                                        // Restore flag
        int empty=1 ) ;                                   // Null string flag
   void far fieldcreate                              // Create an input field
      ( int row,                                        // Row of field input
        int col,                                     // Column of field input
        char huge *defaultasw="",                           // Default answer
        char huge *sltext="" ) ;            // Statusline text for this field
   int  far fieldinput                            // Get input from one field
      ( int fieldnb=1 ) ;                          // Field to get input from
   void far fieldsetasw                    // Copy default answer for a field
      ( char huge *answer,                   // Default answer for this field
        int fieldnb=1 ) ;                        // ID number of field to set
   void far fieldgetasw                   // Copy answer of a field somewhere
      ( char huge *dest,                      // Destination to copy field to
        int fieldnb=1 ) ;                        // ID number of field to get

   void far buttonsetcolors                 // Set colors use for all buttons
      ( int back=GREEN,            // Color used to draw background of button
        int foreon=WHITE,         // Colors used to draw foreground of button
        int foreoff=BLACK,
        int high=YELLOW ) ;            // Color used to draw the button's key
   void far buttoncreate                      // Creates and display a button
      ( int  row,                                    // Row to display button
        int  col,                                    // Col to display button
        char huge *name,                                    // Name of button
        int  buttonkey,                               // Key to 'push' button
        char huge *sltext="" ) ;           // Statusline text for this button
   void far buttonpush                             // Push one of the buttons
      ( int buttonkey ) ;                              // Button to be pushed
   int  far buttoninput                              // Activate button input
      ( int inchar=0,                                           // User input
        int first=1,   // 1: Make 1st button alive  0: Make last button alive
        int tabexit=0 ) ;      // 1: Exit if TAB goes past 1st or last button
   void far buttonsetavail               // Set availability flag of a button
      ( int buttonkey,                                    // Button to be set
        int state ) ;                       // 1: available  0: not available

   private:

   void far buttondraw                                       // Draw a button
      ( int buttonkey,                                      // Button to draw
        int alive=0,                                // 1: Alive  0: Not Alive
        int pushed=0 ) ;                          // 0: Normal pos  1: Pushed
   tbutton huge* buttonexist                    // Check if this button exist
      ( int buttonkey ) ;                           // Key of button to check
   void far winsavescreen () ;        // Save screen under window and shadows
   void far winrestorescreen () ;               // Restore screen and shadows
   void far winhide () ;                                       // Hide window
   void far winunhide () ;                                   // Unhide window
} ;


// ---- End Header File -----------------------------------------------------

#endif
