/*
   Module        : TTOWER.CPP
   Version       : 2.0
   Revision date : July 3rd, 1993
   Author(s)     : Remy Gendron

   Description   : ttower member functions.
*/


// Headers ------------------------------------------------------------------

#include <conio.h>                                      // System's libraries
#include <stdio.h>
#pragma hdrstop

#include "main.hpp"                                          // Other modules
#include "stdfcts.h"
#include "twindow.hpp"

#include "ttower.hpp"                            // This module's header file


// --------------------------------------------------------------------------

ttower::ttower                                                 // Constructor
(
   int           tid,                                           // Tower's ID
   int           trow,               // Tower's bottom left corner's position
   int           tcol,
   int           tcolor,                                     // Tower's color
   twindow huge *twinptr                                // Ptr to work window
)

{
   int loop ;                                                      // Counter


   id = tid ;                                    // Initialises tower's infos
   row = trow ;
   col = tcol ;
   color = tcolor ;
   nb_disks = 0 ;
   for (loop=0 ; loop<=9 ; loop++)
      content[loop] = NULL ;
   winptr = twinptr ;


   return ;                                     // Tower has been initialised
}                                                          // End constructor


// --------------------------------------------------------------------------

ttower::~ttower ()                                              // Destructor

{
   return ;                                                  // Nothing to do
}                                                           // End Destructor


// --------------------------------------------------------------------------

void ttower::show ()                                  // Displays empty tower

{
   int  loop ;                                                     // Counter


   for (loop=0 ; loop<11 ; loop++)                             // Draws shaft
      winptr->winwrite ("",row-12+loop,col+10,0,color) ;

   for (loop=0 ; loop<2 ; loop++)                               // Draws base
      winptr->winwrite ("۲",row-1+loop,col,0,color) ;


   return ;                                       // Tower has been displayed
}                                                         // End ttower::show


// --------------------------------------------------------------------------

int ttower::getrow ()               // Returns tower's bottom left corner row

{
   return row ;                     // Tower's row position has been returned
}                                                       // End ttower::getrow


// --------------------------------------------------------------------------

int ttower::getcol ()               // Returns tower's bottom left corner col

{
   return col ;                     // Tower's col position has been returned
}                                                       // End ttower::getcol


// --------------------------------------------------------------------------

int ttower::getcolor ()                              // Returns tower's color

{
   return color ;                          // Tower's color has been returned
}                                                     // End ttower::getcolor


// --------------------------------------------------------------------------

int ttower::getnbdisks ()             // Returns nb of disks stacked on tower

{
   return nb_disks ;            // Number of disks on tower has been returned
}                                                   // End ttower::getnbdisks


// --------------------------------------------------------------------------

void ttower::pushdisk                                 // Adds a disk to tower
(
   tdisk huge *disk                                     // Ptr to disk pushed
)

{
   assert (nb_disks<10,"ttower::pushdisk","Tower full",1) ;    // Tower full?

   content[nb_disks] = disk ;                                     // One more
   nb_disks++ ;


   return ;                                    // One disk added to the tower
}                                                     // End ttower::pushdisk


// --------------------------------------------------------------------------

void ttower::popdiskto                       // Moves a disk to another tower
(
   ttower huge *target,                           // Ptr to destination tower
   int         speed                                     // Animation's speed
)

{
   assert (nb_disks > 0,"ttower::popdisk","Tower empty",1) ;  // Tower empty?

   content[nb_disks-1]->moveto (target->getrow ()- 2 - target->getnbdisks (),
                                target->getcol (),
                                color,target->getcolor (),speed) ;

   target->pushdisk (content[nb_disks-1]) ;     // Moves disks to other tower
   content[nb_disks-1] = NULL ;                              // One less here
   nb_disks-- ;


   return ;                             // Disk has been moved to other tower
}                                                      // End ttower::popdisk


// End source file ----------------------------------------------------------
