/*
Example of File_cl class usage.

Include file is in directory :
\borlandc\nat\classes\include

Please link with debugging library, for instance LDBORNAT.LIB
*/

#include "\borlandc\nat\classes\include\file_cl.hpp"

#ifdef __BCPLUSPLUS__
// pour Borland C++
#include <alloc.h>
#endif
#include <conio.h>
#ifdef __ZTC__
// Pour Zortech C++
#include <dos.h>	// pour _farptr_norm()
#endif
#include <stdlib.h>
#include <time.h>
#include <stdarg.h>
#include <string.h>

#undef NDEBUG	// in order to use assert()
#include <assert.h>

const int MAX_FIL_TST=20;	// number of files


FILE *ficdbg;	// debugging file
int dbg_depth=0;	// debugging file indentation

// standard abort function
void cdecl die(int err, const char *msg ...)
{
	va_list arg;

	if (err)
		{
		fprintf(stderr, "\n\nERROR :\n");
		va_start(arg, msg);
		vfprintf(stderr, msg, arg);
		va_end(arg);
		while(kbhit())	// flushes keyboard buffer
			getch();
		puts("\nHit a key to continue ...");
		getch();	// thus the user cannot but read the error message
		}
	exit(err);
}

void pascal stop(const char *where)
{
	if (kbhit())
		{
		while (kbhit())
			getch();
		die(3, "BREAK : %s", where);
		}
}

void recurs(char count)
{
	stop("recurse");
	printf("RECURS %d begin\n", count);
	if (count%2)
		recurs(count-1);
	printf("RECURS %d ...\n", count);
	File_cl fil_recurse;
	assert(fil_recurse.assign("REC", NULL)==OK);
	assert(fil_recurse.fwrite("REC", 3, 1)==1);
	if ((!(count%2)) && count)
		recurs(count-1);
	printf("RECURS %d end\n", count);
}

void go2(void)
{
	File_cl tmpgo;

	puts("GO2");
	assert(tmpgo.assign("GO2", NULL)==OK);	// mode NULL : fichier temporaire
	assert(tmpgo.fwrite("Essai", 5, 1)==1);
	puts("GO2 end");
	recurs(9);
/* "tpgo" go out of scope :
associated (temporary) file will be closed and deleted by destructor
*/
}

File_cl fic[MAX_FIL_TST], fic2[MAX_FIL_TST];
void go(void)
{
	OFFSET_T off;
	int rep, rep2, rep3, lu;
	long tmpl;
	File_cl fic_essai, *tmp_new;
	size_t reste;
	unsigned long crc32;

// Init
	puts("FICSTST");
	system("del *.tmp");	// dangerous !
	srand((unsigned int) ((clock()*clock())));

	unsigned long tmpt[16];

// CRC test :

	for (char i=0; i<15; i++)
		tmpt[i]=rand();
	crc32=~crc_32((unsigned char *) tmpt, sizeof(tmpt)-sizeof(unsigned long));
	tmpt[15]=crc32;
	assert(~crc_32((unsigned char *) tmpt, sizeof(tmpt))==0);

	tmp_new=new File_cl;
	assert(tmp_new!=NULL);	// allocation OK ?

	assert(fic_essai.assign("/+.</xyzcaca/<.+", "w")==ERR);	// nom illgal : doit foirer

	for (rep=0; rep<MAX_FIL_TST; rep++)
		{
		assert(fic[rep].assign(NULL, NULL)==OK);	// temporary file
		printf("%s open\n", fic[rep].getName());
		assert(fic2[rep].assign(NULL, NULL)==OK);	// temporary file
		printf("%s open\n", fic2[rep].getName());
		stop("opening");
		}
	rep=0;

#ifdef __ZTC__
	rep3=rand()%20;
#else
	rep3=random(20);
#endif
	for (rep=0; rep<MAX_FIL_TST; rep++)
		{
		tmpl=labs(((long) rand())/20)+21;
		tmpl+=fic[rep].length();
		printf("%d garbage(%ld)\n", rep, tmpl);
		assert(fic[rep].fseek(0, SEEK_END)==0);	//  la fin du fichier
		assert(fic[rep].writeGarbage(tmpl)==OK);	// du garbage
// lecture d'un int  l'offset 0. Doit retourner 1 (nombre d'objets lus)
		assert(fic[rep].fread(&lu, sizeof(int), 1, 0)==1);
// criture d'un octet (le n de fichier)  l'offset "rep3"
		assert(fic[rep].fwrite(&rep, sizeof(int), 1, (long) rep3)==1);
		stop("one");
		}
	for (rep=0; rep<MAX_FIL_TST; rep++)
		assert(fic[rep].fseek(-((long) sizeof(rep)), SEEK_CUR)==0);
	assert(fic[1].whatFile_cl(fic[1].getName()) == _farptr_norm(&fic[1]));
	for (rep=0; rep<MAX_FIL_TST; rep++)
		{
		fic[0].forceClose(1);
		printf("P2 : byte %d, offset %d  %s\n", rep, rep3, fic[rep].getName());
// reads the byte (offset "rep3")
		assert(fic[rep].fread(&lu, sizeof(int), 1, (long) rep3)==1);
// must be the file number
		assert(lu==rep);
// 1/3 of file length
		tmpl=fic[rep].length()/3;
// maximum 9999
		if (tmpl>9999)
			tmpl=9999;
// cut !
		assert(fic[rep].cut(tmpl)==OK);
		stop("two");
		}
	for (rep2=0; rep2<MAX_FIL_TST; rep2++)
		{
		fic[rep2].length(&reste, 3);
		printf("P3 : %d offset 0 %s\n", rep2, fic[rep2].getName());
#ifdef __ZTC__
		rep=rand()%32000;
#else
		rep=random(32000);
#endif
// "rep" will be written at the file beginning
		assert(fic[rep2].fwrite(&rep, sizeof(int), 1, 0L)==1);
// read on file beginning
		assert(fic[rep2].fread(&lu, sizeof(int), 1, 0L)==1);
// value checking
		assert(rep==lu);
		}
#ifdef __ZTC__
	rep=rand()%MAX_FIL_TST;
#else
	rep=random(MAX_FIL_TST);
#endif
	for (rep2=0; rep2<MAX_FIL_TST; rep2++)
		{
		printf("P4 : %s\n", fic[rep2].getName());
// "rep" writing
		assert(fic[rep2].fwrite(&rep, sizeof(int), 1)==1);
		assert(fic[rep2].fseek(-((long) sizeof(rep)), SEEK_CUR)==0);
		assert(fic[rep2].fread(&lu, sizeof(int), 1)==1);	// lecture
		assert(rep==lu);	// et vrification
		if (fic[rep2].length()>1)	// si longueur>1
			{
			// CRC
			assert(fic[rep2].getCRC32(&crc32)==OK);
			printf("%s :\n CRC32 -> %lu (0x%lx)\n", fic[rep2].getName(), crc32, crc32);
			}
		}

	go2();

	File_cl fictmp1;
	unlink("TMPCOP0");
	unlink("TMPCOP00");
// garbage
	assert(fic[0].writeGarbage(900)==0);
// copy in TMPCOP0
	assert(fic[0].copy("TMPCOP0")==OK);
	assert(fictmp1.assign("TMPCOP0", "r")==OK);
// src/dst of last copy comparison
	assert(fic[0].compare(&fictmp1, &off)==OK);
	assert(fictmp1.rename("TMPCOP00")==0);	// attention : rename() renvoie 0 si OK !
// comparison after rename()
	assert(fic[0].compare(&fictmp1, &off)==OK);
// partial comparison
	assert(fic[0].compare(&fictmp1, &off, 260, 260, 513)==OK);
	assert(fictmp1.unlink()==0);

#if NAT_FILE_DEBUG
	fic[0].status(2);
	fic[0].optimiseBuf(10000);
#endif

	puts("END");
	delete tmp_new;

#if NAT_FILE_DEBUG
	for (rep=0; rep<MAX_FIL_TST; rep++)
		{
		fic[rep].status(2);
		fic2[rep].status(2);
		}
#endif
	fclose(ficdbg);
	ficdbg=NULL;
}

void cdecl main(void)
{
	printf("File_cl test : sizeof(File_cl) = %d\n", sizeof(File_cl));
	getch();
	ficdbg=fopen("DEBUG.DBG", "wt");
	if (ficdbg==NULL)
		die(4, "Cannot open the debugging file");
	go();
	puts("\n !!! return !!!");
	die(0, NULL);
}
