//=======================================================================//
// FONTCDLG.CPP released to the public domain 6/6/92 by Bob Bourbonnais  //
//        Demonstrates using a Windows 3.1 Font Common Dialog Box        //
//             with C++ and the Object Windows Class Library             //
//=======================================================================//
#include <owl.h>        // for Object Windows
#include <static.h>     // for static control
#include <dialog.h>     // for dialog boxes
#include <commdlg.h>    // for Win 3.1 Common Dialogs
#include "fontcdlg.h"
//=======================================================================//
_CLASSDEF(TFontDialog)               // Class to encapsulate
class TFontDialog : public TDialog   // the Windows 3.1
  {                                  // Font Common Dialog
  public:
    TFontDialog(PTWindowsObject AParent, // Constructor
		 LOGFONT far * lfNewFont, DWORD * dwNewColor,
		 LPSTR lpName, PTModule AModule);
    virtual BOOL Create();            // Create for non-modal Creation
    virtual int Execute();            // Execute for modal Execution
    #pragma argsused                  // Ignore ARetValue non use
    virtual void CloseWindow(int ARetValue){}; // trap destruction
  protected:
    DWORD * dwColor;                 // Font Color
    CHOOSEFONT fcdlg;                // Font Common Dialog Structure
  };
// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
TFontDialog::TFontDialog(PTWindowsObject AParent, LOGFONT far * lfNewFont,
			 DWORD * dwNewColor, LPSTR AName,
			 PTModule AModule = NULL)
	     :TDialog(AParent,AName,AModule) // Constructor calls base
  {
  dwColor = dwNewColor;     // equate color address to allow updateing
  fcdlg.hDC            = HDC(NULL);             // used for printer fonts
  fcdlg.lStructSize    = sizeof(CHOOSEFONT);    // initialize ccdl struct
  fcdlg.hwndOwner      = GetFocus();            // parent has the focus
  fcdlg.lpLogFont      = lfNewFont;             // LOGFONT structure
  fcdlg.Flags          = CF_SCREENFONTS | CF_EFFECTS; // no printer fonts
  fcdlg.rgbColors      = * dwNewColor;          // Font Color selection
  fcdlg.lCustData      = 0L;                    // Use Default Data
  fcdlg.lpfnHook       = (FARPROC)NULL;         // No Message trapping
  fcdlg.lpTemplateName = (LPSTR)NULL;           // Use Default dialog
  fcdlg.hInstance      = (HANDLE) NULL;         // Not Used
  fcdlg.lpszStyle      = (LPSTR)NULL;           // Used with CF_USESTYLE
  fcdlg.nFontType      = SCREEN_FONTTYPE;       // Screen Font
  fcdlg.nSizeMin       = 0;                     // Used with CF_LIMITSIZE
  fcdlg.nSizeMax       = 0;                     // Used with CF_LIMITSIZE
  };
BOOL TFontDialog::Create()                      // Called by MakeWindow
  {
  fcdlg.hwndOwner = NULL;                       // No parent for non-Model
  ChooseFont(&fcdlg);                           // fcdlg function call
  *dwColor = fcdlg.rgbColors;                   // update color variable
  return 1;                                     // Success
  }
int TFontDialog::Execute()                      // Called by CreateDialog
  {
  ChooseFont(&fcdlg);                           // fcdlg function call
  *dwColor = fcdlg.rgbColors;                   // update color variable
  return 1;                                     // Success
  }
//=======================================================================//
_CLASSDEF(TMyFontStatic)                 // Class derived from a static
class TMyFontStatic : public TStatic
  {
  public:
    TMyFontStatic(PTWindowsObject AParent, int AnId,  // constructor
		 LOGFONT * lfInitFont, DWORD dwInitColor,
		 int X,int Y,int W,int H,
		 LPSTR ATitle, WORD ATextLen,
		 PTModule AModule);
    virtual void ChangeFontIndirect(LOGFONT lfNewFont, // Changes Font
				    DWORD dwNewColor); // and Font Color
  protected:
    char szMyText[80];                                 // Display Text
    HFONT  hFontOld;                                   // Handle to old font
    DWORD   dwFontColor;                               // Font Color
    LOGFONT lfDisplay;                                 // Font Structure
    virtual void WMPaint(RTMessage Msg);               // traps paint message
  };
// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
TMyFontStatic::TMyFontStatic(PTWindowsObject AParent, int AnId,
			   LOGFONT * lfInitFont,DWORD dwInitColor,
			   int X, int Y, int W, int H,
			   LPSTR ATitle = "ABCDEFGHIJKLMNOPQRSTUVWXYZ",
			   WORD ATextLen = 26, PTModule AModule = NULL)
	    :TStatic(AParent, AnId, "", X,Y,W,H, ATextLen, AModule)
  {
  lstrcpy(szMyText,ATitle);         // Copies the Title into output string
  lfDisplay = *lfInitFont;          // initializes font type structure
  dwFontColor = dwInitColor;        // and font color
  }
void TMyFontStatic::ChangeFontIndirect(LOGFONT lfNewFont,DWORD dwNewColor)
  {
  lfDisplay = lfNewFont;            // updates font structure
  dwFontColor = dwNewColor;         // and font color
  InvalidateRect(HWindow,NULL,TRUE);// then forces redraw of control
  }
void TMyFontStatic::WMPaint(RTMessage Msg) // intercept WM_Paint message
  {
  TStatic::WMPaint(Msg);                        // pass along to base class
  HDC hDC     = GetDC(HWindow);                 // grab the Device Contect
  HFONT hFont = CreateFontIndirect(&lfDisplay); // create a new font
  hFontOld    = SelectObject(hDC, hFont);       // select it into display
  SetTextColor(hDC,dwFontColor);                // set the text color
  SetBkMode (hDC, TRANSPARENT);                 // Text Background
  TextOut(hDC,0,0,szMyText,lstrlen(szMyText));  // Output string
  SelectObject(hDC,hFontOld);                   // restore old font
  DeleteObject(hFont);                          // delete font handle
  ReleaseDC(HWindow,hDC);                       // release the DC
  }
//=======================================================================//
_CLASSDEF(TMainDialog)                   // Class derived from a dialog
class TMainDialog : public TDialog       // to add menu and button
  {					 // processing to a main dialog
  public:
    PTMyFontStatic pMyFontControl;      // Pointer for Font Control
    TMainDialog(LPSTR lpName);	        // constructor
    virtual void HandleMenuItem(RTMessage Msg)      // menu handler
      = [CM_FIRST + IDM_FONT];
    virtual void HandleButtonMessage(RTMessage Msg) // button handler
      = [ID_FIRST + IDB_FONT];
  protected:
    DWORD dwFontColor;                              // font color
    LOGFONT lfFont;                                 // font structure
  };
// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
TMainDialog::TMainDialog(LPSTR lpName)              // constructor
      :TDialog(NULL,lpName) 		            // calls base class
  {
  dwFontColor = RGB(0,0,255);                       // blue text
  lfFont.lfHeight = 20;                             // helvetica font
  lfFont.lfWidth  = 8;
  lfFont.lfEscapement = 0;
  lfFont.lfOrientation = 0;
  lfFont.lfWeight = 400;
  lfFont.lfItalic = 0;
  lfFont.lfUnderline = 0;
  lfFont.lfStrikeOut = 0;
  lfFont.lfCharSet = ANSI_CHARSET;
  lfFont.lfQuality = DEFAULT_QUALITY;
  lfFont.lfPitchAndFamily = VARIABLE_PITCH | FF_DONTCARE;
  lstrcpy(lfFont.lfFaceName, "Helv");

  pMyFontControl = new TMyFontStatic(this,ID_RECT,&lfFont, // create new
				     dwFontColor,          // static control
				     22,14,330,120);
  }
void TMainDialog:: HandleMenuItem(RTMessage)          // menu item activates
  {                                                   // non-modal common
  GetApplication()->MakeWindow(new TFontDialog(this,  // font dialog box
			       &lfFont,&dwFontColor,  // to get font info
			       "Main_Window_Dialog"));
  pMyFontControl->ChangeFontIndirect(lfFont,dwFontColor); // change font
  }
void TMainDialog:: HandleButtonMessage(RTMessage)     // button activates
  {                                                   // modal common
  GetApplication()->ExecDialog(new TFontDialog(this,  // font dialog box
		    &lfFont,&dwFontColor,             // to get font info
		    "Main_Window_Dialog"));
  pMyFontControl->ChangeFontIndirect(lfFont,dwFontColor); // change font
  }
//=======================================================================//
class TStandardApp : public TApplication  // Application Class to contain
  {                                       // the application
  public:
    TStandardApp(LPSTR lpName, HANDLE hInstance, // constructor calls the
		HANDLE hPrevInstance,            // base class constructor
		LPSTR lpCmdLine, int nCmdShow)
		:TApplication(lpName, hInstance,
			      hPrevInstance,
			      lpCmdLine, nCmdShow) {};

    virtual void InitMainWindow(); // overrides base class InitMainWindow
  };
// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
void TStandardApp::InitMainWindow() // to initialize a dialog box
  {                                 // as the main window
  MainWindow = new TMainDialog("Main_Window_Dialog");
  }
/*************************************************************************/
int PASCAL WinMain(HANDLE hInstance,              // main entry point from
		   HANDLE hPrevInstance,          // windows to this program
		   LPSTR lpCmdLine , int nCmdShow)
  {
  TStandardApp AppDialog("Dialog Tester",hInstance, // create instance of
		       hPrevInstance,               // the dialog application
		       lpCmdLine,nCmdShow);
  AppDialog.Run();                                  // run it
  return (AppDialog.Status);                        // exit
  }
/*************************************************************************/
//   Remember to use IMPLIB on COMDLG.DLL to create an import library    //
//       And then include the COMMDLG.LIB in the Project Window          //
/*************************************************************************/