// *************************************************************** //
// Filename:    app.cpp                                            //
//                                                                 //
// Date:        November 26, 1993                                  //
//                                                                 //
// Description:                                                    //
// *************************************************************** //

#include "Groups.h"

char *CfgFile;
char *BinPath;

// --------------------------------------------------------------- //
// Application constructor                                         //
// --------------------------------------------------------------- //
TGroupsApp::TGroupsApp() : 
  TApplication() 
{
}

// --------------------------------------------------------------- //
// Application destructor                                          //
// --------------------------------------------------------------- //
TGroupsApp::~TGroupsApp()
{
}

// --------------------------------------------------------------- //
// InitMainWindow                                                  //
// --------------------------------------------------------------- //
void TGroupsApp::InitMainWindow()
{
  SetMainWindow(new TFrameWindow (NULL, 
    "Groups application", 
    new TGroupsWindow(CfgFile, BinPath)));
}

// --------------------------------------------------------------- //
// OwlMain                                                         //
// --------------------------------------------------------------- //
int OwlMain(int argc, char* argv[])
{
  if (argc != 3)
  {
    char buffer[80];
    ::MessageBox(NULL, "Wrong number of arguments.", "Error", MB_OK);
    wsprintf(buffer, "%s [configfile] [bin directory]", argv[0]);
    ::MessageBox(NULL, buffer, "Usage", MB_OK);
    return -1;
  }
  CfgFile = argv[1];
  BinPath = argv[2];
  TGroupsApp app;
  return app.Run();
}

