// *************************************************************** //
// Filename:    Groups.cpp                                        //
//                                                                 //
// Date:        November 26, 1993                                  //
//                                                                 //
// Description:                                                    //
// *************************************************************** //
#include "Groups.h"
#include <fstream.h>
#include <dde.h>

// --------------------------------------------------------------- //
// GroupsWindow constructor                                       //
// --------------------------------------------------------------- //
TGroupsWindow::TGroupsWindow(char *fName, char *bcBinDir) :
  TWindow(0, 0, 0)
{
  DdeState = DDE_NULL;
  HwndProgman = NULL;

  char winDir[256];
  GetWindowsDirectory(winDir, 255);
  if (lstrlen(winDir) == 3)       // root
    winDir[2] = '\0';

  char buffer[256];
  ifstream fin(fName);
  while (fin)
  {
    fin.getline(buffer, 255);
    string tempString;
    for (int i=0; i<lstrlen(buffer); i++)
    {
      if (buffer[i] == '$' && i<lstrlen(buffer)-1)
      {
        switch (buffer[i+1])
        {
          // change $d to Bin directory
          case 'D':
          case 'd':
            i++;
            tempString += bcBinDir;
            break;

          // change $w to Windows directory
          case 'w':
          case 'W':
            i++;
            tempString += winDir;
            break;

          default:
            tempString += buffer[i];
            break;
        }
      }
      else
      {
        tempString += buffer[i];
      }
    }
    Container.Add(MyClass(tempString));
  }
}

// --------------------------------------------------------------- //
// GroupsWindow destructor                                        //
// --------------------------------------------------------------- //
TGroupsWindow::~TGroupsWindow()
{
}

// --------------------------------------------------------------- //
// GetClassName                                                    //
// --------------------------------------------------------------- //
char *TGroupsWindow::GetClassName()
{
  return "GroupsClass";
}

// --------------------------------------------------------------- //
// GetWindowClass                                                  //
// --------------------------------------------------------------- //
void TGroupsWindow::GetWindowClass(WNDCLASS &wc)
{
  TWindow::GetWindowClass(wc);
  wc.hbrBackground = (HBRUSH)GetStockObject(LTGRAY_BRUSH);
}

// --------------------------------------------------------------- //
// SetupWindow                                                     //
// --------------------------------------------------------------- //
void TGroupsWindow::SetupWindow()
{
  TWindow::SetupWindow();
  // put new stuff here
  PostMessage(WUM_START, 0, 0);   // automatically start DDE
}

// --------------------------------------------------------------- //
// CleanupWindow                                                   //
// --------------------------------------------------------------- //
void TGroupsWindow::CleanupWindow()
{
  // put new stuff here
  TWindow::CleanupWindow();
}

// --------------------------------------------------------------- //
// Response table for GroupsWindow                                //
// --------------------------------------------------------------- //
DEFINE_RESPONSE_TABLE1(TGroupsWindow, TWindow)
  EV_WM_PAINT,
  EV_MESSAGE(WUM_START, WumStart),
  EV_MESSAGE(WM_DDE_ACK, OnDdeAck),
END_RESPONSE_TABLE;


// --------------------------------------------------------------- //
// EvPaint                                                         //
// --------------------------------------------------------------- //
void TGroupsWindow::EvPaint()
{
  TPaintDC dc(HWindow);
  TRect rect;
  char *msg = "Installing groups...";

  GetClientRect(rect);
  dc.SetBkMode(TRANSPARENT);
  dc.DrawText(msg, -1, rect, DT_CENTER | DT_VCENTER | DT_SINGLELINE);
}


// --------------------------------------------------------------- //
// WUM_START                                                       //
// --------------------------------------------------------------- //
LRESULT TGroupsWindow::WumStart(WPARAM, LPARAM)
{
  ATOM aApplication = GlobalAddAtom("PROGMAN");
  ATOM aTopic = GlobalAddAtom("PROGMAN");
  DdeState = DDE_INITIATED;
  // find DDE server PROGMAN
  ::SendMessage(HWND(-1), WM_DDE_INITIATE, 
    (WPARAM)HWindow, MAKELPARAM(aApplication, aTopic));
  GlobalDeleteAtom(aTopic);
  GlobalDeleteAtom(aApplication);
  return 0;
}

// --------------------------------------------------------------- //
// TalkToProgman                                                   //
// --------------------------------------------------------------- //
void TGroupsWindow::TalkToProgman()
{
  if (CurrentItem >= Container.GetItemsInContainer())
  {
    DdeState = DDE_TERMINATE;
    ::PostMessage(HwndProgman, WM_DDE_TERMINATE, WPARAM(HWindow), 0);
    PostMessage(WM_CLOSE, 0, 0);
    return;
  }
  string tempString;
  if (CurrentItem == 0)
  {
    // first item in container is a group
    tempString = "[CreateGroup(";
    IteratorType Iterator(Container);
    Iterator.RestartAtTail();
    MyClass mc = Iterator.Current();
    tempString += *mc.GetString();
    tempString += ")]";
  }
  else
  {
    // add item to group
    tempString = "[AddItem(";
    IteratorType Iterator(Container);
    Iterator.RestartAtTail();
    for (int i=0; i<CurrentItem; i++)
      Iterator--;
    MyClass mc = Iterator.Current();
    tempString += *mc.GetString();
    tempString += ")]";
  }
  CurrentItem++;
  const char *cmd = tempString.c_str();
  HGLOBAL hCommand = GlobalAlloc(GMEM_SHARE, lstrlen(cmd)+1);
  char *msg = (char *)GlobalLock(hCommand);
  lstrcpy(msg, cmd);
  GlobalUnlock(hCommand);
  ::PostMessage(HwndProgman, WM_DDE_EXECUTE, 
    WPARAM(HWindow), MAKELPARAM(0, hCommand));
}

// --------------------------------------------------------------- //
// OnDdeAck                                                        //
// --------------------------------------------------------------- //
LRESULT TGroupsWindow::OnDdeAck(WPARAM wParam, LPARAM lParam)
{
  switch (DdeState)
  {
    case DDE_INITIATED:
      HwndProgman = HWND(wParam);
      DdeState = DDE_EXECUTE;
      CurrentItem = 0;
      TalkToProgman();
      break;

    case DDE_EXECUTE:
      GlobalUnlock(HGLOBAL(HIWORD(lParam)));
      GlobalFree(HGLOBAL(HIWORD(lParam)));
      TalkToProgman();
      break;
  }
  return 0;
}
