// *************************************************************** //
// Filename:    Groups.h                                           //
//                                                                 //
// Date:        November 26, 1993                                  //
//                                                                 //
// Description:                                                    //
// *************************************************************** //

#ifndef Groups_H
#define Groups_H

#include <owl\applicat.h>
#include <owl\framewin.h>
#include <owl\gdiobjec.h>
#include <owl\dc.h>
#include <classlib\dlistimp.h>
#pragma hdrstop
#include "Groups.rh"
#include "myclass.h"

typedef TDoubleListImp<MyClass> ContainerType;
typedef TDoubleListIteratorImp<MyClass> IteratorType;
const int WUM_START = WM_USER+0x823;

extern char *CfgFile;
extern char *BinPath;

// --------------------------------------------------------------- //
// GroupsApplication                                              //
// --------------------------------------------------------------- //
class TGroupsApp : public TApplication 
{
  public:
    TGroupsApp();
   ~TGroupsApp();
    void InitMainWindow();
};

// --------------------------------------------------------------- //
// GroupsWindow                                                   //
// --------------------------------------------------------------- //
class TGroupsWindow : public TWindow 
{
  protected:
    enum DdeState_tag 
    {
      DDE_NULL, DDE_INITIATED, DDE_EXECUTE, DDE_TERMINATE 
    };
    DdeState_tag DdeState;
    int CurrentItem;
    HWND HwndProgman;

    void EvPaint();
    ContainerType Container;
    LRESULT WumStart(WPARAM, LPARAM);
    LRESULT OnDdeAck(WPARAM, LPARAM);
    void TalkToProgman();
  public:
    TGroupsWindow(char *, char *);
   ~TGroupsWindow();

    void GetWindowClass(WNDCLASS& wndClass);
    char *GetClassName();
    void SetupWindow();
    void CleanupWindow();
  
    DECLARE_RESPONSE_TABLE(TGroupsWindow);
};

#endif


