// *************************************************************** //
// Filename:    myclass.h                                          //
//                                                                 //
// Date:        November 26, 1993                                  //
//                                                                 //
// Description:                                                    //
//    This header file is provided to demonstrate the container    //
//       class libraries.                                          //
//    This implements the user-defined class.                      //
//    It defines the following member functions:                   //
//       (required for the direct containers)                      //
//     - Copy constructor                                          //
//     - Assignment operator                                       //
//     - comparison operators ( ==, <, != )                        //
//     - HashValue (only needed for the HashTable containers       //
//                                                                 //
//    Define DEBUG to see when the constructors and destructors    //
//       are called. This is useful to track down memory leaks.    //
// *************************************************************** //

#ifndef MYCLASS_H          // prevent header from
#define MYCLASS_H 1        // being included twice

#include <cstring.h>
#include <iostream.h>

class MyClass
{
protected:
  string *str;
public:
  // constructors
  MyClass();
  MyClass(const string s);
  
  // copy constructor
  MyClass(const MyClass &MC);
  
  // destructor
  ~MyClass();
  
  // assignment operator
  MyClass& operator=(const MyClass &MC);
  
  // equality
  int operator==(const MyClass &MC) const;
  int operator!=(const MyClass &MC) const;
  
  // comparison for sorted containers
  int operator<(const MyClass &MC) const;
  
  // for hashtables
  unsigned HashValue() const;
  const string *GetString() const   { return str; }
};

// --------------------------------------------------------------- //
// inline functions for MyClass                                    //
// --------------------------------------------------------------- //
inline MyClass::MyClass()
{
  str = NULL;
#ifdef DEBUG
  cout << "empty MyClass" << endl;
#endif
}

inline MyClass::MyClass(const string s)
{
  str = new string(s);
#ifdef DEBUG
  cout << "Con string " << *str << endl;
#endif
}

inline MyClass::MyClass(const MyClass &MC)
{
  if (MC.str)
    str = new string(*MC.str);
  else
    str = NULL;
#ifdef DEBUG
  cout << "Copy string " << *str << endl;
#endif
}

inline MyClass::~MyClass()
{
  if (str)
  {
#ifdef DEBUG
    cout << "Des string " << *str << endl;
#endif
    delete str;
  }
  else
  {
#ifdef DEBUG
    cout << "Des empty MyClass" << endl;
#endif
  }
}

inline MyClass& MyClass::operator=(const MyClass &MC)
{
  if (str != NULL)
    delete str;
  if (MC.str)
    str = new string(*MC.str);
  else
    str = NULL;
  return *this;
}

inline int MyClass::operator==(const MyClass &MC) const
{
  return (*str == *MC.str);
}

inline int MyClass::operator!=(const MyClass &MC) const
{
  return (!(*this == MC));
}

inline int MyClass::operator<(const MyClass &MC) const
{
  return (*str < *MC.str);
}

inline unsigned MyClass::HashValue() const
{
  unsigned Hash = 0;
  if (str == NULL)
    return 0;
  for (int i=0; i<str->length(); i++)
    Hash += unsigned((*str)[i]);
  return Hash;
}

#endif
