/*************************************************************************
 *              Graphical User Interface Utility Version 1.00            *
 *************************************************************************
 *                      Programmed by Dan Watling                        *
 *************************************************************************
 * This is my 2nd utility that I have written for Borland C++ that makes *
 * writing programs much easier. All you have to do is just link this    *
 * into your program, by doing the following steps:                      *
 * 1. #include "gui2.h"/<gui2.h> in your program                         *
 * 2. Make a project file.                                               *
 *  a. Select the Project menu                                           *
 *  b. Select Open Project                                               *
 *  c. Type in the name that you want your .EXE file to be               *
 * 3. Press the INSERT key and get this program from where ever you have *
 *    it, and then get your program where ever it may be.                *
 *************************************************************************
 * That's all there is to it! If you would like to have updated versions *
 * of THIS program, please send $15.00 to:                               *
 *      Dan Watling                                                      *
 *      3408 Walkup Road                                                 *
 *      Crystal Lake, Illinois                                           *
 *      60012-1109                                                       *
 *                                                                       *
 * If you do register this program, you will be entitled to ALL future   *
 * versions, like some mouse routines for this program, and a couple of  *
 * other interesting things I plan on adding, and you will get a list of *
 * programmers utilities that I have made along with the registered      *
 * program files. Plus, you will get the source code for Draw.exe!       *
 *************************************************************************
 *                    I hope you enjoy this program!                     *
 * I would also like to hear from you! Please write to me for any        *
 * comments, suggestions, questions, etc.                                *
 *************************************************************************
/                                                                       */

#include <conio.h>
#include <graphics.h>
#include <alloc.h>
#include <dos.h>
#include <stdlib.h>
#include <gui.h>


void cls(int color)
{
 setfillstyle(SOLID_FILL,color);
 bar(0,0,getmaxx(),getmaxy());
}

void shadowtext(int x, int y,const char far *text,int color)
{
 setcolor(8);
 outtextxy(x+1,y+1,text);

 setcolor(color);
 outtextxy(x,y,text);
}

void multispray(int x, int y)
 {
  int pos;

  pos = random(22);

 int color;

 color = random(16);

 if (pos == 1)
  {
   putpixel(x-1,y-2,color);
  }
 if (pos == 2)
  {
   putpixel(x,y-2,color);
  }
 if (pos == 3)
  {
   putpixel(x+1,y-2,color);
  }
 if (pos == 4)
  {
   putpixel(x-2,y-1,color);
  }
 if (pos == 5)
  {
   putpixel(x-1,y-1,color);
  }
 if (pos == 6)
  {
   putpixel(x,y-1,color);
  }
 if (pos == 7)
  {
   putpixel(x+1,y-1,color);
  }
 if (pos == 8)
  {
   putpixel(x+2,y-1,color);
  }
 if (pos == 9)
  {
   putpixel(x-2,y,color);
  }
 if (pos == 10)
  {
   putpixel(x-1,y,color);
  }
 if (pos == 11)
  {
   putpixel(x,y,color);
  }
 if (pos == 12)
  {
   putpixel(x+1,y,color);
  }
 if (pos == 13)
  {
   putpixel(x+2,y,color);
  }
 if (pos == 14)
  {
   putpixel(x-2,y+1,color);
  }
 if (pos == 15)
  {
   putpixel(x-1,y+1,color);
  }
 if (pos == 16)
  {
   putpixel(x,y+1,color);
  }
 if (pos == 17)
  {
   putpixel(x+1,y+1,color);
  }
 if (pos == 18)
  {
   putpixel(x+2,y+1,color);
  }
 if (pos == 19)
  {
   putpixel(x-1,y+2,color);
  }
 if (pos == 20)
  {
   putpixel(x,y+2,color);
  }
 if (pos == 21)
  {
   putpixel(x+1,y+2,color);
  }
}

void spray(int x, int y,int color)
{
 int pos;

 pos = random(22);

 if (pos == 1)
  {
   putpixel(x-1,y-2,color);
  }
 if (pos == 2)
  {
   putpixel(x,y-2,color);
  }
 if (pos == 3)
  {
   putpixel(x+1,y-2,color);
  }
 if (pos == 4)
  {
   putpixel(x-2,y-1,color);
  }
 if (pos == 5)
  {
   putpixel(x-1,y-1,color);
  }
 if (pos == 6)
  {
   putpixel(x,y-1,color);
  }
 if (pos == 7)
  {
   putpixel(x+1,y-1,color);
  }
 if (pos == 8)
  {
   putpixel(x+2,y-1,color);
  }
 if (pos == 9)
  {
   putpixel(x-2,y,color);
  }
 if (pos == 10)
  {
   putpixel(x-1,y,color);
  }
 if (pos == 11)
  {
   putpixel(x,y,color);
  }
 if (pos == 12)
  {
   putpixel(x+1,y,color);
  }
 if (pos == 13)
  {
   putpixel(x+2,y,color);
  }
 if (pos == 14)
  {
   putpixel(x-2,y+1,color);
  }
 if (pos == 15)
  {
   putpixel(x-1,y+1,color);
  }
 if (pos == 16)
  {
   putpixel(x,y+1,color);
  }
 if (pos == 17)
  {
   putpixel(x+1,y+1,color);
  }
 if (pos == 18)
  {
   putpixel(x+2,y+1,color);
  }
 if (pos == 19)
  {
   putpixel(x-1,y+2,color);
  }
 if (pos == 20)
  {
   putpixel(x,y+2,color);
  }
 if (pos == 21)
  {
   putpixel(x+1,y+2,color);
  }
}

void drawbutton(int x, int y, int mx, int my, int namecolor, const char far *name, int shadowed)
{
 setfillstyle(SOLID_FILL,7);
  bar(x,y,mx,my);

 setcolor(15);
  rectangle(x+1,y+1,x+1,my-1);
  rectangle(x+2,y+1,x+2,my-2);
  rectangle(x+1,y+1,mx-1,y+1);
  rectangle(x+1,y+2,mx-2,y+2);

 setcolor(8);
  rectangle(x+1,my-1,mx-1,my-1);
  rectangle(x+2,my-2,mx-1,my-2);
  rectangle(mx-2,my-1,mx-1,y+2);
  rectangle(mx-1,my-1,mx-1,y+1);
  setcolor(0);

 int bmidx, bmidy;

if (shadowed == 1)
 {

  bmidx = (mx / 2) + (x / 2) + 1;
  bmidy = (my / 2) + (y / 2) + 1;

 settextjustify(CENTER_TEXT,CENTER_TEXT);

 setcolor(8);
  outtextxy(bmidx,bmidy,name);

}

  bmidx = (mx / 2) + (x / 2);
  bmidy = (my / 2) + (y / 2);

 settextjustify(CENTER_TEXT,CENTER_TEXT);

 setcolor(namecolor);
  outtextxy(bmidx,bmidy,name);

 rectangle(x,y,mx,my);
}

void drawfilledbutton(int x, int y, int mx, int my, int color, int namecolor, const char far *name, int shadowed)
{
 setfillstyle(SOLID_FILL,color);
  bar(x+2,y+2,mx-2,my-2);

 setcolor(15);
  rectangle(x+1,y+1,x+1,my-1);
  rectangle(x+2,y+1,x+2,my-2);
  rectangle(x+1,y+1,mx-1,y+1);
  rectangle(x+1,y+2,mx-2,y+2);

 setcolor(8);
  rectangle(x+1,my-1,mx-1,my-1);
  rectangle(x+2,my-2,mx-1,my-2);
  rectangle(mx-2,my-1,mx-1,y+2);
  rectangle(mx-1,my-1,mx-1,y+1);

  int bmidx, bmidy;

if (shadowed == 1)
 {

  bmidx = (mx / 2) + (x / 2) + 1;
  bmidy = (my / 2) + (y / 2) + 1;

 settextjustify(CENTER_TEXT,CENTER_TEXT);

 setcolor(8);
  outtextxy(bmidx,bmidy,name);

 }

  bmidx = (mx / 2) + (x / 2);
  bmidy = (my / 2) + (y / 2);

 settextjustify(CENTER_TEXT,CENTER_TEXT);

 setcolor(namecolor);
  outtextxy(bmidx,bmidy,name);

 setcolor(0);
  rectangle(x,y,mx,my);
}

void drawclickedbutton(int x, int y, int mx, int my, int namecolor, const char far *name, int shadowed)
{
 setfillstyle(SOLID_FILL,7);
    bar(x,y,mx,my);

 setcolor(8);
  rectangle(x+1,y+1,x+1,my-1);
  rectangle(x+2,y+1,x+2,my-2);
  rectangle(x+1,y+1,mx-1,y+1);
  rectangle(x+1,y+2,mx-2,y+2);


 setcolor(15);
  rectangle(x+1,my-1,mx-1,my-1);
  rectangle(x+2,my-2,mx-1,my-2);
  rectangle(mx-2,my-1,mx-1,y+2);
  rectangle(mx-1,my-1,mx-1,y+1);


 int bmidx, bmidy;

if (shadowed == 1)
 {

  bmidx = (mx / 2) + (x / 2) + 3;
  bmidy = (my / 2) + (y / 2) + 3;

 settextjustify(CENTER_TEXT,CENTER_TEXT);

 setcolor(8);
  outtextxy(bmidx,bmidy,name);


  bmidx = (mx / 2) + (x / 2);
  bmidy = (my / 2) + (y / 2);

 settextjustify(CENTER_TEXT,CENTER_TEXT);

 setcolor(namecolor);
  outtextxy(bmidx,bmidy,name);
 }

if (shadowed == 0)
 {
  bmidx = (mx / 2) + (x / 2) + 2;
  bmidy = (my / 2) + (y / 2) + 2;

  settextjustify(CENTER_TEXT,CENTER_TEXT);

  setcolor(namecolor);
   outtextxy(bmidx,bmidy,name);
 }


 setcolor(0);
  rectangle(x,y,mx,my);
}

void drawclickedfilledbutton(int x, int y, int mx, int my, int color, int namecolor, const char far *name, int shadowed)
{
 setfillstyle(SOLID_FILL,color);
  bar(x+2,y+2,mx-2,my-2);

 setcolor(8);
  rectangle(x+1,y+1,x+1,my-1);
  rectangle(x+2,y+1,x+2,my-2);
  rectangle(x+1,y+1,mx-1,y+1);
  rectangle(x+1,y+2,mx-2,y+2);
 setcolor(15);
  rectangle(x+1,my-1,mx-1,my-1);
  rectangle(x+2,my-2,mx-1,my-2);
  rectangle(mx-2,my-1,mx-1,y+2);
  rectangle(mx-1,my-1,mx-1,y+1);

  int bmidx, bmidy;

if (shadowed == 1)
 {
  bmidx = (mx / 2) + (x / 2) + 3;
  bmidy = (my / 2) + (y / 2) + 3;

 settextjustify(CENTER_TEXT,CENTER_TEXT);

 setcolor(8);
  outtextxy(bmidx,bmidy,name);

  bmidx = (mx / 2) + (x / 2);
  bmidy = (my / 2) + (y / 2);

 settextjustify(CENTER_TEXT,CENTER_TEXT);

 setcolor(namecolor);
  outtextxy(bmidx,bmidy,name);

 }

if (shadowed == 0)
 {
  bmidx = (mx / 2) + (x / 2) + 1;
  bmidy = (mx / 2) + (x / 2) + 1;

 settextjustify(CENTER_TEXT,CENTER_TEXT);

 setcolor(namecolor);
  outtextxy(bmidx,bmidy,name);
 }

setcolor(0);
  rectangle(x,y,mx,my);
}

void drawvertscrollbar(int x, int y, int length)
{
 setfillstyle(SOLID_FILL,7);
  bar(x,y,x+14,length);

 setcolor(0);
  rectangle(x,y,x+14,length);
  rectangle(x,y,x+14,y+14);
  rectangle(x,length-14,x+14,length);

 drawbutton(x,y,x+14,y+14,0,"",FALSE);
 drawbutton(x,length-14,x+14,length,0,"", FALSE);
}

void drawhorzscrollbar(int x, int y, int length)
{
 setfillstyle(SOLID_FILL,7);
  bar(x,y,length,y+14);

 setcolor(0);
  rectangle(x,y,length,y+14);
  rectangle(x,y,x+14,y+14);
  rectangle(x,y,length-14,y+14);

 drawbutton(x,y,x+14,y+14,0,"",FALSE);
 drawbutton(length-14,y,length,y+14,0,"",FALSE);
}

void drawscrollbox(int x, int y)
{
 drawbutton(x,y,x+14,y+14,0,"", FALSE);
}

void drawwindow(int x, int y, int mx, int my, const char far *title, int scrollbar)
{
 setfillstyle(SOLID_FILL,15);
  bar(x,y,mx,my);

 setfillstyle(SOLID_FILL,1);
  bar(x+16,y,mx,y+16);

 int bmaxx, bmaxy;
  bmaxx = (mx / 2) + (x / 2);
  bmaxy = ((y / 2) + 5) + ((y / 2) + 5);

 settextjustify(CENTER_TEXT,CENTER_TEXT);

 setcolor(15);
  outtextxy(bmaxx,bmaxy,title);

 setcolor(0);
  rectangle(x,y,mx,my);
  rectangle(x,y,x+16,y+16);
   rectangle(x+4,y+6,x+12,y+9);
  rectangle(x+16,y,mx,y+16);

 setcolor(8);
   line(x+6,y+10,x+13,y+10);
   line(x+13,y+10,x+13,y+7);

if (scrollbar == 1)
 {
  drawhorzscrollbar(x,my-14,mx-14);
  drawvertscrollbar(mx-14,y+16,my-14);
 }
}

void textfield(x, y, mx, my)
{
 setcolor(0);
 rectangle(x,y,mx,my);
}

void drawmenu(void *menuname, int x, int y, int type)
{
 putimage(x,y,menuname,type);
}

void getmenu(void *menuname, int x, int y, int mx, int my)
{
 int imsize;
 imsize = imagesize(x, y, mx, my);
 menuname = malloc(imsize);
 getimage(x,y,mx,my,menuname);
}