#include <dos.h>
#include <string.h>
#include <graphics.h>
#include <stdarg.h>
#include <stdio.h>

#define TRUE 1
#define FALSE 0
#define IN 0
#define OUT 1
#define THICK 0
#define THIN 1
#define TEXT 0
#define IMAGE 1


//**************************   Graphic Objects   **************************

class Point
{
	protected:
		int x,y,color;
		viewporttype vref;
	public:
		Point();
		void move(int ptx,int pty);
		virtual void draw();
		void create(int ptx,int pty,int c);
		void restoreviewport();
		void Setcolor(int c);
		virtual void setloc(int ptx,int pty);
		virtual void erase();
		int Getcolor();
		int Getx();
		int Gety();
};

//************************************************************************

class Colorbutton:public Point
{
	protected:
		int color;
		int width;
		int height;
	public:
		void init(int,int,int,int,int);
		void show(int);
		int  hit();
		int getcolor();
	};

//************************************************************************

class Icon:public Point
{
	protected:
		int state;
	public:
		void far *picture;
		Icon();
		~Icon();
		void init(int,int,char*);
		void show();
		void choose();
		int hit();
		int ispressed();
	};

//************************************************************************

class Acticon:public Icon
{
	protected:
		void *picture[32];
		int state;
		int numpix;
	public:
		Acticon();
		~Acticon();
		void init(int,int,char*);
		void show(int);
		void choose();
		int ispressed();
		void animate(int);
		void backforth(int);
	};

//************************************************************************

class Button:public Point
{
	protected:
		int state,sizex,sizey;
		char btntxt[40];
		int  file_text;
		void *picture;
		void getpic(char*);
	public:
		Button();
		~Button();
		virtual void show();
		virtual void press();
		void init(int ptx,int pty,char* text,int);
		virtual void erase();
		virtual void move(int ptx,int pty);
		void setstate(int bstate);
		void invert();
		int hit();
};

//************************************************************************

class Panel:public Point
{
	protected:
		int w;
		int h;
		int in_or_out;
		int thick_or_thin;
	public:
		Panel();
		~Panel();
		virtual void show();
		void init(int,int,int,int,int,int);
};

//************************************************************************

class Bevel:public Point
{
	private:
		int w;
		int h;
		int thick_or_thin;
		Panel outerbevel;
		Panel innerbevel;
	public:
		void init(int,int,int,int,int);
		virtual void show();
};

//*******************************   Graphics Menus  **********************

typedef char gitemarray[80][10];

class Gmenu {
	protected:
		int on;
		int x,y,w,h;
		int num;
		gitemarray gitems;
		int menuchoice;
		int oldbarx,oldbary;
		void *ptr;
		void *menubar;
	public:
		Gmenu();
		~Gmenu();
		void init(int xloc,int yloc,int numentries,gitemarray gitem);
		int show();
		void hide();
		int isshown();
};

//*************************************************************************

class Gmenubutton {
	protected:
		int on;
		int x,y;
		int offfgd,offbgd;
		int onfgd,onbgd;
		char id[20];
	public:
		Gmenubutton();
		~Gmenubutton();
		void init(int xloc,int yloc,int ffgd,int fbgd,int nfgd,int nbgd,char txt[20]);
		void show();
		void press();
		int hit();
};

//*****************************   Graphic text output   *******************

void gprintf(int *xloc,int *yloc,char *fmt,...);
void gprintc(int *xloc, int *yloc, char *fmt,...);
void gprintxy(int xloc,int yloc,char *fmt,...);

//************************  Library Support functions  *********************

void vprintat(int cols,int rows,int fore,int back,char *,...);
void vprintc(int row,int fore,int back,char *,...);
void printat(int,int,int,int,char *);
void printc(int,int,int,char *);
void cprintat(int,int,int,int,char *,...);
void cprintc(int,int,int,char *,...);
void clear(char ch,int fore,int back);
void cursoroff();
void cursoron();
void settext(int,int);
void chsattr(int,int);
void chcattr(int,int,int,int,int);
void dlay(int ticks);
long getticks();
unsigned char getvidmode();
void screenbord(int);
int altkey();
int ctrlkey();
int lshiftkey();
int rshiftkey();
void disable_blink();
void enable_blink();
void disable_refresh();
void enable_refresh();
void flushkeys();


//*************************** String Objects   ****************************

class Tstring {
	protected:
		char laststring[81];
		char bar[81];
		int xpos;
		int x;
		int y;
		int length;
		int ucase;
		int escape;
		int retrn;
		int tab;
		int uparrow;
		int dnarrow;
		int shown;
		int barred;
		int firstchar;
		int infgd;
		int inbgd;
	public:
		Tstring();
		~Tstring();
		void init(int xloc,int yloc,int len,int uppercase);
		void show();
		void input();
		void get_input();
		void get_form_input();
		void get_form_mouse_input();
		void reset();
		void preset(char *);
		void erase(int);
		char *getstring();
		int escapehit();
		int returnhit();
		int tabhit();
		int uparrowhit();
		int dnarrowhit();
		int isshown();
		int isbarred();
		int hit();
		void setincolors(int,int);
};

//**************************************************************************

class Gstring:public Tstring {
	protected:
		int curpos;
		int curson;
		void showcurs();
		void hidecurs();
	public:
		void init(int,int,int,int);
		void show();
		void input();
		void get_input();
		void get_form_input();
		void reset();
		int isshown();
		void check_for_blink();
};

//************************  Mouse functions  ******************************

typedef struct {
		int m1,m2,m3,m4;
		} mparams;


void mouse(mparams *p);

extern int _Cdecl button;
extern int _Cdecl status;
extern int _Cdecl count;
extern int _Cdecl xpos;
extern int _Cdecl ypos;

int mouse_init(void);
void show_cursor(void);
void hide_cursor(void);
void get_status(int *button, int *curx, int *cury);
void pos_mouse(int x, int y);
void b_press(int btn, int *bnow, int *bcount, int *x, int *y);
void sethbounds(int l, int r); /* set left and right boundaries */
void setvbounds(int t, int b); /*set top and bottom bounds */
void setgraphics(int hspot, int vspot, void far *cmask);
void setspeed(int x, int y);
void set_threshold(int);
void set_subroutine(int,void (far *)(void));
void b_release(int,int *,int *,int *,int *);
void settext(int,int,int);
void motion(int *,int *);
void light_pen(int);
void conditional_off(int,int,int,int);
int leftmousekeypressed();
int rightmousekeypressed();
