/************************************************************************
   Example of installing an interrupt function in a C++ program.
************************************************************************/
#pragma option -w -w-par
#include <conio.h>
#include <dos.h>

typedef void interrupt (*cast_isr) (...);
void install(void interrupt (*faddr)(...), int inum);
void interrupt mybeep(unsigned, unsigned, unsigned, unsigned,
            unsigned, unsigned, unsigned, unsigned, unsigned);
void testbeep(unsigned char bcount, int inum);
//-----------------
int main(void)
{
   install( (cast_isr)mybeep, 10);
   testbeep(3,10);
   cputs("beep");
   return 0;
}
//-----------------
void install(void interrupt (*faddr)(...), int inum)
{
    setvect(inum, faddr);
}
//-----------------
void interrupt mybeep(unsigned bp, unsigned di, unsigned si,
                      unsigned ds, unsigned es, unsigned dx,
                      unsigned cx, unsigned bx, unsigned ax)
{
   int i, j;
   char originalbits, bits;
   int bcount = 2000;

   bits = originalbits = inportb(0x61);
   for (i = 0; i <= bcount; i++)
   {  outportb(0x61, bits & 0xfc);
      for (j = 0; j <= 300; j++);
      outportb(0x61, bits | 2);
      for (j=0; j<=300; j++);
   }
   outportb(0x61, originalbits);
}
//-----------------
void testbeep(unsigned char bcount, int inum)
{
   _AH = bcount;
   geninterrupt(inum);
}
