//////////////////////////////////////////////////////////////////////////////
//                                                                          //
//                             example1 of ISC...                           //
//                             ------------------                           //
//                                                                          //
//  - Put an isr on timer tick which increments the top left char on vga/ega//
//    screens! (dynamicly created with new.                                 //
//                                                                          //
//  - Put an isr on keyboard interrupts that increments on every press or   //
//    release of any key, 1 char right of the first isr. (static).          //
//                                                                          //
//  - test for the same program in memory, if already resident - get out    //
//    with an error.                                                        //
//  - if not resident already, activate isr and stay resident with about    //
//       10KB in memory.                                                    //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////
//                                                                          //
//                       By:- Ofer Laor (AKA LeucroTTa)                     //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////

#include "isc.h"   // ISC.
#include <stdio.h> // printf.

#include <dos.h>; // keep

class SHOW_TICKS: public ISC {
      virtual void isr(void);
};

void SHOW_TICKS::isr(void)
{
    old_vect();
    (*((char far *)0xb8000000L))++;
}

class SHOW_KEYS: public ISC {
      virtual void isr(void);
};

void SHOW_KEYS::isr(void)
{
    old_vect();
    (*((char far *)0xb8000002L))++;
}

SHOW_KEYS keys;

int main()
{
    // check if program is already resident...
    // use as parameter - the name of the program.
    // - note you can check for other programs in mem too (under DOS >= 4.0)
    //   by putting the .exe name (capital letters)- as is_TSR param!
    //
    if (ISC::is_TSR("EXAMPLE1")) {
       printf("Error: already resident!\n\a");
       return 1;
    }

    (new SHOW_TICKS)->activate(0x8); // this is the object that hooks the interrupt.

    keys.activate(0x9);


    ISC::TSR(0); // try and stay resident.
    printf("Error: could not stay resident!\n\a");
    return 2;
}