/* This example creates a DoubleList and two iterators for the list; one
   at the head, the other at the Tail, of the list. Actions on the list
   ( such as a delete or detach ) will NOT be automatically reflected in
   the iterators, which can lead to situations where the 'current' object
   for the iterator is not still in the list. This can be avoided by
   creating and deleting iterators as needed or making a call to restart()
   to reset the list.
   */

#include <strng.h>
#include <dbllist.h>


main()
{
 String *s1 = new String("one");
 String *s2 = new String("two");
 String *s3 = new String("three");
 String *s4 = new String("four");
 String *s5 = new String("five");
 DoubleList *dlist = new DoubleList;
 dlist->add(*s1);
 dlist->add(*s2);
 dlist->add(*s3);
 dlist->add(*s4);
 dlist->add(*s5);
 // show the list
 cout << *dlist << endl;
 DoubleListIterator HeadIter(*dlist,1);// start at head
 DoubleListIterator TailIter(*dlist,0);// start at tail
 // do an increment and decrement so both iterators have the same 'current'
  for( int i=0; i<2; i++ )
  {
   HeadIter++;
   TailIter--;
  }
  cout << HeadIter.current() << endl;
  cout << TailIter.current() << endl;

 dlist->detachFromHead( *s3 ); // remove the current object
 // show the list
 cout << *dlist << endl;
 // Note that without the following two calls to reset the iterators,
 // the 'current' object no longer is in the list
  HeadIter.restart();
  TailIter.restart();
  for(  i=0; i<2; i++ )
  {
   HeadIter++;
   TailIter--;
  }
 // the change in the list is now reflected by the iterators...
 cout << HeadIter.current() << endl;
 cout << TailIter.current() << endl;
 return 0;
}

