
/*
	This file demonstrates the use of the ..Iterator.. template of the
	BIDS class library.

	Two items of interest:

		Make sure that the data type of the iterator is the
		same as the data type of the container class: list,
		array, hashtable, Btree, and Doublelist. Iterators
		will also work on classes derived from the container
		classes.

		You are also required to pass an instance of the
		container class to the constructor of the iterator.

*/

#include <stdio.h>
#include <arrays.h>
#include <iostream.h>
#include <listimp.h>
#include <conio.h>
#include <strng.h>
#include <string.h>
#include <malloc.h>

class MyClass  {

   String str;

public:

   MyClass(void) : str() { }
   MyClass(char *s) :  str(s) { }

   void PrintIt(void) { printf("%s",(const char *)str); }

   int operator==(const MyClass & xx) const;

   int operator<(const MyClass & xx) const;

   friend ostream& operator<<( ostream &, MyClass & ) ;

};

ostream& operator<<( ostream &os, MyClass &om ) {
		os << (const char *)om.str ;
		return os ; }

int MyClass::operator==(const MyClass & xx) const
{
    int j ;
    if ( 0 == strcmp( (const char *)str, (const char *)xx.str )  )
    {
	j = 1 ;
    } else {
	j = 0 ;
    }
    return j;
}

int MyClass::operator<(const MyClass & xx) const
{
    int j ;
    if ( 0 > strcmp( (const char *)str, (const char *)xx.str ) )
    {
	j = 1 ;
    } else {
	j = 0 ;
    }
    return j;
}

typedef BI_ISListImp<MyClass> list ;
typedef BI_IListIteratorImp<MyClass> iterator ;

int main ( void )
{
	list foo ;
	iterator bar(foo) ;  // Create an iterator for ListImp instance foo

	// Create the objects to place in the list

	MyClass one("this")     ;
	MyClass two("will be.")     ;
	MyClass three("in") ;
	MyClass four("alphabetical")   ;
	MyClass ten("order")     ;

	// Add objects to the list

	foo.add( &one ) ;
	foo.add( &two ) ;
	foo.add( &three ) ;
	foo.add( &four ) ;

	clrscr() ;
	for (int i=0; i< 2 ; i++)
	{
		cout << "Loop #" << (i + 1 ) << endl << endl ;
		bar.restart() ;     // Start list from beginning
		while( (int)bar )   // loop until end of list
		{
			cout << *(MyClass *)(bar.current()) << endl ;
			bar++ ;
		}
		cout << endl ;
		// Add a new item to the list
		foo.add( &ten ) ;
	}

	return 0 ;
}

/*
	DISCLAIMER: You have the right to use this Technical Information
	subject to the terms of the No-Nonsense License Statement that you
	received with he Borland Product to which this information
	pertains.

	Although it is believed that this program works as claimed, we do
	not make any guarantees as to its functionality or correctness.
*/