/*===========================================================================
*
* Module:   MAIN.C
*
* Desc:     
*
*
---------------------------------------------------------------------------*/

#include <process.h>
#include <alloc.h>
#include <bios.h>
#include <conio.h>
#include <dos.h>
#include <math.h>
#include <dir.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <graphics.h>
#include <fcntl.h>
#include <sys\stat.h>

void    main(void);
void    calc_lorenz(void);
void    plot_lorenz(void);
void    Initialize(void);

int     GraphDriver;         /* The Graphics device driver       */
int     GraphMode;           /* The Graphics mode value      */
double  AspectRatio;         /* Aspect ratio of a pixel on the screen*/
int     MaxX, MaxY;          /* The maximum resolution of the screen */
int     MaxColors;           /* The maximum # of colors available    */
int     ErrorCode;           /* Reports any graphics errors      */
struct  palettetype palette; /* Used to read palette info    */
 
int     lor_x;
int     lor_y;
int     lor_z;

int     d_x;
int     d_y;
int     d_z;

/*===========================================================================
*
* Function: main
*
* Desc:     
*
* Parms:    none.
* Returns:  Termination code.
*
---------------------------------------------------------------------------*/
void        main(void)
{
    Initialize();
    lor_x = lor_y = lor_z = 1;

    while (bioskey(1) == 0) {
        calc_lorenz();
        plot_lorenz();
    }
    bioskey(0);
    closegraph();                   /* Return the system to text mode   */
    textattr(0x07);
    clrscr();
    _setcursortype(_NORMALCURSOR);
}


/*===========================================================================
*
* Function: calc_lorenz
*
* Desc:     dx/dt = 10(x-y)
*           dy/dt = -xz+28x-y
*           dz/dt = xy-(8/3)z
*
* Parms:    none.
* Returns:  none.
*
---------------------------------------------------------------------------*/
void        calc_lorenz(void)
{
    d_x = (lor_x - lor_y) / 10;
    d_y = (28 * lor_x) - (lor_x * lor_z) - lor_y;
    d_z = (lor_x * lor_y) - ((8 * lor_z) / 3);

    lor_x += d_x;
    lor_y += d_y;
    lor_z += d_z;
}

/*===========================================================================
*
* Function: plot_lorenz
*
* Desc:     
*
* Parms:    none.
* Returns:  none.
*
---------------------------------------------------------------------------*/
void        plot_lorenz(void)
{
    int     x, y, z;
    double  dx, dy, dz;

    dx = lor_x;
    dy = lor_y;
    dz = lor_z;

    dx /= 32786.0;
    x = (dx * MaxX);

    dy /= 32786.0;
    y = (dy * MaxY);
    
    dz /= 32786.0;
    z = (dz * MaxColors);
    
    putpixel(x, y, z);
}


/****************************************************************************
*****************************************************************************
*********************  Low Level Plotting Control  **************************
*****************************************************************************
****************************************************************************/

/*===========================================================================
*
* Function: Initialize
*
* Desc:     Initializes the graphics system and aborts on error.
*
* Parms:    none.
* Returns:  none.
*
---------------------------------------------------------------------------*/
void        Initialize(void)
{
    int xasp, yasp;           /* Used to read the aspect ratio*/

    GraphDriver = DETECT;         /* Request auto-detection   */
    initgraph( &GraphDriver, &GraphMode, "" );
    ErrorCode = graphresult();        /* Read result of initialization*/
    if( ErrorCode != grOk ) {      /* Error occured during init    */
        printf(" Graphics System Error: %s\n", grapherrormsg( ErrorCode ) );
        exit( 1 );
    }

    getpalette( &palette );       /* Read the palette from board  */
    MaxColors = getmaxcolor() + 1;    /* Read maximum number of colors*/

    MaxX = getmaxx();
    MaxY = getmaxy();         /* Read size of screen      */

    getaspectratio( &xasp, &yasp );   /* read the hardware aspect */
    AspectRatio = (double)xasp / (double)yasp; /* Get correction factor   */
}



/*------------------------------ End ---------------------------------------*/

