/*
    DEFKERN.CPP - (C) 1990 by Joachim Kainz 'On a mission from Bhudda'
*/
    #include <windows.hpp>

    METHOD WINDOW::WndKernelProc (WORD wMsg, WORD wParam, long lParam)
    {
        switch(wMsg) {

          case WM_NULL:
            return WMNull ();

          case WM_CREATE:
            return WMCreate ((LPCREATESTRUCT) lParam);

          case WM_DESTROY:
             return WMDestroy ();

          case WM_MOVE:
            return WMMove (MAKEPOINT (lParam));

          case WM_SIZE:
			return WMSize (wParam, LOWORD (lParam), HIWORD (lParam));

		  case WM_ACTIVATE:
			return WMActivate (
						wParam,
						HIWORD (lParam),
						LOWORD (lParam)
				   );

		  case WM_SETFOCUS:
			return WMSetFocus (wParam);

		  case WM_KILLFOCUS:
			return WMKillFocus (wParam);

		  case WM_ENABLE:
			return WMEnable (wParam);

		  case WM_SETREDRAW:
			return WMSetRedraw (wParam);

		  case WM_SETTEXT:
			return WMSetText ((LPSTR) lParam);

		  case WM_GETTEXT:
			return WMGetText ((LPSTR) lParam, wParam);

		  case WM_GETTEXTLENGTH:
			return WMGetTextLength ();

		  case WM_PAINT:
			return WMPaint ();

		  case WM_CLOSE:
			return WMClose ();

		  case WM_QUERYENDSESSION:
			return WMQueryEndSession ();

		  case WM_QUERYOPEN:
			return WMQueryOpen ();

		  case WM_ERASEBKGND:
			return WMEraseBkgnd (wParam);

		  case WM_SYSCOLORCHANGE:
			return WMSysColorChange ();

		  case WM_ENDSESSION:
			return WMEndSession (wParam);

		  case WM_SHOWWINDOW:
			return WMShowWindow (wParam, lParam);

		  case WM_CTLCOLOR:
			return WMCtlColor (
						wParam,
						HIWORD (lParam),
						LOWORD (lParam)
				   );

		  case WM_WININICHANGE:
			return WMWinIniChange ((LPSTR) lParam);

		  case WM_DEVMODECHANGE:
			return WMDevModeChange ((LPSTR) lParam);

		  case WM_ACTIVATEAPP:
			return WMActivateApp	(wParam, LOWORD (wParam));

		  case WM_FONTCHANGE:
			return WMFontChange ();

		  case WM_TIMECHANGE:
			return WMTimeChange ();

		  case WM_CANCELMODE:
			return WMCancelMode ();

		  case WM_SETCURSOR:
			return WMSetCursor (
						wParam,
						LOWORD (lParam),
						HIWORD (lParam)
				   );

		  case WM_MOUSEACTIVATE:
			return WMMouseActivate (
						wParam,
						LOWORD (lParam),
						HIWORD (lParam)
				   );

		  case WM_CHILDACTIVATE:
			return WMChildActivate ();

		  case WM_QUEUESYNC:
			return WMQueueSync ();

		  case WM_GETMINMAXINFO:
			return WMGetMinMaxInfo ((LPRECT) lParam);

		  case WM_PAINTICON:
			return WMPaintIcon (wParam);

		  case WM_ICONERASEBKGND:
			return WMIconEraseBkgnd (wParam);

		  case WM_NEXTDLGCTL:
			return WMNextDlgCtl     (wParam, lParam != 0l);

		  case WM_SPOOLERSTATUS:
			return WMSpoolerStatus  (LOWORD (lParam));

		  case WM_DRAWITEM:
			return WMDrawItem ((LPDRAWITEMSTRUCT) lParam);

		  case WM_MEASUREITEM:
			return WMMeasureItem ((LPMEASUREITEMSTRUCT) lParam);

		  case WM_DELETEITEM:
			return WMDeleteItem ((LPDELETEITEMSTRUCT) lParam);

		  case WM_VKEYTOITEM:
			return WMVKeyToItem (
						wParam,
						HIWORD (lParam),
						LOWORD (lParam)
				   );

		  case WM_CHARTOITEM:
			return WMCharToItem (
						wParam,
						HIWORD (lParam),
						LOWORD (lParam)
				   );

		  case WM_SETFONT:
			return WMSetFont (wParam, (BOOL) lParam);

		  case WM_GETFONT:
			return WMGetFont ();

		}

		return DefWindowProc (GetWindowHandle (), wMsg, wParam, lParam);
	}

	METHOD WINDOW::WMCreate(LPCREATESTRUCT lpCreate)
	{
		wCount ++;

		return 0l;
	}

	METHOD WINDOW::WMDestroy()
	{
		if(!(--wCount))
			PostQuitMessage(0);

		SetWindowLong (
			GetWindowHandle (),
			GWL_WNDPROC,
			(long) lpDefWndProc
		);

		hWnd = 0;

		return 0l;
	}

	METHOD WINDOW::WMActivate(
						WORD wActivate,
						BOOL bMin,
						HWND hLast
					 )
	{
		if(wActivate)
			SetFocus (GetWindowHandle ());

		return 0l;
	}

	METHOD WINDOW::WMSetRedraw(BOOL bRedrawFlag)
	{
		return DefWindowProc (GetWindowHandle (), WM_SETREDRAW, bRedrawFlag, NULL);
	}

	METHOD WINDOW::WMSetText(LPSTR lpText)
	{
		return DefWindowProc(GetWindowHandle (), WM_SETTEXT, NULL, (long) lpText);
	}

	METHOD WINDOW::WMGetText(LPSTR lpText, WORD wMax)
	{
		return DefWindowProc(GetWindowHandle (), WM_GETTEXT, wMax, (long) lpText);
	}

	METHOD WINDOW::WMGetTextLength()
	{
		return DefWindowProc(GetWindowHandle (), WM_GETTEXTLENGTH, NULL, NULL);
	}

	METHOD WINDOW::WMPaint()
	{
		PAINTSTRUCT ps;

		BeginPaint(GetWindowHandle (), &ps);
		EndPaint  (GetWindowHandle (), &ps);

		return 0l;
	}

	METHOD WINDOW::WMClose()
	{
		DestroyWindow (GetWindowHandle ());

		return 0l;
	}

	METHOD WINDOW::WMEraseBkgnd(HANDLE hDC)
	{
		return DefWindowProc(GetWindowHandle (), WM_ERASEBKGND, hDC, NULL);
	}

	METHOD WINDOW::WMShowWindow(BOOL bShow, long lShow)
	{
		return DefWindowProc(
					GetWindowHandle (),
					WM_SHOWWINDOW,
					bShow,
					lShow
			   );
	}

	METHOD WINDOW::WMCtlColor(
						HDC  hCtlDC,
						WORD wCtlStyle,
						HWND hCtl
					 )
	{
		return DefWindowProc(
					GetWindowHandle (),
					WM_CTLCOLOR,
					hCtlDC,
					MAKELONG(hCtl, wCtlStyle)
			   );
	}

	METHOD WINDOW::WMCancelMode()
	{
		return DefWindowProc(GetWindowHandle (), WM_CANCELMODE, NULL, NULL);
	}

	METHOD WINDOW::WMSetCursor(
						HCURSOR hCursorOwner,
						WORD	wNCHitTest,
						WORD	wMouseMsg
					 )
	{
		return DefWindowProc(
					GetWindowHandle (),
					WM_SETCURSOR,
					hCursorOwner,
					MAKELONG(wNCHitTest, wMouseMsg)
			   );
	}

	METHOD WINDOW::WMMouseActivate(
						HWND hTopWnd,
						WORD NCHitTest,
						WORD wMouseMsg
					 )
	{
		return DefWindowProc(
					GetWindowHandle (),
					WM_MOUSEACTIVATE,
					hTopWnd,
					wMouseMsg
			   );
	}

	METHOD WINDOW::WMPaintIcon(BOOL bDraw)
	{
		return DefWindowProc(GetWindowHandle (), WM_PAINTICON, bDraw, NULL);
	}

	METHOD WINDOW::WMIconEraseBkgnd(HDC hDC)
	{
		return DefWindowProc(
					GetWindowHandle (),
					WM_ICONERASEBKGND,
					hDC,
					NULL
			   );
	}

	METHOD WINDOW::WMDrawItem(LPDRAWITEMSTRUCT lpDrawItem)
	{
		return DefWindowProc(
					GetWindowHandle (),
                    WM_DRAWITEM,
                    NULL,
                    (long) lpDrawItem
               );
    }
