/*
	DLGMETH.CPP - Generic DialogBox-Class
	(C) 1991 by Joachim Kainz 'On a mission from Bhudda'
*/
	#include "dialog.hpp"

	METHOD DIALOG::WMShowWindow (BOOL bShow, long lShow)
	{
		return DefDlgProc(
					GetWindowHandle (),
					WM_SHOWWINDOW,
					bShow,
					lShow
			   );
	}

	METHOD DIALOG::WMEraseBkgnd (HANDLE hDC)
	{
		return DefDlgProc(GetWindowHandle (), WM_ERASEBKGND, hDC, NULL);
	}

	METHOD DIALOG::WMActivate(
						WORD wActivate,
						BOOL bMin,
						HWND hLast
					 )
	{
		return DefDlgProc(
					GetWindowHandle (), 
					WM_ACTIVATE,
					wActivate,
					MAKELONG (bMin, hLast)
			   );
	}

	METHOD DIALOG::WMSetFocus(HWND hLast)
	{
		return DefDlgProc (GetWindowHandle (), WM_SETFOCUS, hLast, NULL);
	}

	METHOD DIALOG::WMClose()
	{
		return DefDlgProc(
					GetWindowHandle (), 
					WM_CLOSE,
					NULL,
					NULL
			   );
	}

	METHOD DIALOG::WMNCDestroy()
	{
		return DefDlgProc (GetWindowHandle (), WM_NCDESTROY, NULL, NULL);
	}

	METHOD DIALOG::WMLButtonDown (WORD wOtherKeys, POINT pt)
	{
		return DefDlgProc (
					GetWindowHandle (),
					WM_LBUTTONDOWN,
					wOtherKeys,
					*(long *) &pt
			   );
	}

	METHOD DIALOG::WMNCLButtonDown (WORD wNCHitTest, POINT pt)
	{
		return DefDlgProc (
					GetWindowHandle (),
					WM_NCLBUTTONDOWN,
					wNCHitTest,
					*  (long*) &pt
			   );
	}

	METHOD DIALOG::WMGetFont()
	{
		return DefDlgProc (GetWindowHandle (), WM_GETFONT, NULL, NULL);
	}

	METHOD DIALOG::WMInitDialog (DWORD dwParam)
	{
		WINDOW::WMCreate (NULL);

		msg.AddDlg (GetWindowHandle ());

		return TRUE;
	}

	void EXPORT DIALOG::EndDialog (WORD wRes)
	{
		wResult = wRes;

		DestroyWindow (GetWindowHandle ());
	}

	WORD EXPORT DIALOG::modal ()
	{
		HWND hParent = GetParent ();

		if (!IsWindowVisible (GetWindowHandle ())) {

			ShowWindow  (GetWindowHandle (), SW_SHOW);
			UpdateWindow(GetWindowHandle ()			);

		}

		if (hParent)
			EnableWindow (hParent, FALSE);

		while (GetWindowHandle ())
			msg.Peek ();

		if (hParent)  {

			EnableWindow (hParent, TRUE);
			SetFocus	 (hParent	   );

		}

		return GetResult ();
	}

	void EXPORT DIALOG::SetItemText (WORD wItem, LPSTR lpText)
	{
		HWND hCtl = GetDlgItem (GetWindowHandle (), wItem);

		if (HIWORD (lpText)) {

			SetWindowText (hCtl, lpText);

			return;

		}

		WORD wMaxLen = 64;

		while (TRUE) {

			PSTR pText = new char [wMaxLen];

			if (!pText)
				return;

			WORD wLen = LoadString (
							GetInstance (),
							LOWORD (lpText),
							pText,
							wMaxLen
						);

			if (wLen+1 >= wMaxLen) {

				wMaxLen *= 2;
				continue;

			}

			SetWindowText (hCtl, pText);

			return;
		}

	}

	METHOD DIALOG::WMDestroy ()
	{
		msg.RemoveDlg (GetWindowHandle ());

		return WINDOW::WMDestroy ();
	}

	void EXPORT DIALOG::LimitText (WORD wItem, WORD  wChars)
	{
		SendDlgItemMessage (
			GetWindowHandle (),
			wItem,
			EM_LIMITTEXT,
			wChars,
			0l
		);
	}

	void EXPORT DIALOG::GetItemText (WORD wItem, LPSTR lpText, WORD wText)
	{
		HWND hCtl = GetDlgItem (GetWindowHandle (), wItem);

		if (!hCtl) {

			*lpText = '\0';
			return;

		}

		GetWindowText (hCtl, lpText, wText);
	}

	void EXPORT DIALOG::EnableItem (WORD wItem, BOOL bEnable)
	{
		HWND hCtl = GetDlgItem (GetWindowHandle (), wItem);

		EnableWindow (hCtl, bEnable);
	}

	METHOD DIALOG::WndDlgProc (WORD wMsg, WORD wParam, long lParam)
	{
		switch (wMsg) {

		  case WM_COMMAND:
			return WMCommand (
						wParam,
						HIWORD (lParam),
						LOWORD (lParam)
				   );

		  case WM_SYSCOMMAND:
			return WMSysCommand (wParam, MAKEPOINT (lParam));

		  case WM_TIMER:
			return WMTimer (wParam, (FARPROC) lParam);

		  case WM_HSCROLL:
			return WMHScroll (wParam, HIWORD (lParam));

		  case WM_VSCROLL:
			return WMVScroll (wParam, HIWORD (lParam));

		  case WM_INITMENU:
			return WMInitMenu (wParam);

		  case WM_INITDIALOG:
			return WMInitDialog (lParam);

		  case WM_INITMENUPOPUP:
			return WMInitMenuPopUp	(
						wParam,
						LOWORD (lParam),
						HIWORD (lParam)
					 );

		  case WM_MENUSELECT:
			return WMMenuSelect (wParam, LOWORD (lParam));

		  case WM_MENUCHAR:
			return WMMenuChar (
						wParam,
						HIWORD (lParam),
						LOWORD (lParam)
				   );

		  case WM_ENTERIDLE:
			return WMEnterIdle (wParam, LOWORD (lParam));

		}

		return DefWindowProc (GetWindowHandle (), wMsg, wParam, lParam);
	}

	METHOD DIALOG::WMSysCommand (WORD wID, POINT pt)
	{
		return DefWindowProc (
				GetWindowHandle (),
				WM_SYSCOMMAND,
				wID,
				*(long*)&pt
			   );
	}

