/*
	MDI.HPP - (C) 1990 by Joachim Kainz 'On a mission from Bhudda'
*/
	#if !defined (__MDI_HPP)
	#define __MDI_HPP 1

	#include "toplevel.hpp"

	#define JFK_MDI			(JFK_WINDOW+1 )
	#define JFK_MDICHILD	(JFK_WINDOW+2 )

	// The following ID of the first child-window created.
	// To avoid contacts all menu-IDs must be less than this value.

	#define ID_MDICHILD     ((WORD) 0xff00)

	#define WS_MDICLIENT (WS_CHILD | WS_CLIPCHILDREN | WS_VSCROLL | WS_HSCROLL)

	class MDICHILD : public WINDOW {

	  protected:
		virtual METHOD WMMove	       (POINT pt   );
		virtual METHOD WMClose         (           );
		virtual METHOD WMGetMinMaxInfo (LPRECT lprt);

		virtual METHOD WMSetText (LPSTR lpText);

		virtual METHOD WMInitDialog	(DWORD dwParam				   ) DEFMETH
		virtual	METHOD WMCommand	(WORD wID, WORD wMsg, HWND hCtl) DEFMETH
		virtual METHOD WMSysCommand	(WORD wID, POINT pt			   );
		virtual METHOD WMTimer		(WORD wID, FARPROC			   ) DEFMETH
		virtual METHOD WMHScroll	(WORD wScrollCode, HWND hCtl   ) DEFMETH
		virtual METHOD WMVScroll	(WORD wScrollCode, HWND hCtl   ) DEFMETH
		virtual METHOD WMInitMenu	(HMENU hMenu				   ) DEFMETH

		virtual METHOD WMInitMenuPopUp (
						HMENU hPopUp,
						WORD  wIndex,
						BOOL
						bSystem
					   ) DEFMETH

		virtual METHOD WMMenuSelect	(WORD wMenu, WORD wFlag			   );
		virtual METHOD WMMenuChar	(WORD wKey, HMENU hMenu, WORD wMenu);
		virtual METHOD WMEnterIdle	(WORD wPrevious, HANDLE hPrevious  ) DEFMETH

		virtual METHOD WMParentNotify  (
						WORD wID,
						WORD wMsg,
						WORD wCtl
					   ) DEFMETH

		virtual METHOD WMChildActivate (								   );
		virtual METHOD WMMDIActivate   (WORD wActive, HWND hOld, HWND hNew ) DEFMETH
		virtual METHOD WMSetFocus	   (HWND hLast						   );
		virtual METHOD WMSize		   (
						WORD wSizing,
						int  nWidth,
						int  nHeigth
					   );

		virtual METHOD WndMdiProc (WORD wMsg, WORD wParam, long lParam);
		virtual METHOD WndDlgProc (WORD wMsg, WORD wParam, long lParam);

	  public:
		EXPORT MDICHILD (
				LPSTR lpName,
				HICON hIcon		= LoadIcon (NULL, IDI_QUESTION),
				int	  x			= 100,
				int	  y			= 100,
				int	  cx		= 250,
				int	  cy		= 100,
				long  lStyle	= NULL,
				long  lParam	= NULL,
				LPSTR lpClass	= MAKEINTRESOURCE (JFK_MDICHILD)
			   );
	};

	class MDI : public TOPLEVEL {

	  protected:
		static HWND hMDIClient;

		virtual METHOD WMQueryEndSession ();
		virtual METHOD WMClose			 ();
		virtual METHOD WMDestroy         ();

		virtual METHOD WMCommand	(WORD wID,   WORD wMsg,   HWND hCtl	);
		virtual METHOD WMSysCommand (WORD wID, 	 POINT pt				);
		virtual METHOD WMMenuChar	(WORD wKey,  HMENU hMenu, WORD wMenu);
		virtual METHOD WMMenuSelect (WORD wMenu, WORD  wFlag            );
		virtual METHOD WMSetFocus	(HWND hLast							);
		virtual METHOD WMSize		(
						WORD wSizing,
						int  nWidth,
						int  nHeigth
					   );

		static HWND EXPORT GetMDIClient () { return hMDIClient; }

		friend class MIDCHILD;

		HMENU EXPORT MDISetMenu (
						HMENU hNewAppMenu = NULL,
						HMENU hNewPopUp	  = NULL
					 );
		HWND EXPORT GetNextChild   (HWND hChild = NULL);
		long EXPORT SendAllChildren(
						WORD wMsg,
						WORD wParam		   = NULL,
						long lParam		   = NULL,
						BOOL bBreakOnFalse = FALSE
					);

	  public:
		EXPORT MDI (
				int		 nCmdShow  = SW_NORMAL,
				int		 x		   = CW_USEDEFAULT,
				int		 y		   = CW_USEDEFAULT,
				int		 cx		   = CW_USEDEFAULT,
				int		 cy		   = CW_USEDEFAULT,
				long	 lStyle	   = WS_OVERLAPPEDWINDOW | WS_CLIPCHILDREN,
				LPSTR    lpName	   = MAKEINTRESOURCE (ID_APPNAME),
				LPSTR	 lpMenu	   = MAKEINTRESOURCE (ID_APPNAME),
				long	 lExStyle  = NULL,
				WORD	 wStyle	   = CS_VREDRAW | CS_HREDRAW,
				HCURSOR	 hCursor   = LoadCursor (NULL, IDC_ARROW),
				HICON	 hIcon	   = LoadIcon (
										GetInstance (),
										MAKEINTRESOURCE (ID_APPNAME)
									 ),
				HBRUSH	 hBackGrnd = COLOR_APPWORKSPACE+1,
				WORD	 wClsExtra = 0,
				WORD	 wWndExtra = 0,
				LPSTR	 lpParam   = NULL,
				LPSTR	 lpClass   = MAKEINTRESOURCE (JFK_MDI),
				FARPROC2 lpFnProc  = DefWindowProc
			   );

	};

	#endif
