/*
	TOPLEVEL.HPP - Generic Handling of TopLevel-Windows
	(C) 1990 by Joachim Kainz 'On a mission from Bhudda'
*/
	#if !defined (__TOPLEVEL_HPP)
	#define __TOPLEVEL_HPP

	#include "jfklib.h"

	#if !defined (__WINDOWS_HPP)
	#include "windows.hpp"
	#endif

	class TOPLEVEL : public WINDOW
	{
	  protected:
		BOOL bHelpActive;

		virtual METHOD WMInitDialog	(DWORD dwParam				   ) DEFMETH
		virtual METHOD WMCommand	(WORD wID, WORD wMsg, HWND hCtl);
		virtual METHOD WMSysCommand	(WORD wID, POINT pt			   );
		virtual METHOD WMTimer		(WORD wID, FARPROC			   ) DEFMETH
		virtual METHOD WMHScroll	(WORD wScrollCode, HWND hCtl   ) DEFMETH
		virtual METHOD WMVScroll	(WORD wScrollCode, HWND hCtl   ) DEFMETH
		virtual METHOD WMInitMenu	(HMENU hMenu				   ) DEFMETH

		virtual METHOD WMInitMenuPopUp (
				HMENU hPopUp,
				WORD  wIndex,
				BOOL
				bSystem
			   ) DEFMETH

		virtual METHOD WMMenuSelect	(WORD wMenu, WORD wFlag			   ) DEFMETH
		virtual METHOD WMMenuChar	(WORD wKey, HMENU hMenu, WORD wMenu) DEFMETH
		virtual METHOD WMEnterIdle	(WORD wPrevious, HANDLE hPrevious  ) DEFMETH

		virtual METHOD WndDlgProc (WORD wMsg, WORD wParam, long lParam);

		virtual METHOD WMClose   ();
		virtual METHOD WMDestroy ();

	  public:
		EXPORT TOPLEVEL (
				int		 nCmdShow  = SW_NORMAL,
				int		 x		   = CW_USEDEFAULT,
				int		 y		   = CW_USEDEFAULT,
				int		 cx		   = CW_USEDEFAULT,
				int		 cy		   = CW_USEDEFAULT,
				long	 lStyle	   = WS_OVERLAPPEDWINDOW,
				LPSTR    lpName	   = MAKEINTRESOURCE (ID_APPNAME),
				LPSTR	 lpMenu	   = MAKEINTRESOURCE (ID_APPNAME),
				long	 lExStyle  = NULL,
				WORD	 wStyle	   = CS_VREDRAW | CS_HREDRAW,
				HCURSOR	 hCursor   = LoadCursor (NULL, IDC_ARROW),
				HICON	 hIcon	   = LoadIcon (
										GetInstance (),
										MAKEINTRESOURCE (ID_APPNAME)
									 ),
				HBRUSH	 hBackGrnd = COLOR_WINDOW+1,
				WORD	 wClsExtra = 0,
				WORD	 wWndExtra = 0,
				LPSTR	 lpParam   = NULL,
				LPSTR	 lpClass   = MAKEINTRESOURCE (JFK_WINDOW),
				FARPROC2 lpFnProc  = DefWindowProc
			   );
	};

	#endif
