/******************************************************
*                  ** COPYRIGHT **                    *
*   to this program's source code                     *
*   belongs to Dudley Farthing Jr.                    *
*   CIS UID   : [71240,2557]                          *
*                                                     *
*            -  YOU MAY COPY FREELY,  -               *
*      -  Please Note Any Changes You Make  -         *
*          -  In Coppies You Give Away  -             *
*   - AND NEVER CHARGE FOR THE PROGRAM ITSELF -       *
*          -  (unless i get some too)  -              *
*         @-,'---       >;->       ---,'-@            *
*                                                     *
*   Creation Date : 19910512213453 LCT                *
*   Last Revision : 19910516160316 LCT                *
*   Purpose : Printer Code transmission from an Ascii *
*             file that is edited/maintained by the   *
*             user.                                   *
******************************************************/

#include<bios.h>
#include<stdio.h>
#include<stdlib.h>
#include<string.h>

const unsigned short DEF_PRT = 1,     // Default Printer
                   MAX_FLAGS = 100,   // Max Flags passed from Com. line.
                MAX_FLAG_LEN = 30,    // Max Flag length in Char's
           MAX_FLAG_DESC_LEN = 50,    // Max Flag Description len. (char's)
             MAX_CODESTR_LEN = 160,   // Max Text Printer Code len. (char's)
                MAX_CODE_LEN = 80,    // Max Printer Code len. (codes)
                   MAX_CODES = 200;   // Max Codes read in from file

const char *DEF_FILENAME="lp_codes.out\x0                              "\
                        "                                           \x0",
               *P_ERROR="The selected printer is not ready...\x0       ",
                 *USAGE="Usage lp [-fUFN] [-pn] [-l] [-?] [-d] flag [fl"\
                        "ag] [flag] ..\n\x0                            ",
                *UN_REC="Unrecognized Flag Error, -l to view the file. "\
                        "\n\n\x0                                       ",
           *P_SELECTION="Printer error : Selection\n\x0                ",
           *F_SELECTION="File error : Selection\n\x0                   ",
           *H_SELECTION="Usage lp [-fUFN] [-pn] [-d] [-l] [-?] flag [fl"\
                        "ag] [flag] ..\nthe directives may be in any or"\
                        "der.\nthe -d directive will cause no ouput to "\
                        "the screen to occure\nexcept the codes themsel"\
                        "ves.\nthe -f directive preceeds an un-ambiguis"\
                        "\nfile name. If the file isn't in the current "\
                        "directory, the PATH is searched.\nthe -l direc"\
                        "tive causes the file contents to be listed.\nt"\
                        "he -p option followed by an integer that corre"\
                        "lates to LPT_:\nflags are text strings. they m"\
                        "ay not contain space characters,\nand are case"\
                        " sensative.\n\x0                              ",
              *MF_ERROR="Too many Flags Passed\n\x0                    ",
               *M_ERROR="Memory Allocation Error\x7\n\x0               ",
            *UNREC_FLAG="Unrecognized directive...\n\x0                ",
                  *PATH="PATH\x0                                       ",
                  *MODE="r\x0                                          ",
               FLAG_CHR='-',
            DIRECT_FLAG='d',
               PRT_FLAG='p',
              FILE_FLAG='f',
              LIST_FLAG='l',
              HELP_FLAG='?';

typedef class _p {
         private:
             char *desc,
                  *code;
          public:
             char *flag;
             void code_convert();
            _p();
           ~_p();
             void printf(short,short);
              int fread(FILE*fp);
                 } pr_code;

                   void die(int,
                            const char*);

                  int fread(pr_code*,
                            FILE*);

    unsigned int parse_args(char**,
                            FILE**,
                            short*,
                            char**,
                            short*,
                            char**,
                            short*);

unsigned int scrounge_codes(pr_code*,
                            FILE*);

            void dump_codes(char**,
                            pr_code*,
                            short,
                            unsigned int,
                            unsigned int,
                            short);

             FILE *file_fnd(char**,
                            char*,
                            const char *);

                   int comp(const void*,
                            const void*);

                  int _comp(const void*,
                            const void*);

void main(int argc,char **argv,char **env)
{
  short printer=DEF_PRT,
        lst=0,
        te,
        direct=0;
  unsigned int n_flags,
               n_codes;
  char *f_name=(char*)malloc(strlen(DEF_FILENAME)+1),
       **flags=(char**)malloc(MAX_FLAGS*sizeof(char*));
  FILE *infile=NULL;
  for (unsigned int q=0;q<MAX_FLAGS;q++)
    if (!(*(flags+q)=(char*)malloc(MAX_FLAG_LEN))) die(1,M_ERROR);
  pr_code codes[MAX_CODES];
  if (!codes) die(1,M_ERROR);
  if (!--argc)
    die(-1,USAGE);
  n_flags=parse_args(++argv,&infile,&printer,flags,&lst,env,&direct);
  if (!infile)
  {
    strcpy(f_name,DEF_FILENAME);
    infile=file_fnd(env,f_name,MODE);
  }
  if (!infile)
    die(1,F_SELECTION);
  n_codes=scrounge_codes(codes,infile);
  fclose(infile);
  if (lst)
    for (unsigned int s=0;s<n_codes;s++) codes[s].printf(0,0);
  qsort(codes,n_codes,sizeof(pr_code),comp);
  if (n_flags)
  {
    if (!direct) fprintf(stderr,"Codes Passed : \n");
    dump_codes(flags,codes,printer,n_flags,n_codes,direct);
  }
  die(0,"");
}

void dump_codes(char **flags,pr_code *codes,short printer,
                unsigned int t_flags,unsigned int t_codes,short df)
{
  pr_code *tmp;
  unsigned int q=0u;
  do
  {
    tmp=(pr_code*)bsearch(flags[q],codes,t_codes,sizeof(pr_code),_comp);
    if (!tmp)
      die (-1,UN_REC);
    else
      tmp->printf(printer,df);
    q++;
  }
  while (flags[q][0] && q<t_flags);
}

void pr_code::printf(short l,short df)
{
  int stat_result=0;
  unsigned short q=0u;
  if (l)
    while(*(code+q))
      if (df)
        fwrite(code+q++,1,1,stdout);
      else
      {
        stat_result=biosprint(2,stat_result,(int)l-1);
        if (!((stat_result & 0x40) || (stat_result & 0x80)))
          die (-1,P_ERROR);
        biosprint(0,*(code+q++),(int)l-1);
      }
  if (!df)
    fprintf(stderr,"%s -> %s\n",flag,desc);
}

int pr_code::fread(FILE *fp)
{
  int ret=1;
  ret&=(fgets(flag,MAX_FLAG_LEN,fp)!=NULL);
  *(flag+strlen(flag)-1)=0;   //  stop on \n at end of string
  ret&=(fgets(desc,MAX_FLAG_DESC_LEN,fp)!=NULL);
  *(desc+strlen(desc)-1)=0;   //  stop on \n at end of string
  ret&=(fgets(code,MAX_CODESTR_LEN,fp)!=NULL);
  *(code+strlen(code)-1)=0;   //  stop on \n at end of string
  code_convert();             //  convert text num's Char's
  return(ret);
}

void pr_code::code_convert()
{
  unsigned short i=0u;
  char *q=(char*)malloc(strlen(this->code)+1);
  strcpy(q,this->code);
  while (*q && *q==' ') q++;
  while (*q)
  {
    *((this->code)+i++)=(char)atol(q);
    while(*q && *q!=' ') q++;
    while(*q && *q==' ') q++;
  }
  free(q);
  *((this->code)+i)=0;
}

unsigned int scrounge_codes(pr_code *p,FILE *fp)
{
  unsigned int recs=0u;
  while ((recs < MAX_CODES) && (p+recs)->fread(fp))
    recs++;
  return(recs);
}

int comp(const void*x,const void*y)
{
  pr_code *a=(pr_code*)x,
          *b=(pr_code*)y;
  return(strcmp(a->flag,b->flag));
}

int _comp(const void*x,const void*y)
{
  pr_code *a;
  char    *b;
  a=(pr_code*)y;
  b=(char*)x;
  return(strcmp(b,a->flag));
}

_p::_p()
{
  flag=(char*)malloc(MAX_FLAG_LEN);
  desc=(char*)malloc(MAX_FLAG_DESC_LEN);
  code=(char*)malloc(MAX_CODE_LEN);
}

_p::~_p()
{
  free(flag);
  free(desc);
  free(code);
}

void die(int y,const char *q)
{
  fcloseall();
  if (*q)
    fprintf(stderr,"%s",q);
  exit(y);
}

FILE *file_fnd(char **env,char *fname,const char *mode)
{
  FILE *infile=fopen(fname,mode);
  unsigned short y=0u;
  char **paths=(char**)malloc(80*sizeof(char*)),*w_file=fname,*tmp;
  if (!paths) die(1,M_ERROR);
  *paths=(char*)malloc(80*sizeof(char*));
  if (infile) return(infile);
  tmp=strchr(w_file,':');
  if (tmp)
    w_file=tmp+1;
  while(tmp=strchr(w_file,'\\'))
    w_file=tmp+1;
  while(*(env) && strncmp(*(env),PATH,strlen(PATH)))
    env++;
  infile=fopen(w_file,mode);
  if (*(env) && !infile)
  {
    char *q=*(env),*i;
    q+=strlen(PATH);
    while (*q==' ')
      q++;
    q++;
    while (*q==' ')
      q++;
    while (*q)
    {
      i=strchr(q,';');
      paths[y+1]=(char*)malloc(80*sizeof(char));
      *paths[y+1]='\x0';
      if (!paths[y]) die(1,M_ERROR);
      strncpy(paths[y],q,i-q);
      paths[y][(i-q)]=0;
      strcat(paths[y],"\\");
      strcat(paths[y],w_file);
      q=i+1;
      y++;
    }
    y=0;
    while (*paths[y] && !infile)
      infile=fopen(paths[y++],mode);
   }
   while (y+1)
     free(paths[y--]);
   free(paths);
   return(infile);
}

unsigned int parse_args(char **argv,FILE **fp,short *prt,char **flags,
                        short *lst,char **env,short *dire)
{
  char *q;
  unsigned int f_count=0u;
  while (*(argv))
  {
    q=(*argv);
    if (*q==FLAG_CHR)
    {
      q++;
      if (*q==DIRECT_FLAG)
        *dire=1;
      else
      if (*q==PRT_FLAG)
      {
        if(!(*prt=(short)atoi(q+1)))
          die(-1,P_SELECTION);
      }
      else
      if (*q==FILE_FLAG && *(q+1))
      {
        if(!(*fp=file_fnd(env,(q+1),MODE)))
          die(1,F_SELECTION);
      }
      else
      if (*q==LIST_FLAG)
        *lst=1;
      else
      if (*q==HELP_FLAG)
        die(0,H_SELECTION);
      else
        die(-1,UNREC_FLAG);
    }
    else
    {
      if (f_count>MAX_FLAGS) die(-1,MF_ERROR);
      strcpy(flags[f_count],q);
      f_count++;
      flags[f_count][0]='\x0';
    }
    argv++;
  }
  return(f_count);
}
