#include "lvsmenu.hpp"


WinMenu main_menu;

void Open_Menus ()
{
    static WinMenu sub[5];
    
    /*
     * Hide all the sub menus before opening them.
     * Also prevent the user from moving/resizing the submenus
     * Not required, but looks better.
     */

    for (int i = 0; i < 5; i++)
        {
        sub[i].hide ();
        sub[i].set_type (MENU_SUB);
        sub[i].allow_user_moves (FALSE);
        }

    sub[0].open (1, 0, 6, 13, W_SINGLE, _LGREY|BLUE, _LGREY|BLUE);
    sub[0].set_keyattr (_LGREY|RED);
    sub[0].set_barattr (_BLUE|WHITE);
    sub[0].prompt (0, 0, 11, " Sub item 1 ", '1');
    sub[0].prompt (1, 0, 12, " Sub item 2 ", '2');
    sub[0].prompt (2, 0, 13, " Sub item 3 ", '3');
    sub[0].prompt (3, 0, 14, " Sub item 4 ", '4');

    sub[1].open (1, 15, 6, 28, W_SINGLE, _LGREY|BLUE, _LGREY|BLUE);
    sub[1].set_keyattr (_LGREY|RED);
    sub[1].set_barattr (_BLUE|WHITE);
    sub[1].prompt (0, 0, 21, " Sub item 1 ", '1');
    sub[1].prompt (1, 0, 22, " Sub item 2 ", '2');
    sub[1].prompt (2, 0, 23, " Sub item 3 ", '3');
    sub[1].prompt (3, 0, 24, " Sub item 4 ", '4');

    sub[2].open (1, 30, 6, 43, W_SINGLE, _LGREY|BLUE, _LGREY|BLUE);
    sub[2].set_keyattr (_LGREY|RED);
    sub[2].set_barattr (_BLUE|WHITE);
    sub[2].prompt (0, 0, 31, " Sub item 1 ", '1');
    sub[2].prompt (1, 0, 32, " Sub item 2 ", '2');
    sub[2].prompt (2, 0, 33, " Sub item 3 ", '3');
    sub[2].prompt (3, 0, 34, " Sub item 4 ", '4');

    sub[3].open (1, 45, 6, 58, W_SINGLE, _LGREY|BLUE, _LGREY|BLUE);
    sub[3].set_keyattr (_LGREY|RED);
    sub[3].set_barattr (_BLUE|WHITE);
    sub[3].prompt (0, 0, 41, " Sub item 1 ", '1');
    sub[3].prompt (1, 0, 42, " Sub item 2 ", '2');
    sub[3].prompt (2, 0, 43, " Sub item 3 ", '3');
    sub[3].prompt (3, 0, &sub[4], " Submenu 5  ", '5');

    /*
     * sub[4] is a sub menu of sub[3]
     */
    sub[4].open (4, 58, 9, 71, W_SINGLE, _LGREY|BLUE, _LGREY|BLUE);
    sub[4].set_keyattr (_LGREY|RED);
    sub[4].set_barattr (_BLUE|WHITE);
    sub[4].prompt (0, 0, 51, " Sub item 1 ", '1');
    sub[4].prompt (1, 0, 52, " Sub item 2 ", '2');
    sub[4].prompt (2, 0, 53, " Sub item 3 ", '3');
    sub[4].prompt (3, 0, 54, " Sub item 4 ", '4');

    main_menu.open (0, 0, 0, 79, W_NOBORDER, _LGREY|BLUE);
    main_menu.set_keyattr (_LGREY|RED);
    main_menu.set_barattr (_BLUE|WHITE);
    main_menu.prompt (0,  0, &sub[0], " Submenu 1 ", '1');
    main_menu.prompt (0, 15, &sub[1], " Submenu 2 ", '2');
    main_menu.prompt (0, 30, &sub[2], " Submenu 3 ", '3');
    main_menu.prompt (0, 45, &sub[3], " Submenu 4 ", '4');
    main_menu.prompt (0, 60, 0, " Quit ", "", 'Q');

}

void main ()
{
    Win_mouse_mode (M_FULL);

    Open_Menus ();

    int result = 1;
    WinObj w;

    do  {
        result = main_menu.read (result);

        w.open (12, 15, 17, 50);
        w.printf (" Menu result = %d", result);
        w.printf (3, 1, "Press any key to continue");
        w.get_key ();
        w.close ();

        } while (result != 0);
}


