/*
 *            LVS Windows
 *      The Window Class System
 *
 *        Copyright 1991 (c), Lake View Software
 *                            4321 Harborough Rd.
 *                            Columbus, OH 43220
 *        All rights reserved.
 */

#ifndef LVSMENU_HPP
#define LVSMENU_HPP

#include "LVSwin.HPP"

struct Menu_Selection_s
{
    char *str;      // selection string
    int y,x;        // position
    int ret_val;    // return value
    int *check_ptr; // pointer to check variable  WinCheck
    char key;       // User key
    char *message;  //
    class WinMenu *sub_menu;
    Menu_Selection_s *Next, *Prev;
};

enum Menu_Types {
    MENU_VERT,
    MENU_HORZ,
    MENU_POPUP,
    MENU_SUB,
    MENU_LOTUS,
};

class WinMenu:public WinObj
{
    protected:
        Menu_Selection_s *First, *Last, *Current;
        int my_type;
        int selections;
        int bar_attr;
        int key_attr;
        int m_line;
        int m_attr;
        int map[4];
        int menu_active;
        int exit_status;
        int last_position;
        WinMenu *active_sub;
        WinObj *m_win;
        void show_get (Menu_Selection_s *sel, int highlight);
        void mouse_routine (int y, int x);
        void hide_submenu (WinMenu *m);
        int search_sub (WinMenu *start_menu, int look_for);
    public:
        WinMenu ();
        ~WinMenu ();

        void set_type (int type);
        int prompt (int y,int x,int ret_val,char *str,char *message=NULL,
                char hot_key=0);
        int prompt (int y, int x, int ret_val, char *str, char hot_key);
        int prompt(int y, int x, WinMenu *sub, char *str, char *message=NULL,
                   char key=0);
        int prompt (int y, int x, WinMenu *sub, char *str, char key);
        void hide_chain ();                     // hide entire chain
        int read (int start_sel = -1);          // get menu
        void reset ();                          // reset the menu system
        void close ();
        int set_barattr (int attr);             // returns old value
        int set_keyattr (int attr);             // sets hot key attr
        int message_line (int new_line_no);     // returns old value
        int message_attr (int new_attr);        // returns old value
};


#endif
