/* Copyright 1991 (c),   Lake View Software
                         4321 Harborough Rd.
                         Columbus, OH 43220
*/

#ifndef LVSWIN_H
#define LVSWIN_H

/*
 * Type defs
 */
typedef void (*bk_func)(void);
typedef void (*key_func)(void);
typedef void (*display_atst) (int ,int, char *, char *, int);
typedef void (*display_ch)   (int,int,int,unsigned char);

/*
 * Misc low level screen functions
 */
void Win_init (int mode);
int *Win_save (int, int, int, int);
void Win_restore (int, int, int, int, int *);
void Win_clrscr ();
int Win_setpage (int page);
int Win_getpage ();
void Win_bios (int mode);
void Win_snow (int mode);
void Win_mono (int mode);
int Win_currentmode ();
void Win_dispst (int y, int x, int color, char *str, int count);
void Win_gotoxy (int y,int x);
void Win_getxy (int *y,int *x);
void Win_drawbox (int sr, int sc, int er, int ec, int color, int type);
void Win_hidecur ();
void Win_showcur ();
int Win_map_attr (int attr);
long pow_10 (int i);
double pow_10d (int i);
double dround (double d, int dec);
void Win_beep ();
void Win_delayticks (int ticks);
extern display_atst Win_dispatst;
extern display_ch   Win_dispch;

/*
 * Keyboard functions
 */
int Win_lastkey ();                   /* return the last key pressed */
int Win_keystuf (int key);
int Win_getkey (int seconds);
int Win_keywaiting ();
void Win_setbkloop (bk_func func);
void Win_setonkey (int key, key_func func);
int Win_kbhit ();
int is_read_exit_key (int key);
int Win_DesqView_Aware ();

/*
 * Information functions
 */
int Win_Max_x ();           /* Max screen x coordinate */
int Win_Max_y ();           /* Max screen y coordinate */
struct  Win_time_s
    {
    unsigned char   min;     /* minutes */
    unsigned char   hour;    /* hours */
    unsigned char   hund;    /* hundredths of seconds */
    unsigned char   sec;     /* seconds */
    };
void Win_gettime (struct Win_time_s *t);

/*
 * Control functions
 */
void Win_setcols (int cols);
void Win_setrows (int rows);
int Win_settabsize (int size);

/*
 * String functions 
 */
char *strfill (unsigned char ch, int cnt);
char *strtrim (char *str);
char *str_setsz (char *str,int len);
char *str_clear (char *str,int len);
char *cut_spaces (char *str);
int is_in (unsigned char ch, char *str);

/*
 * VGA functions
 */

int VGA_videotype ();
int VGA_setlines (int lines);  /* Set number of screen lines 25/50 */
int VGA_blinkstate ();      /* return state of blink */
int VGA_setblink (int on_off);
int VGA_fontload ();
extern "C" {
    void far VGA_Fload_16 ();    /* Carefull */
    void far VGA_Fload_14 ();    /* Carefull */
    void far VGA_Fload_8 ();     /* Carefull */
};

/*
 * Scroll display characters
 */

#define RIGHT_ARROW_CHAR   ((unsigned char)0x10)
#define LEFT_ARROW_CHAR    ((unsigned char)0x11)
#define UP_ARROW_CHAR      ((unsigned char)0x1e)
#define DOWN_ARROW_CHAR    ((unsigned char)0x1f)
#define SCROLL_FILL_CHAR   ((unsigned char)0xb0)
#define SCROLL_ELEV_CHAR   ((unsigned char)0xdb)

/*
 * Video types
 */
#define V_VGA       1
#define V_MCGA      2
#define V_EGA       3
#define V_CGA       4
#define V_MONO      5

/*
 * Global Variables 
 */
extern char *Box_char[];                /* in win_box.cpp */

/* 
 * PC Info Functions 
 */
int Share_Loaded ();
int Print_Loaded ();
int Assign_Loaded ();
int Himem_Loaded ();
int Novel_Loaded ();

/*
 * BOOL
 */
#ifndef TRUE
#define TRUE        (1==1)
#define FALSE       (1!=1)
#endif

/* 
 * Wait for retrace to suppress cga snow 
 */
#define waithret()          while((inp(0x03da)&0x01)!=0); \
                            while((inp(0x03da)&0x01)==0)
#define waitvret()          while((inp(0x03da)&0x08)!=0); \
                            while((inp(0x03da)&0x08)==0)

/*
 * Display Segments
 */
#define COLOR_SEG 0xb800
#define MONO_SEG  0xb000

/* 
 * Window init modes 
 */
#define W_DEFAULT 0
#define W_MONO    1     /* Remap colors to mono */
#define W_BIOS    2     /* BIOS video writes */
#define W_SNOW    4     /* CGA snow suppression */
#define W_NOCLEAR 8     /* don't clear the screen with init */

/*
 * Predefined picture styles
 */
#define     DATE_STYLE      'D'
#define     CENTURY_STYLE   'C'
#define     SS_STYLE        'S'
#define     PHONE_STYLE     'P'
#define     ZIP_STYLE       'Z'
#define     UPPER_STYLE     'U'
#define     LOWER_STYLE     'L'
#define     FIRST_STYLE     'F'
#define     ANY_STYLE       'A'

/* 
 * Get Key Modes 
 */
#define W_NOECHO 0
#define W_ECHO   1

/* 
 * Title postions 
 */
#define W_CENTER    0
#define W_LEFT      1
#define W_RIGHT     2

/* 
 * Window Border Definitions 
 */
#define W_NOBORDER 0
#define W_SPACES   1
#define W_DOUBLE   2
#define W_SINGLE   3
#define W_DOUSIN   4
#define W_SOLID    5
#define W_SINDOU   6
#define MAX_BOX_TYPE  6
void Win_Load_Alt_Border ();    /* vga graphics only */
void Win_Load_Alt_Box ();    /* vga graphics only */

/* 
 * Window function return codes 
 */
#define W_OK       0
#define W_ERROR   -1
#define W_NOTOPEN -3
#define W_OPENED  -4
#define W_NOTINIT -5
#define W_NOMEM   -6
#define W_ESCAPE  -27

/* 
 * Window misc 
 */
#define W_ON    1
#define W_OFF   0

/* 
 * Some Colors 
 */
#ifndef BLACK
#define BLACK       0                   
#define BLUE        1
#define GREEN       2
#define CYAN        3
#define RED         4
#define MAGENTA     5
#define BROWN       6
#define YELLOW      14
#define WHITE       15
#endif
#define LGREY       7
#define DGREY       8
#define LBLUE       9
#define LGREEN      10
#define LCYAN       11
#define LRED        12
#define LMAGENTA    13
#define _BLACK      0
#define _BLUE       16
#define _GREEN      32
#define _CYAN       48
#define _RED        64
#define _MAGENTA    80
#define _BROWN      96
#define _LGREY      112
/*
 * VGA highlighted background colors
 */
#define _DGREY      (8*16)
#define _LBLUE      (9*16)
#define _LGREEN     (10*16)
#define _LCYAN      (11*16)
#define _LRED       (12*16)
#define _LMAGENTA   (13*16)
#define _YELLOW     (14*16)
#define _WHITE      (15*16)

/* 
 * Printer attributes   Can be ored together if you printer can handle it 
 */
#define P_UNDERLINE	1
#define P_BOLD			2
#define P_COMPRESS	4
#define P_NORMAL		8

/* 
 * Some keyboard ascii/scan values 
 */
#define   BACK_SPACE   0x0e08
#define   TAB          0x0f09
#define   ESC          0x011B
#define   ENTER        0x1c0d
#define   SPACE_SCAN   0x3920
#define   HOME         0x4700
#define   END          0x4F00
#define   PGUP         0x4900
#define   PGDN         0x5100
#define   UP           0x4800
#define   DOWN         0x5000
#define   RIGHT        0x4D00
#define   LEFT         0x4B00
#define   SHIFT_TAB    0x0F00
#define   SHIFT_UP     0x4838
#define   SHIFT_DOWN   0x5032
#define   SHIFT_RIGHT  0x4d36
#define   SHIFT_LEFT   0x4b34
#define   INS          0x5200
#define   DEL          0x5300
#define   CTRL_HOME    0x7700
#define   CTRL_END     0x7500
#define   CTRL_PGUP    0x8400
#define   CTRL_PGDN    0x7600
#define   CTRL_RIGHT   0x7400
#define   CTRL_LEFT    0x7300
#define   ALT_1        0x7800
#define   ALT_2        0x7900
#define   ALT_3        0x7A00
#define   ALT_4        0x7B00
#define   ALT_5        0x7C00
#define   ALT_6        0x7D00
#define   ALT_7        0x7E00
#define   ALT_8        0x7F00
#define   ALT_9        0x8000
#define   ALT_0        0x8100
#define   ALT_MINUS    0x8200
#define   ALT_EQUAL    0x8300
#define   ALT_Q        0x1000
#define   ALT_W        0x1100
#define   ALT_E        0x1200
#define   ALT_R        0x1300
#define   ALT_T        0x1400
#define   ALT_Y        0x1500
#define   ALT_U        0x1600
#define   ALT_I        0x1700
#define   ALT_M        0x3200
#define   ALT_O        0x1800
#define   ALT_P        0x1900
#define   ALT_A        0x1E00
#define   ALT_S        0x1F00
#define   ALT_D        0x2000
#define   ALT_F        0x2100
#define   ALT_G        0x2200
#define   ALT_H        0x2300
#define   ALT_J        0x2400
#define   ALT_K        0x2500
#define   ALT_L        0x2600
#define   ALT_Z        0x2C00
#define   ALT_X        0x2D00
#define   ALT_C        0x2E00
#define   ALT_V        0x2F00
#define   ALT_B        0x3000
#define   ALT_N        0x3100
#define   ALT_M        0x3200
#define   F1           0x3B00
#define   F2           0x3C00
#define   F3           0x3D00
#define   F4           0x3E00
#define   F5           0x3F00
#define   F6           0x4000
#define   F7           0x4100
#define   F8           0x4200
#define   F9           0x4300
#define   F10          0x4400
#define   CTRL_F1      0x5E00
#define   CTRL_F2      0x5F00
#define   CTRL_F3      0x6000
#define   CTRL_F4      0x6100
#define   CTRL_F5      0x6200
#define   CTRL_F6      0x6300
#define   CTRL_F7      0x6400
#define   CTRL_F8      0x6500
#define   CTRL_F9      0x6600
#define   CTRL_F10     0x6700
#define   CTRL_A       0x1e01
#define   CTRL_B       0x3002
#define   CTRL_C       0x2e03
#define   CTRL_D       0x2004
#define   CTRL_I       0x1709
#define   CTRL_L       0x260c
#define   CTRL_R       0x1312
#define   CTRL_U       0x1615
#define   CTRL_X       0x2d18
#define   CTRL_Y       0x1519
#define   CTRL_Z       0x2c1a
#define   SHIFT_F1     0x5400
#define   SHIFT_F2     0x5500
#define   SHIFT_F3     0x5600
#define   SHIFT_F4     0x5700
#define   SHIFT_F5     0x5800
#define   SHIFT_F6     0x5900
#define   SHIFT_F7     0x5A00
#define   SHIFT_F8     0x5B00
#define   SHIFT_F9     0x5C00
#define   SHIFT_F10    0x5D00
#define   ALT_F1       0x6800
#define   ALT_F2       0x6900
#define   ALT_F3       0x6A00
#define   ALT_F4       0x6B00
#define   ALT_F5       0x6C00
#define   ALT_F6       0x6D00
#define   ALT_F7       0x6E00
#define   ALT_F8       0x6F00
#define   ALT_F9       0x7000
#define   ALT_F10      0x7100

#endif    /* ndef lvswin_h */
