/*
 *            LVS Windows
 *      The Window Class System
 *
 *        Copyright 1991 (c), Lake View Software
 *                            4321 Harborough Rd.
 *                            Columbus, OH 43220
 *        All rights reserved.
 */
// LVS_Prn.hpp

#ifndef LVS_PRN_HPP
#define LVS_PRN_HPP

#include <stdio.h>
#include "LVSwin.HPP"

// Default printer setup codes
#define EPSON_INIT 		"t1"
#define EPSON_RESET		""
#define EPSON_UNDERLINE 	"-1"
#define EPSON_BOLD		"E"
#define EPSON_COMPRESS		"\x0f"
#define EPSON_NORMAL		"-0F"

#pragma warn -par

class Win_Prn:public WinObj
{
    protected:
    void display()          // Display window contents on top
        { needs_display = 0;};  // Fake for virtual
    void update(int start_pos,int len)     // Fake for virtual
        { needs_display = 0;};  // Update a portion of window

    char *prn_port;
    FILE *fp;

    char *Init;
    char *Reset;
    char *Underline;
    char *Bold;
    char *Normal;
    char *Compress;

public:
    Win_Prn (char *port="LPT1", int v_h=66,int v_w=132);
    ~Win_Prn();
    int open (int sr, int sc, int er, int ec, // Fake an open for virtual
            int btype = W_DOUBLE, int wattr = _BLACK|LGREY,
            int battr = _BLACK|LGREY);
    int open ();
    int Win_Prn::change_port (char *new_port);
    void shadow(int on_off=W_ON) {};     // Fake Turn window shadow on/off
    void update() {needs_display = 0;};  // Fake update
    void show_cursor() {};               // Show cursor in window
    void close();                        // Close the window object.
    void set_active() {};                // fake makes window current window
    int get_key(int echo=W_NOECHO, int seconds = 0) {return 0;};
    int read (int clear=1) {clear_gets(); return 0;}; // Dummy Read all defined gets

    /* Window Movement */
    void hide() {};                     // Dummy Hide window
    void unhide() {};                   // Dummy Show window
    int move(int new_y,int new_x) {return W_OK;};   // Dummy Move the window
    int size(int new_height,int new_width) {return W_OK;}; // DummyResize 
    int print_page (int count = 1);        // send page to the printer
    void clean_page () {clr_win();};    // make a Clean page

    void set_pageattr (int new_attr);  // changes the entire pages attributes
    
    /* Printer setup strings */
    void define_init (char *new_init);
    void define_reset (char *new_reset);
    void define_underline (char *new_underline);
    void define_bold (char *new_bold);
    void define_compress (char *new_compress);
    void define_normal (char *new_normal);
};

#pragma warn +par


#endif   /* LVS_PRN_HPP */
