// ObjectWindows - (C) Copyright 1992 by Borland International

#include <owl.h>
#include <mdi.h>
#include <bwcc.h>
#include <stdlib.h>
#include <string.h>
#include <button.h>
#include <edit.h>
#include "mdiapp.h"

#define min( a, b )  (a) < (b) ? (a) : (b)
#define max( a, b )  (a) > (b) ? (a) : (b)

#define WM_MENUCHANGE WM_USER + 1
#define WM_SHOWCHILDREN WM_USER + 2

HMENU hMenuInit, hMenuHello, hMenuRect;
HMENU hMenuInitWindow, hMenuHelloWindow, hMenuRectWindow;  

HHOOK hHook;

typedef struct {
	WORD hlParam;
	WORD llParam;
	WPARAM wParam;
	UINT uMsg;
	HWND hWnd;
} CALLWNDPROC;

LRESULT CALLBACK MsgHook( int nCode, WPARAM wParam, LPARAM lParam )
{
	LRESULT result = 0;

	if( nCode == HC_ACTION )
    {
		if( ((CALLWNDPROC*)lParam)->uMsg == WM_NCHITTEST )
			MessageBeep( 0 );
	}
	else
		result =  CallNextHookEx( hHook, nCode, wParam, lParam );
	return( result );
}
    	

// Define a TApplication descendant
class TMDIApp : public TApplication {
public:
    TMDIApp(   LPSTR name, 
               HINSTANCE hInstance,
		        HINSTANCE hPrevInstance, 
               LPSTR lpCmd,
		        int nCmdShow)
	    : TApplication( name, 
                       hInstance,
					    hPrevInstance, 
                       lpCmd, 
                       nCmdShow )
	 { 
       HAccTable = LoadAccelerators( hInstance,
                                     "ACCELERATORS_1" );
    };

     virtual void InitMainWindow();
};

class THello;


// Define a TMDIFrame descendant
class TMyMDIFrame : public TMDIFrame {
public:
  WORD ChildNum;
  PTDialog pRibbonBar;
  int  nRBarHeight;
  THello *hello;
  

  TMyMDIFrame(LPSTR ATitle, LPSTR MenuName);
   virtual void WMClose(RTMessage Msg) = [WM_FIRST + WM_CLOSE]
  {
	  DeleteMenu( );
	  TMDIFrame::WMClose( Msg );
  }

  virtual void CMExit(RTMessage Msg)
  {
     DeleteMenu( );
     TMDIFrame::CMExit(Msg);
  }
  virtual void InitClientWindow( )
  {
	ClientWnd = new TMDIClient( this );
	ClientWnd->Attr.Style |= WS_VSCROLL | WS_HSCROLL | MDIS_ALLCHILDSTYLES;
  }

  void DeleteMenu( )
  {
     HMENU hMenu = GetMenu( HWindow );
     if( hMenuInit != hMenu )
 			DestroyMenu( hMenuInit );
     if( hMenuHello != hMenu )
			DestroyMenu( hMenuHello );
     if( hMenuRect != hMenu )
			DestroyMenu( hMenuRect );

     UnhookWindowsHookEx( hHook );
  }
  virtual void WMSize( RTMessage Msg ) = [WM_FIRST + WM_SIZE];
  virtual void WMMDIMaximize( RTMessage Msg ) = [WM_FIRST + WM_MDIMAXIMIZE]
  {
     DefWndProc( Msg );
     MessageBeep( 0 );
  }
  virtual void SetupWindow( );
  virtual void ToggleRibbon( RTMessage Msg ) = [CM_FIRST + CM_RIBBON]
  {
       RECT rect;
       GetClientRect( HWindow, &rect );

       if( IsWindowVisible( pRibbonBar->HWindow ) )
       {
		    pRibbonBar->Show( SW_HIDE );
	        MoveWindow( ClientWnd->HWindow, 
                       rect.left, 
                       rect.top, 
                       rect.right, 
                       rect.bottom, 
                       TRUE );
       }
       else
       {
	        MoveWindow( ClientWnd->HWindow,
                       0, 
                       nRBarHeight,
                       rect.right, 
                       rect.bottom - nRBarHeight, 
                       TRUE );
           MoveWindow( pRibbonBar->HWindow, 
                       0, 
                       0, 
                       rect.right, 
                       nRBarHeight, 
                       FALSE );
	        pRibbonBar->Show( SW_SHOW );
       }
	   
  }
  virtual void NewHello(RTMessage Msg) =
					[CM_FIRST + CM_NEWHELLO];
  virtual void NewRectangle(RTMessage Msg) =
					[CM_FIRST + CM_NEWRECT];
  virtual void MenuChange(RTMessage Msg) =
					[WM_FIRST + WM_MENUCHANGE]
  {
		SendMessage( ClientWnd->HWindow, WM_MDISETMENU, 0, Msg.LParam );
		DrawMenuBar( HWindow );
  }

};



class THello : public TWindow
{
public:
	DWORD color;
	HDC hDC;
	PTEdit edit;
    PTButton button;
	THello( PTWindowsObject AParent, LPSTR ATitle ) :
		TWindow( AParent, ATitle )
	{
			color = RGB( 0x00, 0x00, 0x00 );
			Attr.Style |= WS_VISIBLE | WS_THICKFRAME | WS_CLIPSIBLINGS;
   };
   virtual void SetupWindow( )
   {
	  TWindow::SetupWindow( );
	  hDC = GetDC( HWindow );
   }
   LPSTR GetClassName( ) { return( "HelloClass" ); }
   virtual void GetWindowClass( WNDCLASS& AWndClass )
   {
       TWindow::GetWindowClass( AWndClass );
	   AWndClass.hCursor = LoadCursor( NULL, IDC_CROSS );

       AWndClass.style |= CS_OWNDC;
   }
   virtual void ToggleRibbon( RTMessage Msg ) = [CM_FIRST + CM_RIBBON]
   {
       RTMessage AMsg = Msg;
       Parent->DispatchAMessage( CM_FIRST+CM_RIBBON, Msg, &TWindow::DefCommandProc );

   }
   virtual void CMBlack(RTMessage) =
					[CM_FIRST + CM_BLACK];
   virtual void CMRed(RTMessage) =
					[CM_FIRST + CM_RED];
	virtual void Paint( HDC PaintDC, PAINTSTRUCT &PaintInfo );
	virtual void WMMDIActivate(RTMessage Msg ) =
					[WM_FIRST + WM_MDIACTIVATE];
};

class TRectangle : public TWindow
{
public:
	TRectangle( PTWindowsObject AParent, LPSTR ATitle ) :
		TWindow( AParent, ATitle ) 
   {
		Attr.Style |= WS_VISIBLE | WS_THICKFRAME | WS_CAPTION |
					  WS_SYSMENU | WS_CLIPSIBLINGS;
   };
   LPSTR GetClassName( ) { return( "RectangeClass" ); }
   virtual void GetWindowClass( WNDCLASS& AWndClass )
   {
	   TWindow::GetWindowClass( AWndClass );
	   AWndClass.hbrBackground = CreateSolidBrush( RGB( 0x00, 0x00, 0xFF ) );
       AWndClass.hCursor = LoadCursor( NULL, IDC_IBEAM );
   }
	~TRectangle( )
	{
		KillTimer( HWindow, 1 );
	}
   virtual void SetupWindow( );
	virtual void Paint( HDC PaintDC, PAINTSTRUCT &PaintInfo );
   virtual void ToggleRibbon( RTMessage Msg ) = [CM_FIRST + CM_RIBBON]
   {
       RTMessage AMsg = Msg;
       Parent->DispatchAMessage( CM_FIRST+CM_RIBBON, Msg, &TWindow::DefCommandProc );
       
   }
	virtual void WMTimer(RTMessage Msg) =
   				[WM_FIRST + WM_TIMER];
	virtual void WMMDIActivate(RTMessage Msg ) =
					[WM_FIRST + WM_MDIACTIVATE];
};

// Construct the TMDIApp's MainWindow object, loading its menu
void TMDIApp::InitMainWindow()
{
  MainWindow = new TMyMDIFrame("MDI Conformist", "MDIMENUINIT");
}

TMyMDIFrame::TMyMDIFrame(LPSTR ATitle, LPSTR MenuName)
             : TMDIFrame(ATitle, MenuName)
{   
  pRibbonBar = new TDialog( this, "RIBBONDIALOG" );
  ChildNum = 1;
  ChildMenuPos = INIT_MENU_POS;
}

void TMyMDIFrame::SetupWindow( )
{
	TMDIFrame::SetupWindow( );

    hMenuRect = LoadMenu( GetApplication()->hInstance, "MDIMENURECT" );
	hMenuHello = LoadMenu( GetApplication()->hInstance, "MDIMENUHELLO" );

	hMenuInit = GetMenu( HWindow );
	hMenuInitWindow = GetSubMenu( hMenuInit, INIT_MENU_POS );
	hMenuHelloWindow = GetSubMenu( hMenuHello, HELLO_MENU_POS );
	hMenuRectWindow = GetSubMenu( hMenuRect, RECT_MENU_POS );

    if ( pRibbonBar )
    {
        RECT rc;
        GetApplication()->MakeWindow( pRibbonBar );
        GetWindowRect( pRibbonBar->HWindow, &rc  );
        nRBarHeight = rc.bottom - rc.top;
        ShowWindow( pRibbonBar->HWindow, SW_SHOWNORMAL );
	UpdateWindow( pRibbonBar->HWindow );
	}
	hHook = SetWindowsHookEx( WH_CALLWNDPROC,
							  (HOOKPROC)MsgHook,
							  GetApplication( )->hInstance,
							  NULL );
}

#pragma warn -par-
void TMyMDIFrame::NewHello(RTMessage Msg)
{
	char ChildName[14];
	wsprintf( ChildName, "MDI Child %d", ChildNum++ );
	GetApplication()->MakeWindow( new THello( this, ChildName ) );
}

#pragma warn -par-
void TMyMDIFrame::NewRectangle(RTMessage Msg)
{
	char ChildName[14];
	wsprintf( ChildName, "MDI Child %d", ChildNum++ );
	GetApplication()->MakeWindow( new TRectangle( this, ChildName ) );
}

void TMyMDIFrame::WMSize( RTMessage msg )
{
    TMDIFrame::WMSize( msg );
    if ( pRibbonBar && IsWindowVisible( pRibbonBar->HWindow ) )
    {
        MoveWindow( ClientWnd->HWindow,
                    0, nRBarHeight,
                    LOWORD( msg.LParam ),
		    HIWORD( msg.LParam ) - nRBarHeight, TRUE );
        MoveWindow( pRibbonBar->HWindow, 0, 0, 
                    LOWORD( msg.LParam ),
		    nRBarHeight, FALSE );
    }
}



#pragma warn -par-
void THello::CMBlack(RTMessage Msg)
{
	color = (DWORD) RGB( 0x00, 0x00, 0x00 );
   InvalidateRect( HWindow, NULL, FALSE );
}

void THello::CMRed(RTMessage Msg)
{
	color = (DWORD) RGB( 0xFF, 0x00, 0x00 );
   InvalidateRect( HWindow, NULL, FALSE );
}

void THello::Paint( HDC PaintDC, PAINTSTRUCT &PaintInfo )
{
	RECT rect;

	TWindow::Paint( PaintDC, PaintInfo );

	SetTextColor( PaintDC, color );
	GetClientRect( HWindow, &rect );
	DrawText( PaintDC, "Hello, World!", -1, &rect,
				 DT_SINGLELINE | DT_CENTER | DT_VCENTER ); 

/*	TEXTMETRIC tm;
   GetTextMetrics( PaintDC, &tm );
	int count;
   count = 0;
	PTWindowsObject aChild = Parent->GetFirstChild( );
	PTWindowsObject last = Parent->GetLastChild( );
   PTWindowsObject current;
	if( aChild )
	{
    	do
    	{
			current = aChild;
			char buffer[30];
			wsprintf( buffer, "Child %d window handle: %d", ++count, current->HWindow );
			TextOut( PaintDC, tm.tmAveCharWidth, tm.tmHeight * count, buffer, strlen(buffer) );
      		aChild = aChild->Next();
    	}
		while ( current != last );
    }  */
   
}

void THello::WMMDIActivate( RTMessage Msg )
{
	TWindow::WMMDIActivate( Msg );


	if( Msg.WParam == TRUE )
		PostMessage( Parent->HWindow, WM_MENUCHANGE, 0,
						 MAKELONG( hMenuHello, hMenuHelloWindow ) );

	if( Msg.WParam == FALSE )
		PostMessage( Parent->HWindow, WM_MENUCHANGE, 0,
						 MAKELONG( hMenuInit, hMenuInitWindow ) );

}

void TRectangle::SetupWindow( )
{
	TWindow::SetupWindow( );
	SetTimer( HWindow, 1, 250, NULL );
}


void TRectangle::Paint( HDC PaintDC, PAINTSTRUCT &PaintInfo )
{
	TWindow::Paint( PaintDC, PaintInfo );
}

void TRectangle::WMTimer( RTMessage Msg )
{
	RECT rect;
	GetClientRect( HWindow, &rect );

	short xLeft = rand( ) % (rect.right - rect.left);
	short xRight = rand( ) % (rect.right - rect.left );
	short yTop = rand( ) % (rect.bottom - rect.top );
	short yBottom = rand( ) % (rect.bottom - rect.top );
	short nRed = rand( ) & 255;
	short nGreen = rand( ) & 255;
	short nBlue = rand( ) & 255;

    HDC hDC = GetDC( HWindow );
	HBRUSH hBrush = CreateSolidBrush( RGB( nRed, nGreen, nBlue ) );
	HBRUSH oldBrush = (HBRUSH)SelectObject( hDC, hBrush );
	Rectangle( hDC, min( xLeft, xRight ), min( yTop, yBottom ),
						 max( xLeft, xRight ), max( yTop, yBottom ) );
	SelectObject( hDC, oldBrush );
	ReleaseDC( HWindow, hDC );
	DeleteObject( hBrush );
}

void TRectangle::WMMDIActivate( RTMessage Msg )
{
	TWindow::WMMDIActivate( Msg );


	if( Msg.WParam == TRUE )
		PostMessage( Parent->HWindow, WM_MENUCHANGE, 0,
						 MAKELONG( hMenuRect, hMenuRectWindow ) );

	if( Msg.WParam == FALSE )
		PostMessage( Parent->HWindow, WM_MENUCHANGE, 0,
						 MAKELONG( hMenuInit, hMenuInitWindow ) );

}



// Run the MDIApp
int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
		   LPSTR lpCmd, int nCmdShow)
{
	BWCCGetVersion( );
    TMDIApp MDIApp ("MDIApp", hInstance, hPrevInstance,
		lpCmd, nCmdShow);
	MDIApp.Run();
    return (MDIApp.Status);
}



















