// ---------- //
// MDIDLG.CPP //
// ---------- //

#include <owl.h>
#include <dialog.h>
#include <bwcc.h>
#include <mdi.h>


_CLASSDEF( TMyMDIApp )
_CLASSDEF( TMyMDIFrame )
_CLASSDEF( TMyMDIChild )


class TMDIApp : public TApplication
{
    public:
        TMDIApp( LPSTR name,
                 HANDLE hInstance,
                 HANDLE hPrevInstance,
                 LPSTR lpCmd,
                 int nCmdShow ) :
        TApplication( name, hInstance, 
                      hPrevInstance, lpCmd, nCmdShow )
        {};
        virtual void InitMainWindow();
};



class TMyMDIFrame : public TMDIFrame
{
        int nTBarHeight;
        PTDialog pToolBar;
    public:
        TMyMDIFrame( LPSTR ATitle, LPSTR MenuName ) :
        TMDIFrame( ATitle, MenuName )
        {
            pToolBar = new TDialog( this, "BARDIALOG" );
        }
        virtual void SetupWindow();
        virtual PTWindowsObject InitChild();
        virtual void WMSize( RTMessage msg ) =
                   [ WM_FIRST + WM_SIZE ];
};



class TMyMDIChild : public TWindow
{
    public:
        TMyMDIChild( PTWindowsObject AParent,
                     LPSTR ChildName,
                     PTModule AModule );
};



PTWindowsObject TMyMDIFrame::InitChild()
{
    return( new TMyMDIChild( this, "MDI-Child", NULL ));
}


void TMyMDIFrame::SetupWindow()
{
    TMDIFrame::SetupWindow();

    if ( pToolBar )
    {
        RECT rc;
        GetApplication()->MakeWindow( pToolBar );
        GetWindowRect( pToolBar->HWindow, &rc  );
        nTBarHeight = rc.bottom - rc.top;
        ShowWindow( pToolBar->HWindow, SW_SHOWNORMAL );
        UpdateWindow( pToolBar->HWindow );
    }
}


void TMyMDIFrame::WMSize( RTMessage msg )
{
    TMDIFrame::WMSize( msg );
    if ( pToolBar )
    {
        MoveWindow( ClientWnd->HWindow,
                    0, nTBarHeight,
                    LOWORD( msg.LParam ),
                    HIWORD( msg.LParam ) - nTBarHeight, TRUE );
        MoveWindow( pToolBar->HWindow, 0, 0, 
                    LOWORD( msg.LParam ),
                    nTBarHeight, FALSE );
    }
}


TMyMDIChild::TMyMDIChild( PTWindowsObject AParent,
                          LPSTR ChildName,
                          PTModule AModule ) :
TWindow( AParent, ChildName, AModule )
{
}



void TMDIApp::InitMainWindow()
{
    MainWindow = new TMyMDIFrame( "MDI App.", "MDIMenu");
}



int PASCAL WinMain( HANDLE hInstance, HANDLE hPrevInstance,
                    LPSTR lpszCmdLine, int nCmdShow )
{
    TMDIApp MDIApp ( "MDI App.",
                      hInstance,
                      hPrevInstance,
                      lpszCmdLine,
                      nCmdShow );
    BWCCGetVersion();
    MDIApp.Run();
    return ( MDIApp.Status );
}
