// Primary Function and Constant Definition file for LAS

#define LEN_LastName    20 + 1
#define LEN_FirstName   14 + 1
#define LEN_Middle_I     1 + 1
#define LEN_Prefix       6 + 1
#define LEN_Suffix       3 + 1
#define LEN_Title       30 + 1
#define LEN_Courtesy    28 + 1

typedef struct {
   char     LastName    [LEN_LastName ];
   char     FirstName   [LEN_FirstName];
   char     Middle_I    [LEN_Middle_I ];
   char     Prefix      [LEN_Prefix   ];
   char     Suffix      [LEN_Suffix   ];
   char     Title       [LEN_Title    ];
   char     Courtesy    [LEN_Courtesy ]; // Default <Prefix> <Lastname> as in "Dear Mr. Brown;"
} NAMECMB;

#define LEN_ICA           4 + 1
#define LEN_Affil         4 + 1
#define LEN_Name1        30 + 1
#define LEN_Name2        30 + 1
#define LEN_City         20 + 1
#define LEN_State         3 + 1
#define LEN_Zip          10 + 1
#define LEN_Region        2 + 1
#define LEN_Phone        18 + 1
#define LEN_Telex        18 + 1
#define LEN_Fax          14 + 1
#define LEN_Issuer        1 + 1
#define LEN_Type          2 + 1
#define LEN_Terr          4 + 1
#define LEN_Handling     10 + 1
#define LEN_Intl          1 + 1
#define LEN_Ica_Key       4 + 1
#define LEN_Old_Key       4 + 1
#define LEN_Laddr_Seq     2 + 1
#define LEN_Maddr_Seq     2 + 1
#define LEN_Sequence      2 + 1
#define LEN_Mail_Stat     1 + 1
#define LEN_Mim_Stat      1 + 1
#define LEN_Surv_Stat     1 + 1
#define LEN_Status        1 + 1
#define LEN_Prod_Sig      1 + 1
#define LEN_Signature     1 + 1
#define LEN_Update        8 + 1     // Long - Date
#define LEN_Comment      10 + 1

#define LEN_L_Req         4 + 1
#define LEN_InstAddr1    25 + 1
#define LEN_InstAddr2    25 + 1
#define LEN_InstAddr3    25 + 1
#define LEN_InstCity     20 + 1
#define LEN_InstState     3 + 1
#define LEN_InstZip      10 + 1
//      LEN_Ceo                     // Name field - No length needed
#define LEN_CeoPhone     18 + 1
#define LEN_CeoTelex     18 + 1
#define LEN_CeoFax       14 + 1
//      LEN_Contact                 // Name field - No length needed
#define LEN_CntPhone     18 + 1
#define LEN_CntTelex     18 + 1
#define LEN_CntFax       14 + 1

#define LEN_BODPres       8 + 1     // Long - Date
#define LEN_BODAction     6 + 1
#define LEN_BODExcl       1 + 1

#define LEN_OrgType      10 + 1
#define LEN_Insurance    10 + 1
#define LEN_Fee1         14 + 1     // Double - Dollar Amount
#define LEN_Fee2         14 + 1     // Double - Dollar Amount
#define LEN_Fee3         14 + 1     // Double - Dollar Amount
#define LEN_Interim       1 + 1

#define LEN_Spon_C_Iss    4 + 1
#define LEN_Spon_C_Acq    4 + 1
#define LEN_Spon_N_Iss    4 + 1
#define LEN_Spon_N_Acq    4 + 1

#define LEN_Area_Cur     10 + 1
#define LEN_Area_Req     10 + 1

#define LEN_Doc_List    160 + 1
#define LEN_Doc_Rcv     160 + 1
#define LEN_Doc_Due     160 + 1
#define LEN_Doc_More     80 + 1
   
#define LEN_NewName1     30 + 1
#define LEN_NewName2     30 + 1
#define LEN_Varience      8 + 1     // Long - Date Field
   
#define LEN_IcaLst       28 + 1
#define LEN_BinLst       42 + 1
#define LEN_BinUse       14 + 1
   
#define LEN_Terminate     1 + 1
#define LEN_TermDesc     40 + 1
#define LEN_TermDate      8 + 1     // Long - Date Field

typedef struct {
   char     ICA         [LEN_ICA       ];   // Principal Member or Sponsor's ID
   char     Affil       [LEN_Affil     ];   // Affliate Number - 0 for Principals
   char     Name1       [LEN_Name1     ];   // Institution Name Part 1
   char     Name2       [LEN_Name2     ];   // Institution Name Part 2
   char     City        [LEN_City      ];   // HQ Location
   char     State       [LEN_State     ];
   char     Zip         [LEN_Zip       ];
   char     Region      [LEN_Region    ];
   char     Phone       [LEN_Phone     ];   // HQ Phone
   char     Telex       [LEN_Telex     ];   //    Telex
   char     Fax         [LEN_Fax       ];   //    FAX
   char     Issuer      [LEN_Issuer    ];   // I-Issuer A-Acquirer B-Both (Principal only)
   char     Type        [LEN_Type      ];   // P-Principal KP-KeyPrincipal A-Affil KA-KeyAffil
   char     Terr        [LEN_Terr      ];
   char     Handling    [LEN_Handling  ];
   char     Intl        [LEN_Intl      ];   // Indicates D-Domestic or I-International
   char     Ica_Key     [LEN_Ica_Key   ];
   char     Old_Key     [LEN_Old_Key   ];
   char     Laddr_Seq   [LEN_Laddr_Seq ];
   char     Maddr_Seq   [LEN_Maddr_Seq ];
   char     Sequence    [LEN_Sequence  ];
   char     Mail_Stat   [LEN_Mail_Stat ];
   char     Mim_Stat    [LEN_Mim_Stat  ];
   char     Surv_Stat   [LEN_Surv_Stat ];
   char     Status      [LEN_Status    ];
   char     Prod_Sig    [LEN_Prod_Sig  ];
   char     Signature   [LEN_Signature ];
   long     Update                      ;    // Field Length LEN_Update
   char     Comment     [LEN_Comment   ];

   char     L_Req       [LEN_L_Req     ];   // Licensing Request (4 character key)
   char     InstAddr1   [LEN_InstAddr1 ];
   char     InstAddr2   [LEN_InstAddr2 ];
   char     InstAddr3   [LEN_InstAddr3 ];
   char     InstCity    [LEN_InstCity  ];
   char     InstState   [LEN_InstState ];
   char     InstZip     [LEN_InstZip   ];
   NAMECMB  Ceo                         ;   // Combination Field - CEO Name
   char     CeoPhone    [LEN_CeoPhone  ];
   char     CeoTelex    [LEN_CeoTelex  ];
   char     CeoFax      [LEN_CeoFax    ];
   NAMECMB  Contact                     ;  // Combination Field - Contact Name and Phone
   char     CntPhone    [LEN_CntPhone  ];
   char     CntTelex    [LEN_CntTelex  ];
   char     CntFax      [LEN_CntFax    ];

   long     BODPres                     ;   // Board of Director's Presentation Date
   char     BODAction   [LEN_BODAction ];   // Board of Director's Action
   char     BODExcl     [LEN_BODExcl   ];   // Exclude from BOD Presentation

   char     OrgType     [LEN_OrgType   ];   // Organization Type - Bank, S&L, etc.
   char     Insurance   [LEN_Insurance ];   // Insurance Type - FICA, FSLIC, etc.
   double   Fee1                        ;   //
   double   Fee2                        ;   //
   double   Fee3                        ;   //
   char     Interim     [LEN_Interim   ];   // Interim License Issued.

   char     Spon_C_Iss  [LEN_Spon_C_Iss];   // Current Issuing Sponsor
   char     Spon_C_Acq  [LEN_Spon_C_Acq];   // Current Acquiring Sponsor
   char     Spon_N_Iss  [LEN_Spon_N_Iss];   // New Issuing Sponsor
   char     Spon_N_Acq  [LEN_Spon_N_Acq];   // New Acquiring Sponsor

   char     Area_Cur    [LEN_Area_Cur  ];   // Current Area of Use
   char     Area_Req    [LEN_Area_Req  ];   // Requested Area of Use

   char     Doc_List    [LEN_Doc_List  ];   // List of 20 Required Documents (8 letter key word)
   char     Doc_Rcv     [LEN_Doc_Rcv   ];   // Send/Receive Dates for 20 documents   20 x 8
   char     Doc_Due     [LEN_Doc_Due   ];   // Date Documents are Due to be Received 20 x 8
   char     Doc_More    [LEN_Doc_More  ];   // Flags for More Info  10 x 8 - Each field coores. to a WW field
   
   char     NewName1    [LEN_NewName1  ];   // Institution Name 1 for Name Change
   char     NewName2    [LEN_NewName2  ];   // Institution Name 2 for Name Change
   long     Varience                    ;   // Varience thru date
   
   char     IcaLst      [LEN_IcaLst    ];   // List of Additional ICAs Requested
   char     BinLst      [LEN_BinLst    ];   // Collection of 7 6 digit bin prefixes
   char     BinUse      [LEN_BinUse    ];   // Collection of 7 2 char bin use flags RO PC DC GC GD
   
   char     Terminate   [LEN_Terminate ];   // Termination Reason
   char     TermDesc    [LEN_TermDesc  ];   // Termination Description
   long     TermDate                    ;   // Termination Effective Date

} APPLICATION;

