// This example is a modified MDIAPP example which demonstrates
// a MDI Frame menu which changes depending on the child with
// the current focus.
//========================================================================
//  The following example routines have been provided by the Technical
//  Support staff at Borland International.  They are provided as a
//  courtesy and not as part of a Borland product, and as such, are
//  provided without the assurance of technical support or any specific
//  guarantees.
//========================================================================


#include <owl.h>
#include <mdi.h>
#include <stdlib.h>
#include "mdiapp.h"

#define min( a, b )  (a) < (b) ? (a) : (b)
#define max( a, b )  (a) > (b) ? (a) : (b)

#define WM_MENUCHANGE WM_USER + 1

HMENU hMenuInit, hMenuHello, hMenuRect;
HMENU hMenuInitWindow, hMenuHelloWindow, hMenuRectWindow;

// Define a TApplication descendant
class TMDIApp : public TApplication {
public:
    TMDIApp(LPSTR name, HINSTANCE hInstance,
		  HINSTANCE hPrevInstance, LPSTR lpCmd,
		  int nCmdShow)
	        : TApplication(name, hInstance,
					 hPrevInstance, lpCmd, nCmdShow)
	 { };

     virtual void InitMainWindow();
};

// Define a TMDIFrame descendant
class TMyMDIFrame : public TMDIFrame {
public:
  WORD ChildNum;

  TMyMDIFrame(LPSTR ATitle, LPSTR MenuName);
  virtual void WMClose(RTMessage Msg) = [WM_FIRST + WM_CLOSE ]
  {
	  HMENU hMenu = GetMenu( HWindow );
	  if( hMenuInit != hMenu )
 			DestroyMenu( hMenuInit );
     if( hMenuHello != hMenu )
			DestroyMenu( hMenuHello );
     if( hMenuRect != hMenu )
			DestroyMenu( hMenuRect );
	  TMDIFrame::WMClose( Msg );
  }
  virtual void SetupWindow( );
  virtual void NewHello(RTMessage Msg) =
					[CM_FIRST + CM_NEWHELLO];
  virtual void NewRectangle(RTMessage Msg) =
					[CM_FIRST + CM_NEWRECT];
  virtual void MenuChange(RTMessage Msg) =
					[WM_FIRST + WM_MENUCHANGE]
  {
		SendMessage( ClientWnd->HWindow, WM_MDISETMENU, 0, Msg.LParam );
		DrawMenuBar( HWindow );
  }
};

class THello : public TWindow
{
public:
	DWORD color;
	THello( PTWindowsObject AParent, LPSTR ATitle ) :
		TWindow( AParent, ATitle )
	{
			color = RGB( 0x00, 0x00, 0x00 );
   };
	virtual void CMBlack(RTMessage) =
					[CM_FIRST + CM_BLACK];
   virtual void CMRed(RTMessage) =
					[CM_FIRST + CM_RED];
	virtual void Paint( HDC PaintDC, PAINTSTRUCT &PaintInfo );
	virtual void WMMDIActivate(RTMessage Msg ) =
					[WM_FIRST + WM_MDIACTIVATE];
};

class TRectangle : public TWindow
{
public:
	TRectangle( PTWindowsObject AParent, LPSTR ATitle ) :
		TWindow( AParent, ATitle ) { };
	~TRectangle( ) { KillTimer( HWindow, 1 ); }
   virtual void SetupWindow( );
	virtual void Paint( HDC PaintDC, PAINTSTRUCT &PaintInfo );
	virtual void WMTimer(RTMessage Msg) =
   				[WM_FIRST + WM_TIMER];
	virtual void WMMDIActivate(RTMessage Msg ) =
					[WM_FIRST + WM_MDIACTIVATE];
};

// Construct the TMDIApp's MainWindow object, loading its menu
void TMDIApp::InitMainWindow()
{
  MainWindow = new TMyMDIFrame("MDI Conformist", "MDIMENUINIT");
}

TMyMDIFrame::TMyMDIFrame(LPSTR ATitle, LPSTR MenuName)
             : TMDIFrame(ATitle, MenuName)
{   
  ChildNum = 1;
  ChildMenuPos = INIT_MENU_POS;
}

void TMyMDIFrame::SetupWindow( )
{
	TMDIFrame::SetupWindow( );

	hMenuRect = LoadMenu( GetApplication()->hInstance, "MDIMENURECT" );
	hMenuHello = LoadMenu( GetApplication()->hInstance, "MDIMENUHELLO" );

	hMenuInit = GetMenu( HWindow );
	hMenuInitWindow = GetSubMenu( hMenuInit, INIT_MENU_POS );
	hMenuHelloWindow = GetSubMenu( hMenuHello, HELLO_MENU_POS );
	hMenuRectWindow = GetSubMenu( hMenuRect, RECT_MENU_POS );
}

#pragma warn -par-
void TMyMDIFrame::NewHello(RTMessage Msg)
{
	char ChildName[14];
	wsprintf( ChildName, "MDI Child %d", ChildNum++ );
	GetApplication()->MakeWindow( new THello( this, ChildName ) );
}

#pragma warn -par-
void TMyMDIFrame::NewRectangle(RTMessage Msg)
{
	char ChildName[14];
	wsprintf( ChildName, "MDI Child %d", ChildNum++ );
	GetApplication()->MakeWindow( new TRectangle( this, ChildName ) );
}

#pragma warn -par-
void THello::CMBlack(RTMessage Msg)
{
	color = (DWORD) RGB( 0x00, 0x00, 0x00 );
   InvalidateRect( HWindow, NULL, FALSE );
}

void THello::CMRed(RTMessage Msg)
{
	color = (DWORD) RGB( 0xFF, 0x00, 0x00 );
   InvalidateRect( HWindow, NULL, FALSE );
}

void THello::Paint( HDC PaintDC, PAINTSTRUCT &PaintInfo )
{
	RECT rect;

	TWindow::Paint( PaintDC, PaintInfo );

	SetTextColor( PaintDC, color );
	GetClientRect( HWindow, &rect );
	DrawText( PaintDC, "Hello, World!", -1, &rect,
				 DT_SINGLELINE | DT_CENTER | DT_VCENTER );
}

void THello::WMMDIActivate( RTMessage Msg )
{
	TWindow::WMMDIActivate( Msg );

//	HWND client = GetParent( HWindow );
//   HWND frame  = GetParent( client );

	if( Msg.WParam == TRUE )
		PostMessage( Parent->HWindow, WM_MENUCHANGE, 0,
						 MAKELONG( hMenuHello, hMenuHelloWindow ) );

	if( Msg.WParam == FALSE )
		PostMessage( Parent->HWindow, WM_MENUCHANGE, 0,
						 MAKELONG( hMenuInit, hMenuInitWindow ) );

//	DrawMenuBar( frame );
}

void TRectangle::SetupWindow( )
{
	TWindow::SetupWindow( );
	SetTimer( HWindow, 1, 250, NULL );
}


void TRectangle::Paint( HDC PaintDC, PAINTSTRUCT &PaintInfo )
{
	TWindow::Paint( PaintDC, PaintInfo );
}

void TRectangle::WMTimer( RTMessage Msg )
{
	RECT rect;
	GetClientRect( HWindow, &rect );

	short xLeft = rand( ) % (rect.right - rect.left);
	short xRight = rand( ) % (rect.right - rect.left );
	short yTop = rand( ) % (rect.bottom - rect.top );
	short yBottom = rand( ) % (rect.bottom - rect.top );
	short nRed = rand( ) & 255;
	short nGreen = rand( ) & 255;
	short nBlue = rand( ) & 255;

   HDC hDC = GetDC( HWindow );
	HBRUSH hBrush = CreateSolidBrush( RGB( nRed, nGreen, nBlue ) );
	SelectObject( hDC, hBrush );
	Rectangle( hDC, min( xLeft, xRight ), min( yTop, yBottom ),
						 max( xLeft, xRight ), max( yTop, yBottom ) );
	ReleaseDC( HWindow, hDC );
	DeleteObject( hBrush );
}

void TRectangle::WMMDIActivate( RTMessage Msg )
{
	TWindow::WMMDIActivate( Msg );

//	HWND client = GetParent( HWindow );
//   HWND frame  = GetParent( client );

	if( Msg.WParam == TRUE )
		PostMessage( Parent->HWindow, WM_MENUCHANGE, 0,
						 MAKELONG( hMenuRect, hMenuRectWindow ) );

	if( Msg.WParam == FALSE )
		PostMessage( Parent->HWindow, WM_MENUCHANGE, 0,
						 MAKELONG( hMenuInit, hMenuInitWindow ) );

//  DrawMenuBar( frame );
}


/*
PTWindowsObject TMyMDIFrame::InitChild()
{
  char ChildName[14];

  wsprintf(ChildName,"MDI Child %d", ChildNum++);
  return new TWindow(this, ChildName);
}
*/

// Run the MDIApp
int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
		   LPSTR lpCmd, int nCmdShow)
{
    TMDIApp MDIApp ("MDIApp", hInstance, hPrevInstance,
		lpCmd, nCmdShow);
    MDIApp.Run();
    return (MDIApp.Status);
}
