#include <stdio.h>
#include <dos.h>

#define NON_VIRTUAL 0

class test;
typedef void (test::*vtptr)(void);

typedef void (*fptr)(void);
#define NEAR_CODE (sizeof(fptr) == 2)

struct v_entry
{
   unsigned virt1;
   unsigned virtual_level;
   unsigned f_offset;
   unsigned f_segment;
};

union
{
   v_entry v;
   vtptr   f;
} u;


class testbase
{
public:
   virtual void three( void ) { printf("Base three\n"); }
   void four( void ) { printf("Base four\n"); }
};

class test : public testbase
{
public:
   virtual void one( void ) { printf("one\n"); }
   void two( void ) { printf("two\n"); }
   void addr( vtptr func );
};

void test::addr( vtptr func)
{
   unsigned far *p;
   unsigned d_off, tbl_off;
   unsigned far *segoff;

   //  Execute the function passed in
   (this->*func)();

   //  Throw the pointer address into a union.  This way we can
   //  Get at the information in the 8 byte table without the
   //  compiler being too smart for us.  We also don't have to
   //  worry about coding around a "cannot cast from X to Y"
   //  error message this way.

   u.f = func;

   //  Function is not virtual, just grap segment offset from table

   if (u.v.virtual_level == NON_VIRTUAL)
   {
       if (u.v.f_segment == 0)
          printf("Near non-virtual function at CS:%X\n",
                 u.v.f_offset);
       else
          printf("Non virtual funciton at %X:%X\n",
                 u.v.f_segment, u.v.f_offset );
   }
   else   // must decode virtual table
   {
      // The offset in the table is the offset from the 'this' pointer
      // to the virtual method table.
      d_off = FP_OFF(this) + u.v.virt1 + u.v.f_offset;

      // Make a pointer to the correct entry vtable
      p = (unsigned far *)MK_FP(_SS, d_off);

      // Now we can get the offset in the Virtual Table which contains
      // the actual address of the function we need to get at.
      tbl_off = *p;
      u.v.virtual_level--;
      tbl_off += u.v.virtual_level;

      // Make the pointer to the table entry and extract the segment
      // and offset of the function which will be called.
      segoff = (unsigned far *)MK_FP(_DS, tbl_off);
      if (NEAR_CODE)
         printf("near virtual at CS:%X\n", *(segoff));
      else
         printf("virtual at %X:%X\n", *(segoff+1), *segoff);
   }
}

int main( void )
{
    test x;

    x.addr( &test::one );    // test a virtual function
    x.addr( &test::two );    // test a non virtual function
    x.addr( &test::three );  // test a virtual function whose address
                             // should be in the base class
    x.addr( &test::four );   // test a base class function (non virtual)

    return 0;
}
