/* -------------------------------------------------------------------- */
/* Mouse++ Version 3.0             cursor.h            Revised 05/01/91 */
/*                                                                      */
/* General mouse class for Turbo C++/Borland C++.                       */
/* Copyright 1991, 1992 by Carl W. Moreland                             */
/* This source code may be freely distributed as long as the copyright  */
/* notice remains intact.                                               */
/* -------------------------------------------------------------------- */

#ifndef M_CURSOR
#define M_CURSOR

static unsigned defaultimage[32] =
{
  0x3FFF,       /* 0011111111111111 */
  0x1FFF,       /* 0001111111111111 */
  0x0FFF,       /* 0000111111111111 */
  0x07FF,       /* 0000011111111111 */
  0x03FF,       /* 0000001111111111 */
  0x01FF,       /* 0000000111111111 */
  0x00FF,       /* 0000000011111111 */
  0x007F,       /* 0000000001111111 */
  0x003F,       /* 0000000000111111 */
  0x001F,       /* 0000000000011111 */
  0x01FF,       /* 0000000111111111 */
  0x10FF,       /* 0001000011111111 */
  0x30FF,       /* 0011000011111111 */
  0x787F,       /* 0111100001111111 */
  0xF87F,       /* 1111100001111111 */
  0xFC7F,       /* 1111110001111111 */

  0x0000,       /* 0000000000000000 */
  0x4000,       /* 0100000000000000 */
  0x6000,       /* 0110000000000000 */
  0x7000,       /* 0111000000000000 */
  0x7800,       /* 0111100000000000 */
  0x7C00,       /* 0111110000000000 */
  0x7E00,       /* 0111111000000000 */
  0x7F00,       /* 0111111100000000 */
  0x7F80,       /* 0111111110000000 */
  0x7C00,       /* 0111110000000000 */
  0x6C00,       /* 0110110000000000 */
  0x4600,       /* 0100011000000000 */
  0x0600,       /* 0000011000000000 */
  0x0300,       /* 0000001100000000 */
  0x0300,       /* 0000001100000000 */
  0x0000        /* 0000000000000000 */
};

static unsigned checkimage[32] =
{
  0xFFF0,       /* 1111111111110000 */
  0xFFE0,       /* 1111111111100000 */
  0xFFC0,       /* 1111111111000000 */
  0xFF81,       /* 1111111110000001 */
  0xFF03,       /* 1111111100000011 */
  0x0607,       /* 0000011000000111 */
  0x000F,       /* 0000000000001111 */
  0x001F,       /* 0000000000011111 */
  0xC03F,       /* 1100000000111111 */
  0xF07F,       /* 1111000001111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */

  0x0000,       /* 0000000000000000 */
  0x0006,       /* 0000000000000110 */
  0x000C,       /* 0000000000001100 */
  0x0018,       /* 0000000000011000 */
  0x0030,       /* 0000000000110000 */
  0x0060,       /* 0000000001100000 */
  0x70C0,       /* 0111000011000000 */
  0x1D80,       /* 0001110110000000 */
  0x0700,       /* 0000011100000000 */
  0x0000,       /* 0000000000000000 */
  0x0000,       /* 0000000000000000 */
  0x0000,       /* 0000000000000000 */
  0x0000,       /* 0000000000000000 */
  0x0000,       /* 0000000000000000 */
  0x0000,       /* 0000000000000000 */
  0x0000        /* 0000000000000000 */
};

static unsigned crossimage[32] =
{
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */

  0x8002,       /* 1000000000000010 */
  0x4004,       /* 0100000000000100 */
  0x2008,       /* 0010000000001000 */
  0x1010,       /* 0001000000010000 */
  0x0820,       /* 0000100000100000 */
  0x0440,       /* 0000010001000000 */
  0x0280,       /* 0000001010000000 */
  0x0000,       /* 0000000000000000 */
  0x0280,       /* 0000001010000000 */
  0x0440,       /* 0000010001000000 */
  0x0820,       /* 0000100000100000 */
  0x1010,       /* 0001000000010000 */
  0x2008,       /* 0010000000001000 */
  0x4004,       /* 0100000000000100 */
  0x8002,       /* 1000000000000010 */
  0x0000        /* 0000000000000000 */
};

static unsigned plusimage[32] =
{
  0xFC7F,       /* 1111110001111111 */
  0xFC7F,       /* 1111110001111111 */
  0xFC7F,       /* 1111110001111111 */
  0xFC7F,       /* 1111110001111111 */
  0xFC7F,       /* 1111110001111111 */
  0xFC7F,       /* 1111110001111111 */
  0x0001,       /* 0000000000000001 */
  0x0001,       /* 0000000000000001 */
  0x0001,       /* 0000000000000001 */
  0xFC7F,       /* 1111110001111111 */
  0xFC7F,       /* 1111110001111111 */
  0xFC7F,       /* 1111110001111111 */
  0xFC7F,       /* 1111110001111111 */
  0xFC7F,       /* 1111110001111111 */
  0xFC7F,       /* 1111110001111111 */
  0xFFFF,       /* 1111111111111111 */

  0x0000,       /* 0000000000000000 */
  0x0100,       /* 0000000100000000 */
  0x0100,       /* 0000000100000000 */
  0x0100,       /* 0000000100000000 */
  0x0100,       /* 0000000100000000 */
  0x0100,       /* 0000000100000000 */
  0x0100,       /* 0000000100000000 */
  0x7FFC,       /* 0111111111111100 */
  0x0100,       /* 0000000100000000 */
  0x0100,       /* 0000000100000000 */
  0x0100,       /* 0000000100000000 */
  0x0100,       /* 0000000100000000 */
  0x0100,       /* 0000000100000000 */
  0x0100,       /* 0000000100000000 */
  0x0000,       /* 0000000000000000 */
  0x0000        /* 0000000000000000 */
};

static unsigned hourglassimage[32] =
{
  0x8001,       /* 1000000000000001 */
  0x8001,       /* 1000000000000001 */
  0xC003,       /* 1100000000000011 */
  0xC003,       /* 1100000000000011 */
  0xE007,       /* 1110000000000111 */
  0xF00F,       /* 1111000000001111 */
  0xF81F,       /* 1111100000011111 */
  0xF81F,       /* 1111100000011111 */
  0xF81F,       /* 1111100000011111 */
  0xF81F,       /* 1111100000011111 */
  0xF00F,       /* 1111000000001111 */
  0xE007,       /* 1110000000000111 */
  0xC003,       /* 1100000000000011 */
  0xC003,       /* 1100000000000011 */
  0x8001,       /* 1000000000000001 */
  0x8001,       /* 1000000000000001 */

  0x0000,       /* 0000000000000000 */
  0x3FFC,       /* 0011111111111100 */
  0x1008,       /* 0001000000001000 */
  0x1C38,       /* 0001110000111000 */
  0x0FF0,       /* 0000111111110000 */
  0x07E0,       /* 0000011111100000 */
  0x0240,       /* 0000001001000000 */
  0x0240,       /* 0000001001000000 */
  0x0240,       /* 0000001001000000 */
  0x0240,       /* 0000001001000000 */
  0x0520,       /* 0000010100100000 */
  0x0890,       /* 0000100010010000 */
  0x1188,       /* 0001000110001000 */
  0x17E8,       /* 0001011111101000 */
  0x3FFC,       /* 0011111111111100 */
  0x0000        /* 0000000000000000 */
};

static unsigned handimage[32] =
{
  0xF3FF,       /* 1111001111111111 */
  0xE1FF,       /* 1110000111111111 */
  0xE1FF,       /* 1110000111111111 */
  0xE1FF,       /* 1110000111111111 */
  0xE1FF,       /* 1110000111111111 */
  0xE04F,       /* 1110000001001111 */
  0xE001,       /* 1110000000000001 */
  0XE000,       /* 1110000000000000 */
  0x8000,       /* 1000000000000000 */
  0x0000,       /* 0000000000000000 */
  0x0000,       /* 0000000000000000 */
  0x0000,       /* 0000000000000000 */
  0x0000,       /* 0000000000000000 */
  0x0000,       /* 0000000000000000 */
  0x0000,       /* 0000000000000000 */
  0x0000,       /* 0000000000000000 */

  0x0C00,       /* 0000110000000000 */
  0x1200,       /* 0001001000000000 */
  0x1200,       /* 0001001000000000 */
  0x1200,       /* 0001001000000000 */
  0x1200,       /* 0001001000000000 */
  0x13B0,       /* 0001001110110000 */
  0x124E,       /* 0001001001001110 */
  0X1249,       /* 0001001001001001 */
  0x7249,       /* 0111001001001001 */
  0x9001,       /* 1001000000000001 */
  0x9001,       /* 1001000000000001 */
  0X9001,       /* 1001000000000001 */
  0x8001,       /* 1000000000000001 */
  0x8001,       /* 1000000000000001 */
  0x8001,       /* 1000000000000001 */
  0xFFFF        /* 1111111111111111 */
};

static unsigned gunimage[32] =
{
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0x0001,       /* 0000000000000001 */
  0x0001,       /* 0000000000000001 */
  0x0001,       /* 0000000000000001 */
  0x0001,       /* 0000000000000001 */
  0xC001,       /* 1100000000000001 */
  0xF801,       /* 1111100000000001 */
  0xF801,       /* 1111100000000001 */
  0xF801,       /* 1111100000000000 */
  0xFF80,       /* 1111111110000000 */
  0xFFC0,       /* 1111111111000000 */
  0xFFC0,       /* 1111111111000000 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */

  0x0000,       /* 0000000000000000 */
  0x0000,       /* 0000000000000000 */
  0x0000,       /* 0000000000000000 */
  0x0000,       /* 0000000000000000 */
  0x7FFC,       /* 0111111111111100 */
  0x7FFC,       /* 0111111111111100 */
  0x1FFC,       /* 0001111111111100 */
  0x02B8,       /* 0000001010111000 */
  0x023C,       /* 0000001000111100 */
  0x03FC,       /* 0000001111111100 */
  0x003C,       /* 0000000000111100 */
  0x001E,       /* 0000000000011110 */
  0x001E,       /* 0000000000011110 */
  0x0000,       /* 0000000000000000 */
  0x0000,       /* 0000000000000000 */
  0x0000        /* 0000000000000000 */
};

static unsigned ibeamimage[32] =
{
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */

  0x3C78,       /* 0011110001111000 */
  0x0280,       /* 0000001010000000 */
  0x0100,       /* 0000000100000000 */
  0x0100,       /* 0000000100000000 */
  0x0100,       /* 0000000100000000 */
  0x0100,       /* 0000000100000000 */
  0x0100,       /* 0000000100000000 */
  0x0100,       /* 0000000100000000 */
  0x0100,       /* 0000000100000000 */
  0x0100,       /* 0000000100000000 */
  0x0100,       /* 0000000100000000 */
  0x0100,       /* 0000000100000000 */
  0x0100,       /* 0000000100000000 */
  0x0100,       /* 0000000100000000 */
  0x0280,       /* 0000001010000000 */
  0x3C78        /* 0011110001111000 */
};

static unsigned faceimage[32] =
{
  0xF00F,       /* 1111000000001111 */
  0xC003,       /* 1100000000000011 */
  0x8001,       /* 1000000000000001 */
  0x0000,       /* 0000000000000000 */
  0x1428,       /* 0001010000101000 */
  0x0420,       /* 0000010000100000 */
  0x1818,       /* 0001100000011000 */
  0x0000,       /* 0000000000000000 */
  0x0000,       /* 0000000000000000 */
  0x1008,       /* 0001000000001000 */
  0x0000,       /* 0000000000000000 */
  0x1248,       /* 0001001001001000 */
  0x0240,       /* 0000001001000000 */
  0x8181,       /* 1000000110000001 */
  0xC003,       /* 1100000000000011 */
  0xF00F,       /* 1111000000001111 */

  0x0000,       /* 0000000000000000 */
  0x1FF8,       /* 0001111111111000 */
  0x3FFC,       /* 0011111111111100 */
  0x7FFE,       /* 0111111111111110 */
  0x7FFE,       /* 0111111111111110 */
  0x73CE,       /* 0111001111001110 */
  0x73CE,       /* 0111001111001110 */
  0x7FFE,       /* 0111111111111110 */
  0x7FFE,       /* 0111111111111110 */
  0x6FF6,       /* 0110111111110110 */
  0x700E,       /* 0111000000001110 */
  0x7FFE,       /* 0111111111111110 */
  0x7FFE,       /* 0111111111111110 */
  0x3FFC,       /* 0011111111111100 */
  0x1FF8,       /* 0001111111111000 */
  0x0000        /* 0000000000000000 */
};

static unsigned jetimage[32] =
{
  0xFEFF,       /* 1111111011111111 */
  0xFC7F,       /* 1111110001111111 */
  0xFC7F,       /* 1111110001111111 */
  0xFC7F,       /* 1111110001111111 */
  0xF83F,       /* 1111100000111111 */
  0xF83F,       /* 1111100000111111 */
  0xF01F,       /* 1111000000011111 */
  0xE00F,       /* 1110000000001111 */
  0xC007,       /* 1100000000000111 */
  0x8003,       /* 1000000000000011 */
  0x0001,       /* 0000000000000001 */
  0x0001,       /* 0000000000000001 */
  0xF83F,       /* 1111100000111111 */
  0xF01F,       /* 1111000000011111 */
  0xE00F,       /* 1110000000001111 */
  0xE10F,       /* 1110000100001111 */

  0x0000,       /* 0000000000000000 */
  0x0100,       /* 0000000100000000 */
  0x0100,       /* 0000000100000000 */
  0x0100,       /* 0000000100000000 */
  0x0380,       /* 0000001110000000 */
  0x0380,       /* 0000001110000000 */
  0x07C0,       /* 0000011111000000 */
  0x0FE0,       /* 0000111111100000 */
  0x1FF0,       /* 0001111111110000 */
  0x3FF8,       /* 0011111111111000 */
  0x7FFC,       /* 0111111111111100 */
  0x0380,       /* 0000001110000000 */
  0x0380,       /* 0000001110000000 */
  0x07C0,       /* 0000011111000000 */
  0x0EE0,       /* 0000111011100000 */
  0x0000        /* 0000000000000000 */
};

static unsigned bullseyeimage[32] =
{
  0xFFFF,       /* 1111111111111111 */
  0xF00F,       /* 1111000000001111 */
  0xC003,       /* 1100000000000011 */
  0x8001,       /* 1000000000000001 */
  0x0000,       /* 0000000000000000 */
  0x0000,       /* 0000000000000000 */
  0x0000,       /* 0000000000000000 */
  0x0000,       /* 0000000000000000 */
  0x0000,       /* 0000000000000000 */
  0x0000,       /* 0000000000000000 */
  0x0000,       /* 0000000000000000 */
  0x0000,       /* 0000000000000000 */
  0x8001,       /* 1000000000000001 */
  0xC003,       /* 1100000000000011 */
  0xF00F,       /* 1111000000001111 */
  0xFFFF,       /* 1111111111111111 */

  0x0000,       /* 0000000000000000 */
  0x0000,       /* 0000000000000000 */
  0x0FF0,       /* 0000111111110000 */
  0x381C,       /* 0011100000011100 */
  0x6FF6,       /* 0110111111110110 */
  0x5C3A,       /* 0101110000111010 */
  0x57EA,       /* 0101011111101010 */
  0x566A,       /* 0101011001101010 */
  0x566A,       /* 0101011001101010 */
  0x57EA,       /* 0101011111101010 */
  0x5C3A,       /* 0101110000111010 */
  0x6FF6,       /* 0110111111110110 */
  0x381C,       /* 0011100000011100 */
  0x0FF0,       /* 0000111111110000 */
  0x0000,       /* 0000000000000000 */
  0x0000        /* 0000000000000000 */
};

static GraphicsCursor gdef      = { 1, 1, defaultimage };
static GraphicsCursor check     = { 6, 8, checkimage };
static GraphicsCursor plus      = { 7, 7, plusimage };
static GraphicsCursor cross     = { 7, 7, crossimage };
static GraphicsCursor gun       = { 4, 1, gunimage };
static GraphicsCursor hand      = { 7, 0, handimage };
static GraphicsCursor hourglass = { 7, 7, hourglassimage };
static GraphicsCursor ibeam     = { 7, 7, ibeamimage };
static GraphicsCursor face      = { 7, 7, faceimage };
static GraphicsCursor jet       = { 7, 0, jetimage };
static GraphicsCursor bullseye  = { 7, 7, bullseyeimage };

static TextCursor tdef  = { 0, 0x77FF, 0x7700 };
static TextCursor txt1  = { 0, 0x0000, 0x0E0F };
static TextCursor txt2  = { 0, 0x7000, 0x0E0F };
static TextCursor txt3  = { 0, 0x7F00, 0xFF0F };
static TextCursor txt4  = { 0, 0x00FF, 0x0FD4 };

#endif