/* -------------------------------------------------------------------- */
/* Mouse++ Version 3.0             mouse.h             Revised 02/21/92 */
/*                                                                      */
/* General mouse class for Turbo C++/Borland C++.                       */
/* Copyright 1991, 1992 by Carl W. Moreland                             */
/* This source code may be freely distributed as long as the copyright  */
/* notice remains intact.                                               */
/* -------------------------------------------------------------------- */

#ifndef MOUSEdotH
#define MOUSEdotH

#define MOUSE_BUFFER_SIZE 8

#define LEFTBUTTON	0       // mouse button assignments
#define RIGHTBUTTON	1
#define CENTERBUTTON	2

#define CURSORSOFT	0       // used in struct TextCursor
#define CURSORHARD	1

#define MOUSE_MOVED	0x01    // event masks for event handler
#define LB_PRESSED      0x02
#define LB_RELEASED     0x04
#define RB_PRESSED      0x08
#define RB_RELEASED     0x10
#define CB_PRESSED      0x20
#define CB_RELEASED     0x40

#define SHIFT_PRESSED   0x08	// key shift masks
#define RSHIFT_PRESSED  0x10
#define LSHIFT_PRESSED  0x20
#define CTRL_PRESSED    0x40
#define ALT_PRESSED     0x80

#define EventExit() __emit__(0x5D,0x5F,0x5E,0x1F,0x07,\
                             0x5A,0x59,0x5B,0x58,0xCB);

/* -------------------------------------------------------------------
The above emitted code is equivalent to the following assembler code:

       pop   bp
       pop   di
       pop   si
       pop   ds
       pop   es   ;interrupt exit processing
       pop   dx
       pop   cx
       pop   bx
       pop   ax
       retf       ;far return
   ------------------------------------------------------------------- */

void interrupt MouseHandler(void);

struct GraphicsCursor		// structure for graphics cursor (0x09)
{
  unsigned char hotx, hoty;     // hot spot; (0,0) = upper left corner
  unsigned *image;              // 16 x 16 pixel screen and cursor masks
};				// see cursor.h for predefined cursors

struct TextCursor               // structure for text cursor (0x0A)
{
  int type;			// hard or soft cursor
  unsigned arg1, arg2;		// screen and cursor masks
};

struct OldEventHandler		// structure to save old handler (0x14)
{
  unsigned mask;		// event mask
  unsigned segment, offset;	// address of event handler
};

struct MouseInfo		// structure to return data (0x24)
{
  unsigned char type;		// bus=1, serial=2, InPort=3, PS/2=4, HP=5
  unsigned char majorvers;	// software major version
  unsigned char minorvers;	// software minor version
  unsigned char irq;		// IRQ used (2-7), 0 for PS/2
};

struct MouseEvent		// event buffer structure
{
  unsigned char event;		// trigger event
  unsigned char button;		// button status
  unsigned int  x, y;		// cursor coordinates
  unsigned int  xcount, ycount;	// mickeys moved since last event
  long time;			// time event occurred
};

struct MouseClick		// MultiClick buffer structure
{
  unsigned char count;		// number of clicks
  long time;			// time of last click
};

class Mouse
{
  static unsigned char exists;	// 1 if mouse found, 0 if not
  static unsigned char enabled;	// 1 if mouse enabled, 0 if not
  static unsigned char visible;	// keeps track of Hide() & Show()
  static unsigned char buttons; // number of buttons
  static unsigned char button;	// button status
  static int x, y;		// x & y position of cursor
  static int xcount, ycount;	// mickeys moved since last event
  static unsigned char hotx, hoty;	// cursor hot spot coords
  static int oldeventmask;	// oldeventxxx holds info on the event
  static int oldeventseg;	//   handler that was active when Mouse
  static int oldeventoff;	//   was initiated.  Used in restore.

  MouseEvent Buffer[MOUSE_BUFFER_SIZE];	// event buffer
  static unsigned char HeadPtr;		// buffer pointer
  static unsigned char TailPtr;		// buffer pointer
  unsigned char eventMask;
  void interrupt (*eventHandler)(void);
  static unsigned char event;		// current event
  static unsigned char handlerInstalled;// event handler flag

  MouseClick Click[3];			// MultiClick buffer
  static unsigned clickThreshold;	// MultiClick threshold

public:
  Mouse(void);
 ~Mouse(void);
  MouseInfo Info;

  unsigned char Exists()  { return exists;  }
  unsigned char Visible() { return visible; }
  unsigned char Buttons() { return buttons; }
  unsigned char Button()  { return button;  }

  int  xPos()    	  { return x;      }
  int  yPos() 		  { return y;      }
  int  xCount()  	  { return xcount; }
  int  yCount()  	  { return ycount; }
  unsigned char LB_Dn()   { return (0x01 & button); }
  unsigned char RB_Dn()   { return (0x02 & button); }
  unsigned char CB_Dn()   { return (0x04 & button); }

  void Enable(void);
  void Disable(void);
  void Show(void);
  void Hide(void);
  void Move(int x, int y);
  void Position(void);
  void Motion(void);
  int  Pressed(int mbutton);
  int  Released(int mbutton);
  int  InBox(int left, int top, int right, int bottom);
  void Exclude(int left, int top, int right, int bottom);
  int  MultiClick(int mbutton);
  int  DoubleClick(int mbutton);
  void ClearClick(int mbutton);

  void xLimit(int min, int max);
  void yLimit(int min, int max);
  void SetGraphicsCursor(GraphicsCursor& cursor);
  void SetTextCursor(TextCursor& cursor);
  void MickToPix(int horiz, int vert);
  void SetSpeedThreshold(unsigned speed);
  void SetClickThreshold(unsigned time);

  void InstallHandler(unsigned mask,
                      void interrupt (*handler)(void) = MouseHandler);
  void ClearHandler(void);
  void Save(int event, int button, int x, int y, int xcount, int ycount);
  void GetEvent(void);
  void ClearEvent(void);
  void ClearBuffer(void);
};

extern Mouse mouse;

#endif