/* BASE_AFT.C - Microsoft C6.0a based heap example #2.
   This program shows you one way to deal with the Microsoft
   based heap constructs when converting to Borland C++ 3.0.
   Typically, you would use based variables with compact, large,
   or huge memory models, so this example substitutes equvalent
   Borland C++ far heap memory management functions.

   Copyright (c) 1991 Borland International. All rights reserved.

 */

#include <stdio.h>
#include <malloc.h>
#include <stdlib.h>
#include <string.h>

void main()
{
    /* Note 1 - based variables become _far variables */
    char _far *revstr, *fwdstr;
    /* Note 1 - ptrs to characters within the variables are also _far */
    char _far *ptrrev, *ptrfwd;
    /* Initialize a constant string */
    char conststring[80] = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    int  lstr;

    /* Note 2 - No need to do based heap allocation call.
       Allocate far memory for two strings of size (lstr+1) bytes.
     */
    lstr = strlen( conststring );
    if( ((fwdstr = farmalloc( lstr + 1 )) == NULL) ||
    ((revstr = farmalloc( lstr + 1 )) == NULL) )
    /* Can't do, error exit 2 */
    exit( 2 );

    /* Convert uppercase string to lowercase string after copying it to
       far memory. The far functions no longer need recasting of
       pointers.
     */
    _fstrlwr( _fstrcpy( fwdstr, conststring ) );

    /* Copy fwdstr string to revstr string in reversed order. */
    /* You could also use either the _fstrrev function here, or
       the ANS standard strrev function in a compact, large, or
       huge memory model.
    */
    for( ptrfwd = fwdstr + lstr - 1, ptrrev = revstr;
        ptrrev < revstr + lstr; ptrfwd--, ptrrev++ )
    *ptrrev = *ptrfwd;
    *ptrrev = '\0';

    /* Note 3 - Display the strings.
       Recasting of based pointers is no longer required.
    */
    printf( "Forward string:  %Fs\n", fwdstr );
    printf( "Reverse string:  %Fs\n", revstr );

    /* Note 4 - Free each memory block. */
    farfree( fwdstr );
    farfree( revstr );
    exit( 0 );
}
