/* BASE_BEF.C - Microsoft C6.0a based heap example #1.
   This program illustrates the interaction among the based
   memory management functions ( _bheapseg, _bmalloc, _bfree
   and _bfreeseg ), the C run-times, and standard C variables.
   Typically, you would use based variables with compact, large,
   or huge memory models.

   Copyright (c) 1991 Borland International. All rights reserved.

*/

#include <stdio.h>
#include <malloc.h>
#include <stdlib.h>
#include <string.h>

void main()
{
    /* Note 1 - Keep segment address for based variables in baseseg */
    _segment baseseg;
    /* Note 1 - based variables in baseseg */
    char _based( baseseg ) *revstr, _based( baseseg ) *fwdstr;
    /* Note 1 - pointers to characters within the based variables */
    char _based( baseseg ) *ptrrev, _based( baseseg ) *ptrfwd;
    /* Initialize a constant string */
    char conststring[80] = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    int  lstr;

    /* Note 2 - Allocate 100 bytes in a based heap.
       Put its pointer into baseseg.
     */
    if( (baseseg = _bheapseg( 100 )) == _NULLSEG )
    /* Can't do, error exit 1 */
    exit( 1 );

    /* Note 2 - Allocate based memory for two strings size (lstr+1). */
    lstr = strlen( conststring );
    if( ((fwdstr = _bmalloc( baseseg, lstr + 1 )) == _NULLOFF) ||
    ((revstr = _bmalloc( baseseg, lstr + 1 )) == _NULLOFF) )
    /* Can't do, error exit 2 */
    exit( 2 );

    /* Convert upper case string to lower case string after copying
       it to based memory.  Explicitly recast based pointers to
       far pointers for clarity.
     */
    _fstrlwr( _fstrcpy( (char _far *)fwdstr,
        (char _far *)conststring ) );

    /* Copy fwdstr string to revstr string in reversed order. */
    for( ptrfwd = fwdstr + lstr - 1, ptrrev = revstr;
        ptrrev < revstr + lstr; ptrfwd--, ptrrev++ )
    *ptrrev = *ptrfwd;
    *ptrrev = '\0';

    /* Note 3 - Display the strings.
       Here, you must explicitly recast based pointers to far pointers
       to eliminate compiler warnings.
    */
    printf( "Forward string:  %Fs\n", (char _far *)fwdstr );
    printf( "Reverse string:  %Fs\n", (char _far *)revstr );

    /* Note 4 - Free each memory block, then release based heap. */
    _bfree( baseseg, fwdstr );
    _bfree( baseseg, revstr );
    _bfreeseg( baseseg );
    exit( 0 );
}
