/****************************************************************************
*
*						M - A Dos More replacement
*
*                   Copyright (C) 1993 SciTech Software
*							All rights reserved.
*
* Filename:		$RCSfile: more.c $
* Version:		$Revision: 1.4 $
*
* Language:		ANSI C
* Environment:	IBM PC (MSDOS) Real mode and 16 bit Protected Mode
*
* Description:	A program to replace the MS DOS MORE.COM progam. It works
*				properly with 43/50 line displays, and can take the name
*				of a file to display as a parameter. It also expands
*				tabs to any specified size (default set below).
*
*				This program has been written to show how easy it is to
*				incorporate the console driver routines into your programs.
*
* $Id: more.c 1.4 1994/03/07 09:44:25 kjb release $
*
****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <string.h>
#include <ctype.h>
#include "getopt.h"
#include "console.h"
#include "pmode.h"

#define	DEF_TAB_SIZE	4			/* Default tab size					*/
#define	MAXLEN			255			/* Maximum length of a line			*/

/*------------------- Version number and test status ----------------------*/

#define VERSION			110			/* Version number * 100				*/

/*------------------------- Global variables ------------------------------*/

char		version[6];				/* Version string (eg: 5.20b)		*/
char        nameofus[_MAX_FNAME];   /* Name of program (no path)        */
char        pathtous[_MAX_DIR];     /* Pathname to our program.         */
char		*progname;				/* Descriptive name of program		*/

/*-------------------------- Implementation -------------------------------*/

#if defined(__MSC__) || defined(__SYMC__)

void delay(int milliseconds)
{
    int i,j,k;

    for (i = 0; i < milliseconds; i++)
        for (j = 0; j < 1000; j++)
            k += i * j;
}

#endif

void init(char *argv0,char *prognam)
/****************************************************************************
*
* Function:		init
* Parameters:	argv0	- The argv[0] array entry.
*				prognam	- Descriptive name of program.
*
* Description:	Init takes the pathname to our program as a parameter
*				(found in argv[0]) and use this to set up three global
*				variables:
*
*				pathtous	- Contains the pathname to our program
*				nameofus	- Contains the name of the program (without the
*							  .EXE extension)
*				version		- Contains the version number of the program,
*							  in the format 5.20b
*
*				Note that the version string is formatted to include an
*				optional teststatus identifier. This can be any character
*				such as 'a' for alpha test status, 'b' for beta test status
*				or any other meaningful character. If it is a space, it is
*				not included in the version string.
*
*				We also set up the global variable progname to point to
*				the static string passed to init for all to use.
*
****************************************************************************/
{
	char	*p,i;

	/* Obtain the path to our program from pathname */

	p = strrchr(argv0,'\\') + 1;
	i = *p;
	*p = '\0';
	strcpy(pathtous,argv0);
	*p = i;

	/* Obtain the name of our program from pathname */

	i = 0;
	while (*p != '.')
		nameofus[i++] = *p++;
	nameofus[i] = '\0';

	/* Set up version string */

#ifdef	TESTSTATUS
	sprintf(version,"%d.%02d%c",VERSION / 100,VERSION % 100,TESTSTATUS);
#else
	sprintf(version,"%d.%02d",VERSION / 100,VERSION % 100);
#endif

	progname = prognam;
}

void banner(void)
/****************************************************************************
*
* Function:     banner
*
* Description:  Prints the program's banner to the standard output
*
****************************************************************************/
{
    printf("%s  Version %s - %s  Copyright (C) 1993 SciTech Software\n\n"
		,progname,version,__DATE__);
}

void help(void)
/****************************************************************************
*
* Function:		help
*
* Description:	Help provides usage information about our program if the
*				options do make any sense.
*
****************************************************************************/
{
	banner();
	printf("Usage: %s [-htbd] [infile]\n\n",nameofus);
	printf("If the input file is specified, %s gets it's input from the 'infile',\n",progname);
	printf("otherwise it gets it from the standard input stream. It sends the file one\n");
	printf("line at a time to the video display, pausing between each page. Press\n");
	printf("escape to quit while viewing a file.\n\n");
	printf("Options are:\n\n");
	printf("  -h   - Display help screen (this screen)\n");
	printf("  -tx  - Expand tabs to x spaces (default = %d)\n",DEF_TAB_SIZE);
	printf("  -b   - Send all output via the video BIOS\n");
	printf("  -dx  - Delay for d milleseconds between each line\n");
	exit(1);
}

void printnotabs(char *buffer,int tab_size)
/****************************************************************************
*
* Function:		printnotabs
* Parameters:	buffer		- Pointer to buffer to print
*				tab_size	- Number of space for expanding tabs
*
* Description:	Prints the specified buffer, expanding all tabs to the
*				correct number of spaces.
*
****************************************************************************/
{
	char	out[MAXLEN];			/* Buffer to hold output line		*/
	int		linepos;				/* Current position in output line	*/
	int		spaces;					/* Spaces to print for tab			*/

	linepos = 0;
	for (; *buffer; buffer++)
		if (*buffer == '\t')
			for (spaces = (tab_size - (linepos % tab_size)); spaces; spaces--)
				out[linepos++] = ' ';
		else
			out[linepos++] = *buffer;
	out[linepos] = '\0';
	CON_puts(out);
	CON_puts("\r");
}

int openfile(FILE **in,char *filename,char *mode)
/****************************************************************************
*
* Function:		openfile
* Parameters:	in			- Pointer to FILE to use in open
*				filename	- Name of file to open
*				mode		- Mode to open file in
* Returns:		True if file was opened, false otherwise
*
* Description:	Attempts to open the named file. If the open fails, we
*				exit with a standard error message.
*
****************************************************************************/
{
	if( (*in = fopen(filename,mode) ) == NULL) {
		printf("cannot open source file: %s\n",filename);
		return false;	/* Open failed									*/
		}
	else
		return true;	/*	Open was successful							*/
}

void main(int argc,char **argv)
{
	int		option;				/* Option returned by getopt			*/
	char	*argument;			/* Argument returned by getopt			*/
	int		line;				/* Number of lines done so far			*/
	int		max;				/* Number of lines on screen			*/
	char	buffer[MAXLEN];		/* Buffer to read lines into			*/
	FILE	*infile;			/* Pointer to file to get lines from	*/
	int		tabsize;			/* Number of spaces per tab				*/
	int		delay_len;			/* Time to delay between each line		*/
	int		key;				/* The key pressed.						*/
    union REGS r;

	init(argv[0],"More");		/* Initialise a few globals				*/
	tabsize = DEF_TAB_SIZE;
	delay_len = 0;
	infile = stdin;

	/* Parse the command line for format specifier options */

	do {
		option = getopt(argc,argv,"hHbBt:T:d:D:",&argument);
		if (option >= 0)
			option = tolower(option);
		switch(option) {
			case 'h':
				help();
				break;
			case 'b':
                CON_directvideo = false;    /* Turn off direct video output */
				break;
			case 't':
				if((tabsize = atoi(argument)) <= 0) {
					fprintf(stderr,"Invalid tab size\a\n");
					exit(1);
					}
				break;
			case 'd':
				if ((delay_len = atoi(argument)) <= 0) {
					fprintf(stderr,"Invalid delay value\n");
					exit(1);
					}
				break;
			case PARAMETER:			/* We have a normal parameter */
				if (!openfile(&infile,argv[nextargv++],"rt"))
					exit(2);
				break;
			case INVALID:
				fputs("Invalid option\a\n",stderr);
				exit(1);
				break;
			}
		} while (option != ALLDONE);

	/* Initialise the console output routines */

	CON_init();

	/* Get the number of screen lines for our current screen from the
	 * BIOS data area. We will use this value as the maximum number of
	 * line that can be displayed at once.
	 */

    max = PMODE_getByte(PMODE_getBIOSPointer(),0x84);

	/* Loop around outputing lines to the screen until we are finished	*/

	line = 0;
	while (!feof(infile) && (fgets(buffer,255,infile) != NULL)) {
		line++;
		if (line == max && delay_len == 0) {
			line = 0;
			CON_puts("Press a key: ");

			/* Note: We cannot use getc here or the program will hang
			 * (DOS does not allow characters to be got from a pipe!).
			 */

#ifdef  __WATCOM32__
            r.x.eax = 0x0000;
            int386(0x16, &r, &r);
            key = r.h.al;
#else
            r.x.ax = 0x0000;
            int86(0x16, &r, &r);
            key = r.h.al;
#endif

			/* Erase the "Press a key: " line */

			CON_puts("\r             \r");

			/* Break out of the loop if the user pressed the escape
			 * key.
			 */

			if (key == 0x1B)
				break;
			}
		printnotabs(buffer,tabsize);
		if (delay_len)
			delay(delay_len);
		}
}
