/****************************************************************************
*
*                   Copyright (C) 1993 SciTech Software
*							All rights reserved.
*
* Filename:		$RCSfile: set43.c $
* Version:		$Revision: 1.3 $
*
* Language:		ANSI C
* Environment:	any
*
* Description:	Program to set the EGA/VGA into 43/50 line mode. This
*				version properly programs the cursor for the EGA with a
*				monochrome monitor or with a color monitor.
*
* $Id: set43.c 1.3 1993/12/30 14:11:00 kjb release $
*
****************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "sysinfo.h"

int main(int argc,char *argv[])
{
	subsys_type	subsys;

	if (argc != 2) {
		printf("Set43.exe - Program to set/reset EGA/VGA 43/50 line modes\n");
        printf("            Copyright (C) 1993 SciTech Software :- v2.1\n\n");
		printf("Usage: set43 [on|off|on43]\n");
		exit(0);
		}
	SYS_getSubSys(&subsys);
	if (subsys.adapter1 != EGA_adapter &&
			subsys.adapter1 != VGA_adapter &&
			subsys.adapter1 != SVGA_adapter &&
			subsys.adapter2 != EGA_adapter &&
			subsys.adapter2 != VGA_adapter &&
			subsys.adapter2 != SVGA_adapter) {
		printf("No EGA or VGA adapter is present\n");
		exit(-1);
		}

	/* Swap to the color EGA/VGA adapter in case the current monitor is
	 * monochrome.
	 */

	SYS_modeColor();

	if (!strcmpi(argv[1],"on")) {
		SYS_getSubSys(&subsys);
		if (subsys.adapter1 == EGA_adapter) {
			if (!SYS_set43lines())
				printf("Mode could not be properly set!\n");
			else
				printf("43 line mode set.\n");
			}
		else {
			if (!SYS_set50lines())
				printf("Mode could not be properly set!\n");
			else
				printf("50 line mode set.\n");
			}
		}
	else if (!strcmpi(argv[1],"on43"))
		if (!SYS_set43lines())
			printf("Mode could not be properly set!\n");
		else
			printf("43 line mode set.\n");
	else
		if (!SYS_set25lines())
			printf("Mode could not be properly set!\n");
		else
			printf("25 line mode set.\n");

	printf("\nScreen width: %d\n",SYS_screenWidth());
	printf("Screen Lines: %d\n",SYS_screenLines());
	return 0;
}
