/****************************************************************************
*
*                   Copyright (C) 1993 SciTech Software
*							All rights reserved.
*
* Filename:		$RCSfile: sysinfo.c $
* Version:		$Revision: 1.5 $
*
* Language:		ANSI C
* Environment:	any
*
* Description:	Program to display system information returned by the
*				sysinfo unit.
*
* $Id: sysinfo.c 1.5 1994/03/07 09:44:25 kjb release $
*
****************************************************************************/

#include <stdio.h>
#include "sysinfo.h"

void display_adapter(adapter_type adapter)
{
	switch (adapter) {
		case no_adapter:
			printf("Not present");
			break;
		case MDA_adapter:
			printf("Monochrome display - text only (MDA)");
			break;
		case HGC_adapter:
			printf("Hercules graphics card (HGC)");
		 break;
		case CGA_adapter:
			printf("Colour graphics adapter (CGA)");
			break;
		case EGA_adapter:
			printf("Enhanced colour graphics adapter (EGA)");
			break;
		case MCGA_adapter:
			printf("Multi colour graphics array (MCGA)");
			break;
		case VGA_adapter:
			printf("Video graphics array (VGA)");
			break;
		case SVGA_adapter:
			printf("Super VGA card (SVGA)");
			break;
		}
}

void display_display(display_type display)
{
	switch (display) {
		case no_display:
			printf("No display attached");
			break;
		case MDA_display:
			printf("Monochrome display (MDA)");
		 break;
		case CGA_display:
			printf("Colour graphics display (CGA)");
			break;
		case EGA_display:
			printf("Enhanced colour graphics display (ECD)");
			break;
		case PS2mono_display:
			printf("Monochrome VGA display");
			break;
		case PS2color_display:
			printf("Colour VGA display");
			break;
		}
}

void display_videoram(short videoram)
{
	printf("%d kilobytes",videoram);
}

#include <math.h>

int main(void)
{
	subsys_type	subsys;
	int			mode;

    printf("System information - Copyright (C) 1993 SciTech Software: \n\n");
	printf("   Processor: \t\t\t");
	switch (SYS_cpu()) {
		case cpu_86:
			printf("8086/88");
			break;
		case cpu_186:
			printf("80186");
			break;
		case cpu_286:
			printf("80286");
			break;
		case cpu_286p:
			printf("80286 in protected mode");
			break;
		case cpu_386:
			printf("i386");
			break;
		case cpu_386p:
			printf("i386 in protected mode");
			break;
		case cpu_486:
			printf("i486");
			break;
		case cpu_486p:
			printf("i486 in protected mode");
			break;
		case cpu_586:
			printf("Pentium(tm)");
			break;
		case cpu_586p:
			printf("Pentium(tm) in protected mode");
			break;
		}

	printf("\n   Coprocessor: \t\t");
	switch (SYS_fpu()) {
		case fpu_none:
			printf("none.");
			break;
		case fpu_87:
			printf("8087");
			break;
		case fpu_287:
			printf("80287");
			break;
		case fpu_387:
			printf("i387");
			break;
		case fpu_487:
			printf("i487 (on cpu)");
			break;
		case fpu_587:
			printf("Pentium (on cpu)");
			break;
		}

	printf("\n   BIOS class: \t\t\t");
	switch (SYS_biosClass() ) {
		case PC_class:
			printf("Standard PC");
			break;
		case PCXT_class:
			printf("Standard PC/XT");
			break;
		case PCAT_class:
			printf("Standard PC/AT");
			break;
		case PS2_class:
			printf("Standard PS/2");
			break;
		}

	SYS_getSubSys(&subsys);

	printf("\n\n   Video subsystem information: \n");

	printf("\n      Active video adapter: \t");
	display_adapter(subsys.adapter1);
	printf("\n      Active video display: \t");
	display_display(subsys.display1);
	if (subsys.adapter1 == EGA_adapter) {
		printf("\n      Active video ram: \t");
		display_videoram(subsys.videoram1);
		}

	printf("\n\n      Inactive video adapter: \t");
	display_adapter(subsys.adapter2);
	printf("\n      Inactive video display: \t");
	display_display(subsys.display2);
	if (subsys.adapter2 == EGA_adapter) {
		printf("\n      Inactive video ram: \t");
		display_videoram(subsys.videoram1);
		}

	printf("\n\n   Extended keyboard support:   ");
	if (SYS_extKeyboard())
		printf("Yes");
	else
		printf("No");

	mode = SYS_getVideoMode();
	printf("\n   Current video mode:          0x%x",mode & ~LINES_43);
	printf("\n   43 line mode set:            ");
	if (mode & LINES_43)
		printf("Yes");
	else
		printf("No");
	printf("\n   50 line mode set:            ");
	if (mode & LINES_50)
		printf("Yes");
	else
		printf("No");
	printf("\n   Screen lines:                %d",SYS_screenLines());
	printf("\n   Screen width:                %d",SYS_screenWidth());

	printf("\n\nThanks for using Sysinfo...\n");
	return 0;
}
