/****************************************************************************
*
*							  The MegaToolbox
*
*                   Copyright (C) 1993 SciTech Software
*							All rights reserved.
*
* Filename:		$RCSfile: console.h $
* Version:		$Revision: 1.3 $
*
* Language:		ANSI C
* Environment:	IBM PC Real mode and 16/32 bit Protected Mode
*
* Description:	Header file for console manipulation module.
*
* $Id: console.h 1.3 1994/03/06 07:46:12 kjb release $
*
****************************************************************************/

#ifndef	__CONSOLE_H
#define	__CONSOLE_H

#ifndef	__DEBUG_H
#include "debug.h"
#endif

/*--------------------- Macros and type definitions -----------------------*/

#ifndef __COLORS
#define	__COLORS

enum COLORS {
	BLACK,					/* dark colors	*/
	BLUE,
	GREEN,
	CYAN,
	RED,
	MAGENTA,
	BROWN,
	LIGHTGRAY,
	DARKGRAY,				/* light colors	*/
	LIGHTBLUE,
	LIGHTGREEN,
	LIGHTCYAN,
	LIGHTRED,
	LIGHTMAGENTA,
	YELLOW,
	WHITE
	};
#endif

#define	BLINK	128			/* Blink bit	*/

/* Predefined cursor types */

#define	CURSOR_NORMAL	1
#define	CURSOR_FULL		2

/* Scrolling directions */

#define	SCROLL_UP		1
#define	SCROLL_DOWN		2
#define	SCROLL_LEFT		3
#define	SCROLL_RIGHT	4

/* Macro to build attribute bytes */

#define	CON_makeAttr(f,b)	(char)( (((b) & 0x0F) << 4) | ((f) & 0x0F))

/*---------------------------- Global variables ---------------------------*/

extern	bool	CON_checksnow;
extern	bool	CON_checkCGAsnow;
extern	bool	CON_directvideo;
extern	int		CON_wrapmode;

/*------------------------- Function Prototypes ---------------------------*/

#ifdef	__cplusplus
extern "C" {			/* Use "C" linkage when in C++ mode	*/
#endif

void	PUBAPI CON_init(void);
void	PUBAPI CON_printf(char *format, ...);
void 	PUBAPI CON_puts(char *str);
void 	PUBAPI CON_putc(int c);
void 	PUBAPI CON_writec(int x,int y,int attr,int c);
void	PUBAPI CON_write(int x,int y,int attr,char *str);
void 	PUBAPI CON_clreol(void);
void 	PUBAPI CON_clrscr(void);
void 	PUBAPI CON_gotoxy(int x,int y);
int 	PUBAPI CON_wherex(void);
int	 	PUBAPI CON_wherey(void);
void 	PUBAPI CON_delline(void);
void 	PUBAPI CON_insline(void);
void 	PUBAPI CON_moveText(int left,int top,int right,int bottom,int destleft,
		int desttop);
void 	PUBAPI CON_saveText(int left,int top,int right,int bottom,void *destin);
void 	PUBAPI CON_restoreText(int left,int top,int right,int bottom,
		void *source);
void 	PUBAPI CON_scroll(int direction,int amt);
void 	PUBAPI CON_fillText(int left,int top,int right,int bottom,int attr,
		int ch);
void 	PUBAPI CON_fillAttr(int left,int top,int right,int bottom,int attr);
void 	PUBAPI CON_setWindow(int left,int top,int right,int bottom);
void 	PUBAPI CON_getWindow(int *left,int *top,int *right,int *bottom);
int		PUBAPI CON_maxx(void);
int		PUBAPI CON_maxy(void);
int		PUBAPI CON_getAttr(void);
void 	PUBAPI CON_setAttr(int attr);
void	PUBAPI CON_setBackground(int attr,int ch);
void	PUBAPI CON_getBackground(int *attr,int *ch);
void 	PUBAPI CON_setBackColor(int newcolor);
void 	PUBAPI CON_setForeColor(int newcolor);
void 	PUBAPI CON_setCursor(int type);
void 	PUBAPI CON_cursorOff(void);
void 	PUBAPI CON_restoreCursor(int scans);
int 	PUBAPI CON_getCursor(void);
void	PUBAPI CON_setActivePage(int page);
int		PUBAPI CON_getActivePage(void);
void	PUBAPI CON_setVisualPage(int page);
int		PUBAPI CON_getVisualPage(void);

#ifdef	__cplusplus
}						/* End of "C" linkage for C++	*/
#endif

#endif  /* __CONSOLE_H */
