// **********************************************
// File: OBJECTS.H
// Musical objects header file

#include "muzika.h"

// --- Object class codes
const O_NOTE = 5;
const O_PAUSE = 6;
const O_KEY = 7;
const O_BEAT = 8;
const O_BAR = 9;
const O_LOUDNESS = 10;
const O_CRESCENDO = 11;
const O_TEXT = 12;

// **********************************************
// Definitions of the various musical classes

class Note : virtual public PointObject {
  protected:
    int _Y;
    int _duration;

  public:
    Note(int X, int Y, int duration);
    Note(istream &);
    Note(void far *&);
    virtual void Draw(HDC);
    virtual void Format(int &);
    virtual void MIDIPlay(ostream &, int);
    virtual int Duration() {return _duration;}
    virtual void printOn(ostream &) const;
    virtual void clipOn(void far *&) const;
};

class Pause : virtual public PointObject {
  protected:
    int _duration;

  public:
    Pause(int X, int duration);
    Pause(istream &);
    Pause(void far *&);
    virtual void Draw(HDC);
    virtual void Format(int &);
    virtual void MIDIPlay(ostream &, int);
    virtual int Duration() {return _duration;}
    virtual void printOn(ostream &) const;
    virtual void clipOn(void far *&) const;
};

class Key : virtual public PointObject {
  protected:
    enum {LOCATION = 15};
    int _type;

  public:
    Key(int X, int type);
    Key(istream &);
    Key(void far *&);
    virtual void Draw(HDC);
    virtual void Format(int &);
    virtual int Width() {return WidthRound(2*pixelsPerObject+LOCATION);}
    virtual void printOn(ostream &) const;
    virtual void clipOn(void far *&) const;
};

class Beat : virtual public PointObject {
  protected:
    int _type;

  public:
    Beat(int X, int type);
    Beat(istream &);
    Beat(void far *&);
    virtual void Draw(HDC);
    virtual void Format(int &);
    virtual void printOn(ostream &) const;
    virtual void clipOn(void far *&) const;
};

class Bar : virtual public PointObject {
  protected:
    int _type;

  public:
    Bar(int X, int type);
    Bar(istream &);
    Bar(void far *&);
    virtual void Draw(HDC);
    virtual void Format(int &);
    virtual int Width()
      {return _type != STARTBAR && _type != ENDBAR ? pixelsPerObject : 0;}
    virtual void printOn(ostream &) const;
    virtual void clipOn(void far *&) const;
};

class Loudness : virtual public PointObject {
  protected:
    int _loudness;

  public:
    Loudness(int X, int loudness);
    Loudness(istream &);
    Loudness(void far *&);
    virtual void Draw(HDC);
    virtual void Format(int &);
    virtual void printOn(ostream &) const;
    virtual void clipOn(void far *&) const;
};

class Crescendo : virtual public ContinuousObject {
  protected:
    int _direction;

  public:
    Crescendo(int Xleft, int Xright, int direction);
    Crescendo(istream &);
    Crescendo(void far *&);
    virtual void Draw(HDC);
    virtual void printOn(ostream &) const;
    virtual void clipOn(void far *&) const;
};

class Text : virtual public PointObject {
  protected:
    int _Y;
    char _text[MAXTEXT];

  public:
    Text(int X, int Y, char *);
    Text(istream &);
    Text(void far *&);
    virtual void Draw(HDC);
    virtual void Format(int &);
    virtual void printOn(ostream &) const;
    virtual void clipOn(void far *&) const;
};
