/****************************************************************************
*
*					 MegaVision Application Framework
*
*			A C++ GUI Toolkit for the MegaGraph Graphics Library
*
*                   Copyright (C) 1994 SciTech Software.
*							All rights reserved.
*
* Filename:		$RCSfile: tdesktop.hpp $
* Version:		$Revision: 1.2 $
*
* Language:		C++ 3.0
* Environment:	IBM PC (MS DOS)
*
* Description:	Header file for the TDeskTop class. This class is a
*				special TGroup that maintains all of the views used by
*				the program, along with a simple background view if
*				specified.
*
* $Id: tdesktop.hpp 1.2 1994/03/09 11:50:10 kjb Exp $
*
****************************************************************************/

#ifndef	__TDESKTOP_HPP
#define	__TDESKTOP_HPP

#ifndef	__TGROUP_HPP
#include "tgroup.hpp"
#endif

#ifndef	__TBACKGND_HPP
#include "tbackgnd.hpp"
#endif

/*-------------------------- Class definitions ----------------------------*/

//---------------------------------------------------------------------------
// The TDeskTop class is a special TGroup to group together all views used
// by the main program.
//---------------------------------------------------------------------------

class TDeskTop : public TGroup {
protected:
	TBackGround	*backGround;

			// Method to draw the background
	virtual	void drawBackground(const TRect& clip);

public:
			// Constructor
			TDeskTop(const TRect& bounds,TBackGround *backGround = NULL);

			// Virtual to handle an event
	virtual	void handleEvent(TEvent& event,phaseType phase = phFocused);
	};

#endif	// __DESKTOP_HPP
