/****************************************************************************
*
*					 MegaVision Application Framework
*
*			A C++ GUI Toolkit for the MegaGraph Graphics Library
*
*					Copyright (C) 1994 SciTech Software.
*							All rights reserved.
*
* Filename:		$RCSfile: tdialog.cpp $
* Version:		$Revision: 1.2 $
*
* Language:		C++ 3.0
* Environment:	IBM PC (MS DOS)
*
* Description:	Member functions for the TDialog class.
*
* $Id: tdialog.cpp 1.2 1994/03/09 11:50:31 kjb Exp $
*
****************************************************************************/

#include "mvision.hpp"

#pragma	hdrstop

#include "tdialog.hpp"
#include "tkeys.hpp"

/*----------------------------- Implementation ----------------------------*/

TDialog::TDialog(const TRect& bounds,const char *title,ushort flags)
	: TWindow(bounds,title,flags),
	  TWindowInit(TWindow::initFrame,TWindow::initTitleBar)
/****************************************************************************
*
* Function:		TDialog::TDialog
* Parameters:	bounds	- Bounding box for the dialog
*				title	- Title text for the dialog (NULL for no title bar)
*				tjust	- Text justification for title bar
*				flags	- Window creation flags
*
* Description:	Constructor for the TDialog class.
*
****************************************************************************/
{
}

void TDialog::handleEvent(TEvent& event,phaseType phase)
/****************************************************************************
*
* Function:		TDialog::handleEvent
* Parameters:	event	- Event to handle
*				phase	- Current phase for the event (pre,focus,post)
*
* Description:	Event handling routine for the TDialog class. Here we
*				handle events normally for the group, and also check to
*				see if the dialog box should be ended.
*
***************************************************************************/
{
	TWindow::handleEvent(event,phase);

	switch (event.what) {
		case evKeyDown:
			switch (event.key.keyCode) {
				case kbEsc:
					// The escape key was pressed, so post a cancel message
					// to kill the dialog box.

					event.what = evCommand;
					event.message.command = cmCancel;
					event.message.infoPtr = NULL;
					putEvent(event);
					clearEvent(event);
					break;
				case kbEnter:
				case kbGrayEnter:
					// The enter key was pressed, so post a cmDefault
					// message to be processed by the default view (must
					// be a broadcast as we do not know who is the
					// default view.

					event.what = evBroadcast;
					event.message.command = cmDefault;
					event.message.infoPtr = NULL;
					putEvent(event);
					clearEvent(event);
					break;
				}
			break;
		case evCommand:
			switch (event.message.command) {
				case cmYes:
				case cmNo:
				case cmOk:
				case cmCancel:
					// One of the standard dialog commands was posted,
					// so attempt to end the modal view with the command.

					if (state & sfModal) {
						endModal(event.message.command);
						clearEvent(event);
						}
					break;
				}
			break;
		}
}

bool TDialog::valid(ushort command)
/****************************************************************************
*
* Function:		TDialog::valid
* Parameters:	command	- Command ending the modal operation
* Returns:		True if the dialog is valid
*
* Description:	Checks to see if the dialog is valid, or the modal view
*				should end.
*
****************************************************************************/
{
	if (command == cmCancel)
		return true;					// Cancel always works
	else
		return TGroup::valid(command);
}

TPalette& TDialog::getPalette() const
/****************************************************************************
*
* Function:		TDialog::getPalette
* Returns:		Pointer to the standard palette for dialogs.
*
****************************************************************************/
{
	static char cpDialog[] = {26,27,28,29,30,31,32,33,34,35,36,37,
							  38,39,40,41,42,43,44,45,46,47,48,49,50,
							  51,52,53,54,55,56,57,58,60};
	static TPalette palette(cpDialog,sizeof(cpDialog));
	return palette;
}
