/****************************************************************************
*
*					 MegaVision Application Framework
*
*			A C++ GUI Toolkit for the MegaGraph Graphics Library
*
*                   Copyright (C) 1994 SciTech Software.
*							All rights reserved.
*
* Filename:		$RCSfile: tmltext.hpp $
* Version:		$Revision: 1.2 $
*
* Language:		C++ 3.0
* Environment:	IBM PC (MS DOS)
*
* Description:	Header file for the TMultiLineText class. This class is used
*				to represent static text items in a view that may contain
*				multiple lines of text, separated by '\n' characters. The
*				text will automatically wrap at the bounds of the view.
*
* $Id: tmltext.hpp 1.2 1994/03/09 11:50:21 kjb Exp $
*
****************************************************************************/

#ifndef	__TMLTEXT_HPP
#define	__TMLTEXT_HPP

#ifndef	__TSTTEXT_HPP
#include "tsttext.hpp"
#endif

/*-------------------------- Class definitions ----------------------------*/

//---------------------------------------------------------------------------
// The TMultiLineText class is used to represent static text items in a
// view that contain multiple lines of text.
//---------------------------------------------------------------------------

class TMultiLineText : public TStaticText {
protected:
	bool	wrap;				// True if text should wrap at right edge

public:
			// Constructor
			TMultiLineText(const TRect& bounds,const char *text,
				const TextSettings& tset,bool wrap = true);

			// Method to draw the static text item
	virtual	void draw();

			// Method to set the text for the text item - returns old value
	virtual	const char *setText(const char *t);
	};

#endif	// __TMLTEXT_HPP
