/****************************************************************************
*
*					 MegaVision Application Framework
*
*			A C++ GUI Toolkit for the MegaGraph Graphics Library
*
*					Copyright (C) 1994 SciTech Software.
*							All rights reserved.
*
* Filename:		$RCSfile: tpalette.cpp $
* Version:		$Revision: 1.2 $
*
* Language:		C++ 3.0
* Environment:	IBM PC (MS DOS)
*
* Description:	Member functions for the TPalette class.
*
* $Id: tpalette.cpp 1.2 1994/03/09 11:50:43 kjb Exp $
*
****************************************************************************/

#include "mvision.hpp"

#pragma	hdrstop

#include "tpalette.hpp"
#include <string.h>

/*----------------------------- Implementation ----------------------------*/

TPalette::TPalette(const char *d,int len)
	: data(new char[len+1])
/****************************************************************************
*
* Function:		TPalette::TPalette
* Parameters:	d	- Pointer to palette data string
*				len	- Length of the palette data string
*
* Description:	Constructor for a new palette. The palette entries are
*				stored in Pascal string style format, with the length
*				byte stored in the first entry.
*
****************************************************************************/
{
	data[0] = len;
	memcpy(data+1,d,len);
}

TPalette::TPalette(const TPalette& pal)
	: data(new char[pal.data[0]])
/****************************************************************************
*
* Function:		TPalette::TPalette
* Parameters:	pal	- Palette to copy
*
* Description:	Constructor for a new palette. The palette entries are
*				stored in Pascal string style format, with the length
*				byte stored in the first entry.
*
****************************************************************************/
{
	memcpy(data,pal.data,pal.data[0]+1);
}

const TPalette& TPalette::operator = (const TPalette& pal)
/****************************************************************************
*
* Function:		TPalette::operator =
* Parameters:	pal	- Palette to copy
* Returns:		Reference to the copied palette
*
* Description:	Assignment operator for the Palette.
*
****************************************************************************/
{
	// Ensure that we are not copying onto ourselves

	if (data != pal.data) {
		if (data[0] != pal.data[0]) {
			delete data;
			data = new char[pal.data[0]];
			}
		memcpy(data,pal.data,pal.data[0]+1);
		}
	return *this;
}
