/****************************************************************************
*
*					 MegaVision Application Framework
*
*			A C++ GUI Toolkit for the MegaGraph Graphics Library
*
*                   Copyright (C) 1994 SciTech Software.
*							All rights reserved.
*
* Filename:		$RCSfile: trendera.hpp $
* Version:		$Revision: 1.2 $
*
* Language:		C++ 3.0
* Environment:	IBM PC (MS DOS)
*
* Description:	Header file for the TRenderArea class. This class is used
*				to represent a special type of view that is used for
*				performing double buffered animation in a window. It is
*				an abstract base class that relies upon a user suppiled
*				render() method to render the actual image in the viewing
*				area. It automatically takes care of setting up and
*				maintaining the double buffered view (if double buffering
*				is available).
*
* $Id: trendera.hpp 1.2 1994/03/09 11:50:21 kjb Exp $
*
****************************************************************************/

#ifndef	__TRENDERA_HPP
#define	__TRENDERA_HPP

#ifndef	__TVIEW_HPP
#include "tview.hpp"
#endif

/*------------------------------ Constants --------------------------------*/

/*-------------------------- Class definitions ----------------------------*/

//---------------------------------------------------------------------------
// The TRenderArea class is an abstract base class used to represent
// an area for peforming double buffered animation.
//---------------------------------------------------------------------------

class TRenderArea : public TView {
protected:
	bool	doubleBuffered;			// True if double buffering is on

			// Method to swap the display buffers
			void swapBuffers()
			{
				if (doubleBuffered)
					MGL_swapBuffers();
			};

			// Method to render the display and swap buffers
			void renderAndSwap()	{ render(); swapBuffers(); };

			// Method to turn double buffering on
			void doubleBufferOn();

			// Method to turn double buffering off
			void doubleBufferOff();

public:
			// Constructor
			TRenderArea(const TRect& bounds);

			// Method to draw the view
	virtual	void draw(const TRect& clip);

			// Method to render a user defined frame
	virtual	void render() = 0;
	};

#endif	// __TRENDERA_HPP
