/****************************************************************************
*
*					 MegaVision Application Framework
*
*			A C++ GUI Toolkit for the MegaGraph Graphics Library
*
*					Copyright (C) 1994 SciTech Software.
*							All rights reserved.
*
* Filename:		$RCSfile: tsttext.cpp $
* Version:		$Revision: 1.2 $
*
* Language:		C++ 3.0
* Environment:	IBM PC (MS DOS)
*
* Description:	Member functions for the TStaticText class.
*
* $Id: tsttext.cpp 1.2 1994/03/09 11:50:49 kjb Exp $
*
****************************************************************************/

#include "mvision.hpp"

#pragma	hdrstop

#include "tsttext.hpp"
#include "tfontmgr.hpp"

/*----------------------------- Implementation ----------------------------*/

TStaticText::TStaticText(const TRect& bounds,const char *text,ushort flags)
	: TView(bounds), text(text), flags(flags)
/****************************************************************************
*
* Function:		TStaticText::TStaticText
* Parameters:	bounds	- Bounding box for the text
*				text	- Pointer to the text to display
*				flags	- Static text creation flags
*
* Description:	Constructor for the TStaticText class. Note that the
*				text is _not_ copied onto the heap, but is simply
*				used as a reference. This is more efficient, but also
*				allows the text to be quickly set to another value by
*				pointing it somewhere else.
*
****************************************************************************/
{
	setText(text);
}

void TStaticText::setBounds(const TRect& b)
/****************************************************************************
*
* Function:		TStaticText::setBounds
* Parameters:	bounds	- New bounding box for the item.
*
* Description:	Sets the bounds for the text item. Here we precalculate the
*				position to display the text in the box.
*
****************************************************************************/
{
	TView::setBounds(b);
	setText(text);
}

const char *TStaticText::setText(const char *t)
/****************************************************************************
*
* Function:		TStaticText::setText
* Parameters:	t	- New string for the text
* Returns:		Pointer to old text.
*
* Description:	Sets the text for the static text item, and also
*				re-computes the position to draw the text at.
*
****************************************************************************/
{
	const char *ret = text;
	text = t;

	// Set the current font and size, and obtain the fonts metrics

	metrics	m;
	fontManager.useFont(fmSystemFont);
	MGL_getFontMetrics(&m);

	// Compute the location to draw the text at

	int hjust = (flags & sfLeftJust ? LEFT_TEXT :
				(flags & sfRightJust ? RIGHT_TEXT : CENTER_TEXT));
	int vjust = (flags & sfTopJust ? TOP_TEXT :
				(flags & sfBottomJust ? BOTTOM_TEXT : CENTER_TEXT));
	tjust.setJustification(hjust,vjust);

	TRect r(bounds);
	r.moveTo(0,0);

	int adjust = (fontManager.getCurrentFont() == fmFont8x8);
	start.x = 	(hjust == LEFT_TEXT ? 	 r.left() :
				(hjust == CENTER_TEXT ? (r.left() + r.right())/2 :
										 r.right()-1));
	start.y =	(vjust == TOP_TEXT ? 	 r.top() :
				(vjust == CENTER_TEXT ? (r.top() + r.bottom()-adjust)/2 :
										 r.bottom()-1 + m.descent));
	repaint();
	return ret;
}

void TStaticText::draw(const TRect& clip)
/****************************************************************************
*
* Function:		TStaticText::draw
* Parameters:	clip	- Clipping rectangle for the view.
*
* Description:	Draw's the static text item.
*
****************************************************************************/
{
	MGL_setClipRect(clip);				// Clip text to clip rect

	TextJust old;
	tjust.use();
	fontManager.useFont(fmSystemFont);
	MGL_setColor(getColor(23));
	MGL_drawStrXY(start.x + bounds.left(),
				  start.y + bounds.top(),text);

	old.use();
}
