/****************************************************************************
*
*					 MegaVision Application Framework
*
*			A C++ GUI Toolkit for the MegaGraph Graphics Library
*
*					Copyright (C) 1994 SciTech Software.
*							All rights reserved.
*
* Filename:		$RCSfile: ttitleb.cpp $
* Version:		$Revision: 1.2 $
*
* Language:		C++ 3.0
* Environment:	IBM PC (MS DOS)
*
* Description:	Member functions for the TTitleBar class.
*
* $Id: ttitleb.cpp 1.2 1994/03/09 11:50:49 kjb Exp $
*
****************************************************************************/

#include "mvision.hpp"

#pragma	hdrstop

#include "twindow.hpp"
#include "tfontmgr.hpp"

/*----------------------------- Implementation ----------------------------*/

TTitleBar::TTitleBar(const TRect& bounds,const char *title,
	ushort flags)
	: TView(bounds), title(newStr(title))
/****************************************************************************
*
* Function:		TTitleBar::TTitleBar
* Parameters:	bounds	- Bounding rectangle for the title bar
*				title	- Title text for the title bar
*				flags	- Window creation flags
*
* Description:	Constructor for the title bar.
*
****************************************************************************/
{
	int hjust = (flags & wfLeftJust ? LEFT_TEXT :
				(flags & wfRightJust ? RIGHT_TEXT : CENTER_TEXT));
	int vjust = (flags & wfTopJust ? TOP_TEXT :
				(flags & wfBottomJust ? BOTTOM_TEXT : CENTER_TEXT));
	tjust.setJustification(hjust,vjust);

	setBounds(bounds);
}

void TTitleBar::handleEvent(TEvent& event,phaseType phase)
/****************************************************************************
*
* Function:		TTitleBar::handleEvent
* Parameters:	event	- Event to handle
*				phase	- Current phase for the event (pre,focus,post)
*
* Description:	Event handling routine for the TTitleBar class. Determine's
*				if the title bar has been hit, and handles the interaction
*				of the title bar icons.
*
****************************************************************************/
{
	TView::handleEvent(event,phase);
}

void TTitleBar::setBounds(const TRect& bounds)
/****************************************************************************
*
* Function:		TTitlebar::setBounds
* Parameters:	bounds	- New bounding rectangle for the view
*
* Description:	Sets the bounding rectangle for the title bar. The bounding
*				rectangle will be set to the entire inner bounds for the
*				window, and we must adjust the size of it to the size of
*				the current title bar.
*
****************************************************************************/
{
	// Compute the height and width of the title bar text, and adjust the
	// bounding box for the title based on it's size.

	metrics	m;
	TRect 	r(bounds);

	fontManager.useFont(fmSystemFont);
	MGL_getFontMetrics(&m);
	r.bottom() = r.top() + (m.ascent-m.descent+1) + 8;
	TView::setBounds(r);

	// Compute the location to draw the text at

	r.inset(2,2);
	start.x = (tjust.hjust() == LEFT_TEXT ? 	r.left()+3 :
			  (tjust.hjust() == CENTER_TEXT ?  (r.left() + r.right())/2 :
												r.right()-4));
	start.y = (tjust.vjust() == TOP_TEXT ? 		r.top() :
			  (tjust.vjust() == CENTER_TEXT ?  (r.top() + r.bottom())/2 :
												r.bottom()-1 + m.descent));

	// Create the minimise/maximise boxes if needed
}

void TTitleBar::draw(const TRect& clip)
/****************************************************************************
*
* Function:		TTitleBar::draw
* Parameters:	clip	- Clipping rectangle for the view
*
* Description:	Draws the representation of the title bar.
*
****************************************************************************/
{
	bool active = state & sfActive;

	MGL_setClipRect(clip);

	if (active) {
		MGL_setColor(getColor(7));
		MGL_fillRect(bounds);
		MGL_setColor(getColor(2));
		drawLineCoord(bounds.left(),bounds.bottom()-_MVIS_sysLineWidth,
			bounds.right()-_MVIS_sysLineWidth,
			bounds.bottom()-_MVIS_sysLineWidth);
		}
	else {
		MGL_setColor(getColor(8));
		MGL_fillRect(bounds);
		MGL_setBorderColors(getColor(1),getColor(2));
		drawBorder(bounds,BDR_OUTSET,1);
		}

	// Draw the title bar text

	TextJust old;
	tjust.use();

	MGL_setColor(getColor(active ? 9 : 10));
	fontManager.useFont(fmSystemFont);
	MGL_drawStrXY(start.x,start.y,title);

	old.use();
}
