/****************************************************************************
*
*					 MegaVision Application Framework
*
*			A C++ GUI Toolkit for the MegaGraph Graphics Library
*
*					Copyright (C) 1994 SciTech Software.
*							All rights reserved.
*
* Filename:		$RCSfile: twindow.cpp $
* Version:		$Revision: 1.2 $
*
* Language:		C++ 3.0
* Environment:	IBM PC (MS DOS)
*
* Description:	Member functions for the TWindow class.
*
* $Id: twindow.cpp 1.2 1994/03/09 11:50:49 kjb Exp $
*
****************************************************************************/

#include "mvision.hpp"

#pragma	hdrstop

#include "twindow.hpp"
#include "tkeys.hpp"

/*----------------------------- Implementation ----------------------------*/

TWindow::TWindow(const TRect& bounds,const char *title,ushort flags)
	: TGroup(bounds), number(-1), flags(flags),
	  TWindowInit(TWindow::initFrame,TWindow::initTitleBar)
/****************************************************************************
*
* Function:		TWindow::TWindow
* Parameters:	bounds	- Bounding box for the window
*				title	- Title for the window's title bar
*				flags	- Creation flags for the window
*
* Description:	Constructor for the TWindow class.
*
****************************************************************************/
{
	options |= ofSelectable | ofFirstClick;

	// Create the frame if required and adjust the size of the group's
	// bounding rectangle to fit inside the frame.

	TRect extent;	getExtent(extent);

	if ((flags & (wfFramed | wfSolidFramed)) && createFrame) {
		insert(frame = createFrame(extent,flags));
		inner = frame->inner();
		}
	else
		frame = NULL;

	if (title && createTitleBar) {
		insert(titleBar = createTitleBar(inner,title,flags));
		inner.top() = titleBar->getBounds().botRight.y;
		}
	else
		titleBar = NULL;

	// Make the inner bounds relative to owner viewport

	inner.offset(bounds.topLeft);
}

void TWindow::handleEvent(TEvent& event,phaseType phase)
/****************************************************************************
*
* Function:		TWindow::handleEvent
* Parameters:	event	- Event to handle
*				phase	- Current phase for the event (pre,focus,post)
*
* Description:	Event handling routine for the TWindow class.
*
****************************************************************************/
{
	TGroup::handleEvent(event,phase);

	switch (event.what) {
		case evCommand:
			// Handle resize, zoom, close events for windows here

			break;
		case evBroadcast:
			// Handle the select window command here

			break;
		case evKeyDown:
			if (event.key.keyCode == kbTab) {
				if (event.key.modifiers & mdShift)
					selectPrev();
				else
					selectNext();
				}
			break;
		}
}

void TWindow::setBounds(const TRect& bounds)
/****************************************************************************
*
* Function:		TWindow::setBounds
* Parameters:	bounds	- New bounding rectangle for the view
*
* Description:	Sets the bounding rectangle for the window. We need to
*				adjust the size of the frame and menu bars to match the
*				new bounding information.
*
****************************************************************************/
{
	TGroup::setBounds(bounds);

	TRect extent;	getExtent(extent);
	inner = bounds;

	if (frame)	{
		frame->setBounds(extent);
		inner = frame->inner();
		}
	if (titleBar) {
		titleBar->setBounds(inner);
		inner.top() = titleBar->getBounds().botRight.y;
		}

	// Make the inner bounds relative to owner viewport

	inner.offset(bounds.topLeft);
}

void TWindow::moveTo(int x,int y)
/****************************************************************************
*
* Function:		TWindow::moveTo
* Parameters:	x,y	- New position to move view to
*
****************************************************************************/
{
	TPoint oldTopLeft(bounds.topLeft);
	TGroup::moveTo(x,y);
	inner.offset(bounds.topLeft.x - oldTopLeft.x,
				 bounds.topLeft.y - oldTopLeft.y);
}

void TWindow::drawBackground(const TRect& clip)
/****************************************************************************
*
* Function:		TWindow::drawBackground
* Parameters:	clip	- Clipping rectangle to use when drawing
*
* Description:	Draws a solid background for the window in the background
*				color.
*
****************************************************************************/
{
	MGL_setClipRect(clip);
	MGL_setColor(getColor(6));
	MGL_fillRectCoord(0,0,size.x,size.y);
}

TPalette& TWindow::getPalette() const
/****************************************************************************
*
* Function:		TWindow::getPalette
* Returns:		Pointer to the standard palette for windows.
*
****************************************************************************/
{
	static char cpWindow[] = {10,11,12,13,14,15,16,17,18,19,20,21,22,23,
							  24,25};
	static TPalette palette(cpWindow,sizeof(cpWindow));
	return palette;
}

TFrame* TWindow::initFrame(const TRect& bounds,ushort flags)
/****************************************************************************
*
* Function:		TWindow::initFrame
* Parameters:	bounds	- Bounding box for the frame
* Returns:		Pointer to the allocated frame.
*
****************************************************************************/
{
	return new TFrame(bounds,flags & wfSolidFramed);
}

TTitleBar* TWindow::initTitleBar(const TRect& bounds,const char *title,
	ushort flags)
/****************************************************************************
*
* Function:		TWindow::initTitleBar
* Parameters:	bounds	- Bounding box for the title bar
*				title	- Title text for the title bar
*				flags	- Window flags
* Returns:		Pointer to the allocated title bar.
*
****************************************************************************/
{
	return new TTitleBar(bounds,title,flags);
}
