/*------------------------------------------------------------------------*/
/*                                                                        */
/*  MYOBJECT.CPP                                                          */
/*  Demonstrates a minimal class derivation from Object and               */
/*  then tests the new class by using it as an Object ( adds              */
/*  the MyObject class to an Array ).                                     */
/*                                                                        */
/*------------------------------------------------------------------------*/

#include <stdlib.h>
#include <string.h>
#include <clstypes.h>
#include <checks.h>
#include <iostream.h>
#include <iomanip.h>
#include <array.h>
#include <queue.h>
#include "myobject.h"

MyObject::MyObject( const char *nameinit, long telinit=411 )
{
    if ( nameinit == 0 )
	   nameinit = "";

    len = strlen( nameinit ) + 1;
    name = new char[ len ];
    CHECK( name != 0 );
    strcpy( name, nameinit );
    tel = telinit;
}

MyObject::MyObject( const MyObject& other )
{
    len = other.len;
    name = new char[ len ];
    CHECK( name != 0 );
    strcpy( name, other.name );
    tel = other.tel;
}

MyObject::isEqual( const Object& testMyObject ) const
{
    return tel == ((MyObject&)testMyObject).tel ;
}


hashValueType MyObject::hashValue() const
{
    hashValueType  value = hashValueType(0);
    // the following conversion may lose significant digits
    // but we are just hoping to return a somewhat unique number
    value = (int)tel;
    return value;
}

void MyObject::printOn( ostream& outputStream ) const
{
    // the phone number is stored as a long but printed as a string
    char buff[25];
    char prefix[25];
    char num[25];
    ltoa( tel, buff, 10 );
    strcpy(prefix, buff );
    strcpy(num, buff+3 );
    prefix[3]=0;
    outputStream <<"Name: "<< name<<setw(20-len)<<"  Number: " << prefix;
    if( strlen(num) )
    outputStream << "-" << num;
}

MyObject& MyObject::operator=( const MyObject& other )
{
    if ( *this != other )
	   {
	   if ( len != other.len )
		  {
		  delete name;
		  len = other.len;
		  name = new char[ len ];
		  CHECK( name != 0 );

		  }
	   strcpy( name, other.name );
	   tel = other.tel;
	   }
    return *this;
}
Queue q;
main()
{
 // test whether the Object can be instantiated
 MyObject *obj1 = new MyObject("Larry", 8675309L );
 MyObject *obj2 = new MyObject("Moe"); // use default number
 MyObject *obj3 = new MyObject("Curly", 5551212L );

 // test using our Object by adding to an Array
 Array myArray(10);
 myArray.ownsElements(0); // Containers can own contained elements
			  // sometimes it is desired to turn off
                          // ownership ( to prevent multiple deletion )
 myArray.add( *obj1 );
 myArray.add( *obj2 );
 myArray.add( *obj3 );
 // display the Array of 'MyObject's
 cout << myArray << endl;

 return 0;
 }

