

//parent class of all the various printer types. contains
//code and variables common to all types
class graphics_printer
{
public:
	static void set_printer_type(int type)
	{
		printer_type = type;
	}

	static void set_printer_port(char * port = "lpt1") //default lpt1
	{
		strcpy(printer_port, port);
	}

	//currently this doesnt do anything, the image size is
	//fixed at about 6.4 inches by 4 inches for a
	//640 by 400 pixel image, but it would be a nice feature...
	static void set_print_size(float width, float height)
	{
		image_width = width;
		image_height = height;
	}
	//figures out what kind of printer object to be and
	//returns a pointer to that object
	static void * allocate_graphics_printer(int pixels_per_line);

	virtual void print_grey_line(char * buffer, int buffer_length);

	//make this virtual so we can reach it through a pointer
	virtual void deallocate_graphics_printer()
	{
	}

protected:
	//data portion of the object
	static int printer_type;
	static char printer_port[20];
	static int port_handle;
	static int image_width;   //the size of the final printed image
	static int image_height;

	//pointer to the input grey line info
	char * grey_line_buffer;
	int grey_line_count;

	int expansion_factor_x;  //expansion factors for expanding
	int expansion_factor_y;  //the grey information
	int len_expanded_lines;  //the expanded line length
	char *expansion_buffer[4]; //4 is the maximum expected expansion

	unsigned char *dither_buffer[2]; //only dither a max of three lines at a time
	unsigned char *completed_dither_buffer; //storage for completed line after dither
	unsigned char *bits_buffer; //storage for one bit per pixel output


	void expand_grey_line();  //generic expansion


	void dither_expanded_line(int line_number);
	void convert_dithered_line_to_bits(void);
	virtual void bits_to_printer(void);


	void send_print_buffer(char * line_buffer, int length);

	void line_feed();
	virtual void open_graphics_printer()
	{
	}
	virtual void close_graphics_printer()
	{
	}

	int serpentine; //flag for which way to scan the dither
};


//derived class from the above, depending on the printer type
class epson_24_graphics_printer:graphics_printer
{
   //give it a constructor for setting up various things
   //pass it the line length so it can alloc the buffers
public:
	epson_24_graphics_printer(int pixels_per_line);

	//make the destructor accessible from a pointer
	virtual void deallocate_graphics_printer(void);


protected:

	//methods (protected)

	virtual void bits_to_printer(void);
	void line_feed();
	void send_graphics_buffer(char * line_buffer, int length);
	virtual void open_graphics_printer(void);
	virtual void close_graphics_printer(void);

	//The printer buffer that will be shipped out to the printer
	char *printer_buffer;

	int pin_number;  //keeps track of which pin we're on

};


//derived class from the above, depending on the printer type
class hp_laser_graphics_printer:graphics_printer
{
   //give it a constructor for setting up various things
   //pass it the line length so it can alloc the buffers
public:
	hp_laser_graphics_printer(int pixels_per_line);

	//make the destructor accessible from a pointer
	virtual void deallocate_graphics_printer(void);


protected:

	//methods (protected)

	virtual void bits_to_printer(void);
	void line_feed();
	void send_graphics_buffer(unsigned char * line_buffer, int length);
	virtual void open_graphics_printer(void);
	virtual void close_graphics_printer(void);

	//The printer buffer that will be shipped out to the printer
	char *printer_buffer;

	int pin_number;  //keeps track of which pin we're on

};



