/*(C) Copyright Roger Bedell - Sylvan Ascent 1990 - 92. All rights reserved.*/
//second try at a printer handler
//This one will only print in 180X180 for 24 pin,
//300dpi for lazerjets
//tbd for 9 pin dot matrix
//uses dithering for PCX files
//re Steve Rimmers book "Bit mapped graphics"

//associated files are graffile.cpp and hpp which have
//the object definition of the graphics file
//and grafprnt.cpp and hpp which define the graphics
//printer objects for the various printer types


#include "time.h"
#include "stdlib.h"
#include "stdio.h"
#include "string.h"
#include "io.h"
#include "grafprnt.hpp"
#include "graffile.hpp"
#include "mem.h"
#include "conio.h"

main (int argc, char * argv[])
{
	if(argc < 2)
	{
#ifdef STANDALONE
		printf("Usage: newprint filename printer_type.\n");
		printf("Filename must have .pcx extension eg. map.pcx\n");
		printf("Printer_type can be one of: EP24 for 24 pin epson\n");
		printf("HP300 for lazerjet at 300dpi\n");
#endif
		exit(0);
	}
#ifdef STANDALONE
	printf("Program (c) Copyright 1991 Roger Bedell.\n");
#endif

	if(strcmp("EP24", argv[2]) == 0 || strcmp("ep24", argv[2]) == 0)
	{
		graphics_printer::set_printer_type(1);
	}
	else if(strcmp("HP300", argv[2]) == 0 || strcmp("hp300", argv[2]) == 0)
	{
		graphics_printer::set_printer_type(2);
	}
	else
	{
#ifdef STANDALONE
		printf("Must select EP24 or HP300 as second parameter.\n");
#endif
		exit (0);
	}
	pcx_graphics_file test_file(argv[1]);
	test_file . print_file();
	return 0;
}


//generic error routine
int error_message(char *message, int fatal_or_nonfatal)
{
#ifdef STANDALONE
	printf(message);
#endif
	return 0;
}


int check_for_user_input(void); //external function for allowing user abort

//DOS check for input routine
//checks for a user abort of printing
int check_for_user_input(void)
{
	if(kbhit())
	{
		return 1;
	}
	else
	{
		return 0;
	}
}

